/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.properties;

import com.atlassw.tools.eclipse.checkstyle.builder.CheckstyleBuilder;
import com.atlassw.tools.eclipse.checkstyle.config.FileSet;
import com.atlassw.tools.eclipse.checkstyle.config.FileSetFactory;
import com.atlassw.tools.eclipse.checkstyle.properties.FileSetEditDialog;
import com.atlassw.tools.eclipse.checkstyle.properties.FileSetLabelProvider;
import com.atlassw.tools.eclipse.checkstyle.properties.FileSetProvider;
import com.atlassw.tools.eclipse.checkstyle.properties.FileSetViewerSorter;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstyleLog;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstylePluginException;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.PropertyPage;

public class CheckstylePropertyPage
extends PropertyPage {
    private IProject mProject;
    private Composite mComposite;
    private CheckboxTableViewer mViewer;
    private Button mAddButton;
    private Button mEditButton;
    private Button mRemoveButton;
    private List mFileSets;
    private boolean mNeedRebuild = false;

    protected Control createContents(Composite composite) {
        FileSet fileSet;
        this.mComposite = composite;
        this.noDefaultAndApplyButton();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        IResource iResource = (IResource)this.getElement();
        if (iResource.getType() != 4) {
            return composite;
        }
        this.mProject = (IProject)iResource;
        if (!this.initializeFileSets()) {
            CheckstyleLog.internalErrorDialog();
            return null;
        }
        Table table = new Table(composite2, 67616);
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(60);
        gridData.heightHint = this.convertHeightInCharsToPixels(10);
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setText("Enabled");
        tableColumn.setResizable(false);
        TableColumn tableColumn2 = new TableColumn(table, 0);
        tableColumn2.setText("File Set");
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(12));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(48));
        this.mViewer = new CheckboxTableViewer(table);
        this.mViewer.setLabelProvider((IBaseLabelProvider)new FileSetLabelProvider());
        this.mViewer.setContentProvider((IContentProvider)new FileSetProvider());
        this.mViewer.setSorter((ViewerSorter)new FileSetViewerSorter());
        this.mViewer.setInput((Object)this.mFileSets);
        Iterator iterator = this.mFileSets.iterator();
        while (iterator.hasNext()) {
            fileSet = (FileSet)iterator.next();
            this.mViewer.setChecked((Object)fileSet, fileSet.isEnabled());
        }
        this.mViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                CheckstylePropertyPage.this.editFileSet();
            }
        });
        this.mViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                CheckstylePropertyPage.this.changeEnabledState(checkStateChangedEvent);
            }
        });
        fileSet = new Composite(composite2, 0);
        fileSet.setLayoutData(new GridData(2));
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        fileSet.setLayout((Layout)gridLayout);
        this.mAddButton = this.createPushButton((Composite)fileSet, "Add...");
        this.mAddButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CheckstylePropertyPage.this.addFileSet();
            }
        });
        this.mEditButton = this.createPushButton((Composite)fileSet, "Edit...");
        this.mEditButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CheckstylePropertyPage.this.editFileSet();
            }
        });
        this.mRemoveButton = this.createPushButton((Composite)fileSet, "Remove");
        this.mRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CheckstylePropertyPage.this.removeFileSet();
            }
        });
        return composite2;
    }

    public boolean performOk() {
        try {
            FileSetFactory.setFileSets(this.mFileSets, this.mProject);
        }
        catch (CheckstylePluginException checkstylePluginException) {
            CheckstyleLog.error("Failed to save FileSets: " + checkstylePluginException.getMessage(), checkstylePluginException);
            CheckstyleLog.internalErrorDialog();
        }
        try {
            this.addNature();
        }
        catch (CheckstylePluginException checkstylePluginException) {
            CheckstyleLog.error("Failed to add project nature: " + checkstylePluginException.getMessage(), checkstylePluginException);
            CheckstyleLog.internalErrorDialog();
        }
        if (this.mNeedRebuild) {
            try {
                CheckstyleBuilder.buildProject(this.mProject, this.mComposite.getShell());
            }
            catch (CheckstylePluginException checkstylePluginException) {
                CheckstyleLog.error("Failed to rebuild project: " + checkstylePluginException.getMessage(), checkstylePluginException);
                CheckstyleLog.internalErrorDialog();
            }
        }
        return true;
    }

    private Button createPushButton(Composite composite, String string) {
        Button button = new Button(composite, 8);
        button.setText(string);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        button.setLayoutData((Object)gridData);
        return button;
    }

    private void addFileSet() {
        try {
            FileSetEditDialog fileSetEditDialog = new FileSetEditDialog(this.mComposite.getShell(), null, this.mProject);
            fileSetEditDialog.open();
            if (fileSetEditDialog.okWasPressed()) {
                FileSet fileSet = fileSetEditDialog.getFileSet();
                this.mFileSets.add(fileSet);
                this.mViewer.refresh();
                this.mViewer.setChecked((Object)fileSet, fileSet.isEnabled());
                this.mNeedRebuild = true;
            }
        }
        catch (CheckstylePluginException checkstylePluginException) {
            CheckstyleLog.error("Failed to add FileSet: " + checkstylePluginException.getMessage(), checkstylePluginException);
            CheckstyleLog.internalErrorDialog();
        }
    }

    private void editFileSet() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.mViewer.getSelection();
        FileSet fileSet = (FileSet)iStructuredSelection.getFirstElement();
        if (fileSet == null) {
            return;
        }
        try {
            FileSetEditDialog fileSetEditDialog = new FileSetEditDialog(this.mComposite.getShell(), fileSet, this.mProject);
            fileSetEditDialog.open();
            if (fileSetEditDialog.okWasPressed()) {
                FileSet fileSet2 = fileSetEditDialog.getFileSet();
                this.mFileSets.remove(fileSet);
                this.mFileSets.add(fileSet2);
                this.mViewer.refresh();
                this.mViewer.setChecked((Object)fileSet2, fileSet2.isEnabled());
                this.mNeedRebuild = true;
            }
        }
        catch (CheckstylePluginException checkstylePluginException) {
            CheckstyleLog.error("Failed to edit FileSet: " + checkstylePluginException.getMessage(), checkstylePluginException);
            CheckstyleLog.internalErrorDialog();
        }
    }

    private void removeFileSet() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.mViewer.getSelection();
        FileSet fileSet = (FileSet)iStructuredSelection.getFirstElement();
        if (fileSet == null) {
            return;
        }
        this.mFileSets.remove(fileSet);
        this.mViewer.refresh();
        this.mNeedRebuild = true;
    }

    private void changeEnabledState(CheckStateChangedEvent checkStateChangedEvent) {
        if (checkStateChangedEvent.getElement() instanceof FileSet) {
            FileSet fileSet = (FileSet)checkStateChangedEvent.getElement();
            fileSet.setEnabled(checkStateChangedEvent.getChecked());
            this.mViewer.refresh();
            this.mNeedRebuild = true;
        } else {
            CheckstyleLog.warning("Checked element in FileSet table not a FileSet");
        }
    }

    private void addNature() throws CheckstylePluginException {
        try {
            if (this.mProject.getNature("com.atlassw.tools.eclipse.checkstyle.CheckstyleNature") != null) {
                return;
            }
            AddNature addNature = new AddNature(this.mProject);
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
            progressMonitorDialog.run(true, true, (IRunnableWithProgress)addNature);
        }
        catch (InvocationTargetException invocationTargetException) {
            CheckstyleLog.error("Failed to add Checkstyle nature to project", invocationTargetException);
            throw new CheckstylePluginException("Failed to add Checkstyle nature to project");
        }
        catch (InterruptedException interruptedException) {
            CheckstyleLog.error("Failed to add Checkstyle nature to project", interruptedException);
            throw new CheckstylePluginException("Failed to add Checkstyle nature to project");
        }
        catch (CoreException coreException) {
            CheckstyleLog.error("Failed to add Checkstyle nature to project", coreException);
            throw new CheckstylePluginException("Failed to add Checkstyle nature to project");
        }
    }

    private boolean initializeFileSets() {
        this.mFileSets = null;
        try {
            List list = FileSetFactory.getFileSets(this.mProject);
            this.mFileSets = new LinkedList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FileSet fileSet = (FileSet)iterator.next();
                fileSet = (FileSet)fileSet.clone();
                this.mFileSets.add(fileSet);
            }
        }
        catch (CheckstylePluginException checkstylePluginException) {
            CheckstyleLog.error("Failed get FileSets, " + checkstylePluginException.getMessage(), checkstylePluginException);
            this.mFileSets = null;
            return false;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            CheckstyleLog.error("Failed to clone FileSet, " + cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            this.mFileSets = null;
            return false;
        }
        return true;
    }

    private class AddNature
    implements IRunnableWithProgress {
        private IProject mProject;

        public AddNature(IProject iProject) {
            this.mProject = iProject;
        }

        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
            try {
                IProjectDescription iProjectDescription = this.mProject.getDescription();
                String[] stringArray = iProjectDescription.getNatureIds();
                String[] stringArray2 = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                stringArray2[stringArray.length] = "com.atlassw.tools.eclipse.checkstyle.CheckstyleNature";
                iProjectDescription.setNatureIds(stringArray2);
                this.mProject.setDescription(iProjectDescription, iProgressMonitor);
            }
            catch (CoreException coreException) {
                throw new InvocationTargetException(coreException);
            }
        }
    }
}

