/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.preferences;

import com.atlassw.tools.eclipse.checkstyle.config.RuleMetadata;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstylePluginException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RuleSelectionDialog
extends Dialog {
    private static final int MAX_LENGTH = 80;
    private Composite mParentComposite;
    private boolean mOkWasPressed = false;
    private List mMetadataList;
    private Combo mComboItem;
    private TextViewer mRuleDescriptionText;
    private RuleMetadata mFinalSelection = null;

    RuleSelectionDialog(Shell shell, List list) throws CheckstylePluginException {
        super(shell);
        this.mMetadataList = list;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2;
        Composite composite3 = (Composite)super.createDialogArea(composite);
        this.mParentComposite = composite2 = new Composite(composite3, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this.createCombo(composite2);
        this.createRuleDescription(composite2);
        this.mComboItem.select(0);
        this.setDescription(0);
        composite2.layout();
        return composite3;
    }

    private void createCombo(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Select Rule:");
        String[] stringArray = new String[this.mMetadataList.size()];
        Iterator iterator = this.mMetadataList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            RuleMetadata ruleMetadata = (RuleMetadata)iterator.next();
            stringArray[n] = " " + ruleMetadata.getRuleName() + " ";
            ++n;
        }
        this.mComboItem = new Combo(composite2, 12);
        this.mComboItem.setLayoutData((Object)new GridData(256));
        this.mComboItem.setItems(stringArray);
        this.mComboItem.addSelectionListener((SelectionListener)new ComboSelectionListener());
    }

    private void createRuleDescription(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Rule Description");
        this.mRuleDescriptionText = new TextViewer(composite2, 2624);
        Control control = this.mRuleDescriptionText.getControl();
        GridData gridData = new GridData(1808);
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        gridData.widthHint = this.convertWidthInCharsToPixels(80);
        gridData.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)gridData);
    }

    protected void okPressed() {
        this.mOkWasPressed = true;
        int n = this.mComboItem.getSelectionIndex();
        this.mFinalSelection = (RuleMetadata)this.mMetadataList.get(n);
        super.okPressed();
    }

    boolean okWasPressed() {
        return this.mOkWasPressed;
    }

    RuleMetadata getSelectedRule() {
        return this.mFinalSelection;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Checkstyle Rule Selection");
    }

    private void setDescription(int n) {
        RuleMetadata ruleMetadata = (RuleMetadata)this.mMetadataList.get(n);
        Document document = new Document(ruleMetadata.getDescription());
        this.mRuleDescriptionText.setDocument((IDocument)document);
    }

    private class ComboSelectionListener
    implements SelectionListener {
        private ComboSelectionListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            RuleSelectionDialog.this.setDescription(RuleSelectionDialog.this.mComboItem.getSelectionIndex());
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            RuleSelectionDialog.this.setDescription(RuleSelectionDialog.this.mComboItem.getSelectionIndex());
        }
    }
}

