/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.preferences;

import com.atlassw.tools.eclipse.checkstyle.config.ConfigProperty;
import com.atlassw.tools.eclipse.checkstyle.config.ConfigPropertyMetadata;
import com.atlassw.tools.eclipse.checkstyle.config.ConfigPropertyType;
import com.atlassw.tools.eclipse.checkstyle.preferences.ConfigPropertyWidgetFactory;
import com.atlassw.tools.eclipse.checkstyle.preferences.IConfigPropertyWidget;
import com.atlassw.tools.eclipse.checkstyle.preferences.RuleConfigWorkingCopy;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstyleLog;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstylePluginException;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RuleConfigurationEditDialog
extends Dialog {
    private static final int MAX_INPUT_LENGTH = 40;
    private static final String[] SEVERITY_LABELS = new String[]{SeverityLevel.IGNORE.getName(), SeverityLevel.INFO.getName(), SeverityLevel.WARNING.getName(), SeverityLevel.ERROR.getName()};
    private Composite mParentComposite;
    private RuleConfigWorkingCopy mRule;
    private RuleConfigWorkingCopy mFinalRule;
    private Text mCommentText;
    private Combo mSeverityCombo;
    private IConfigPropertyWidget[] mConfigPropertyWidgets;
    private boolean mOkWasPressed = false;

    RuleConfigurationEditDialog(Shell shell, RuleConfigWorkingCopy ruleConfigWorkingCopy) throws CheckstylePluginException {
        super(shell);
        this.mRule = ruleConfigWorkingCopy;
        try {
            this.mFinalRule = (RuleConfigWorkingCopy)ruleConfigWorkingCopy.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            CheckstyleLog.error("Failed to clone RuleConfigWorkingCopy", cloneNotSupportedException);
            throw new CheckstylePluginException("Failed to clone RuleConfigWorkingCopy");
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2;
        Composite composite3 = (Composite)super.createDialogArea(composite);
        this.mParentComposite = composite2 = new Composite(composite3, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this.createRuleNameLable(composite2);
        this.createComment(composite2);
        this.createSeveritySelection(composite2);
        this.createConfigPropertyEntries(composite2);
        composite2.layout();
        return composite3;
    }

    protected void okPressed() {
        String string;
        SeverityLevel severityLevel = this.mRule.getSeverityLevel();
        try {
            string = this.mSeverityCombo.getItem(this.mSeverityCombo.getSelectionIndex());
            severityLevel = SeverityLevel.getInstance((String)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            CheckstyleLog.warning("Invalid severity level found, using original value", illegalArgumentException);
        }
        string = this.mCommentText.getText();
        HashMap<String, ConfigProperty> hashMap = new HashMap<String, ConfigProperty>();
        if (this.mConfigPropertyWidgets != null) {
            for (int i = 0; i < this.mConfigPropertyWidgets.length; ++i) {
                IConfigPropertyWidget iConfigPropertyWidget = this.mConfigPropertyWidgets[i];
                ConfigProperty configProperty = this.buildConfigProperty(iConfigPropertyWidget);
                if (configProperty == null) {
                    return;
                }
                hashMap.put(configProperty.getName(), configProperty);
            }
        }
        this.mFinalRule.setConfigItems(hashMap);
        this.mFinalRule.setSeverityLevel(severityLevel);
        this.mFinalRule.setRuleComment(string);
        this.mOkWasPressed = true;
        super.okPressed();
    }

    private ConfigProperty buildConfigProperty(IConfigPropertyWidget iConfigPropertyWidget) {
        String string = iConfigPropertyWidget.getValue();
        boolean bl = this.validatePropertyValue(string, iConfigPropertyWidget.getMetadata());
        if (!bl) {
            String string2 = "Invalid value for property " + iConfigPropertyWidget.getMetadata().getName();
            MessageDialog.openError((Shell)this.mParentComposite.getShell(), (String)"Invalid Property Value", (String)string2);
            return null;
        }
        ConfigProperty configProperty = new ConfigProperty(iConfigPropertyWidget.getMetadata().getName(), string);
        return configProperty;
    }

    private void createRuleNameLable(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Rule: " + this.mRule.getRuleName());
    }

    private void createComment(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Comment:");
        this.mCommentText = new Text(composite2, 2052);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        gridData.heightHint = this.convertHeightInCharsToPixels(1);
        this.mCommentText.setLayoutData((Object)gridData);
        this.mCommentText.setFont(composite.getFont());
        String string = this.mRule.getRuleComment();
        if (string != null) {
            this.mCommentText.setText(string);
        }
    }

    private void createSeveritySelection(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Severity: ");
        this.mSeverityCombo = new Combo(composite2, 12);
        this.mSeverityCombo.setLayoutData((Object)new GridData(256));
        this.mSeverityCombo.setItems(SEVERITY_LABELS);
        this.mSeverityCombo.select(this.severityToComboPosition(this.mRule.getSeverityLevel()));
    }

    private void createConfigPropertyEntries(Composite composite) {
        List list = this.mRule.getConfigItemMetadata();
        if (list.size() <= 0) {
            return;
        }
        Label label = new Label(composite, 0);
        label.setText("Properties:");
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.mConfigPropertyWidgets = new IConfigPropertyWidget[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            ConfigPropertyMetadata configPropertyMetadata = (ConfigPropertyMetadata)iterator.next();
            ConfigProperty configProperty = this.mRule.getConfigProperty(configPropertyMetadata.getName());
            this.mConfigPropertyWidgets[n] = ConfigPropertyWidgetFactory.createWidget(composite2, configPropertyMetadata, configProperty);
            ++n;
        }
    }

    private int severityToComboPosition(SeverityLevel severityLevel) {
        int n = 0;
        String string = severityLevel.getName();
        for (int i = 0; i < SEVERITY_LABELS.length; ++i) {
            if (!string.equals(SEVERITY_LABELS[i])) continue;
            n = i;
            break;
        }
        return n;
    }

    RuleConfigWorkingCopy getFinalRule() {
        return this.mFinalRule;
    }

    private boolean validatePropertyValue(String string, ConfigPropertyMetadata configPropertyMetadata) {
        boolean bl = true;
        if (string == null) {
            return false;
        }
        ConfigPropertyType configPropertyType = configPropertyMetadata.getDatatype();
        if (configPropertyType.equals(ConfigPropertyType.STRING)) {
            bl = true;
        } else if (configPropertyType.equals(ConfigPropertyType.INTEGER)) {
            try {
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        } else if (configPropertyType.equals(ConfigPropertyType.SINGLE_SELECT) || configPropertyType.equals(ConfigPropertyType.MULTI_CHECK) || configPropertyType.equals(ConfigPropertyType.BOOLEAN) || configPropertyType.equals(ConfigPropertyType.HIDDEN)) {
            bl = true;
        } else {
            CheckstyleLog.warning("Unknown property type: " + configPropertyType.getLabel());
        }
        return bl;
    }

    public boolean okWasPressed() {
        return this.mOkWasPressed;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Checkstyle Rule Configuration Editor");
    }
}

