/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.preferences;

import com.atlassw.tools.eclipse.checkstyle.config.CheckConfiguration;
import com.atlassw.tools.eclipse.checkstyle.config.CheckConfigurationFactory;
import com.atlassw.tools.eclipse.checkstyle.config.FileSetFactory;
import com.atlassw.tools.eclipse.checkstyle.config.MetadataFactory;
import com.atlassw.tools.eclipse.checkstyle.config.RuleConfiguration;
import com.atlassw.tools.eclipse.checkstyle.config.RuleGroupMetadata;
import com.atlassw.tools.eclipse.checkstyle.config.RuleMetadata;
import com.atlassw.tools.eclipse.checkstyle.preferences.RuleConfigWorkingCopy;
import com.atlassw.tools.eclipse.checkstyle.preferences.RuleConfigurationEditDialog;
import com.atlassw.tools.eclipse.checkstyle.preferences.RuleConfigurationLabelProvider;
import com.atlassw.tools.eclipse.checkstyle.preferences.RuleConfigurationProvider;
import com.atlassw.tools.eclipse.checkstyle.preferences.RuleConfigurationViewerSorter;
import com.atlassw.tools.eclipse.checkstyle.preferences.RuleSelectionDialog;
import com.atlassw.tools.eclipse.checkstyle.preferences.TabFolderLayout;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstyleLog;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstylePluginException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class CheckConfigurationEditDialog
extends Dialog {
    private static final int MAX_LENGTH = 40;
    private Composite mParentComposite;
    private CheckConfiguration mCheckConfiguration;
    private TabFolder mTabFolder;
    private TabItem[] mTabItems;
    private TableViewer[] mTableViewers;
    private Text mConfigNameText;
    private TextViewer mRuleDescriptionText;
    private List[] mRuleConfigWorkingCopies;
    private Button mConfigureButton;
    private RuleConfigWorkingCopy mCurrentSelection;
    private String mCheckConfigName;
    private boolean mOkWasPressed = false;
    private List mCurrentCheckConfigs;

    CheckConfigurationEditDialog(Shell shell, CheckConfiguration checkConfiguration, List list) throws CheckstylePluginException {
        super(shell);
        this.mCurrentCheckConfigs = list;
        if (checkConfiguration == null) {
            this.mCheckConfiguration = CheckConfigurationFactory.getNewInstance();
        } else {
            try {
                this.mCheckConfiguration = (CheckConfiguration)checkConfiguration.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                String string = "Failed to clone CheckConfiguration";
                CheckstyleLog.error(string, cloneNotSupportedException);
                throw new CheckstylePluginException(string);
            }
        }
        this.buildRuleConfigWorkingCopies(shell);
    }

    private void buildRuleConfigWorkingCopies(Shell shell) {
        List list = MetadataFactory.getRuleGroupMetadata();
        this.mRuleConfigWorkingCopies = new LinkedList[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.mRuleConfigWorkingCopies[i] = new LinkedList();
        }
        if (this.mCheckConfiguration != null) {
            Iterator iterator = this.mCheckConfiguration.getRuleConfigs().iterator();
            while (iterator.hasNext()) {
                RuleConfiguration ruleConfiguration = (RuleConfiguration)iterator.next();
                try {
                    ruleConfiguration = (RuleConfiguration)ruleConfiguration.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    CheckstyleLog.warning("Failed to clone RuleConfiguration");
                    CheckstyleLog.internalErrorDialog();
                }
                RuleMetadata ruleMetadata = this.getRuleMetadata(ruleConfiguration);
                RuleConfigWorkingCopy ruleConfigWorkingCopy = new RuleConfigWorkingCopy(ruleMetadata, ruleConfiguration);
                int n = ruleMetadata.getGroupIndex();
                if (n >= 0 && n < this.mRuleConfigWorkingCopies.length) {
                    this.mRuleConfigWorkingCopies[n].add(ruleConfigWorkingCopy);
                    continue;
                }
                String string = "Invalid group index for check rule, ignoring rule. class=" + ruleConfiguration.getImplClassname();
                CheckstyleLog.warning(string);
            }
        }
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2;
        Composite composite3 = (Composite)super.createDialogArea(composite);
        this.mParentComposite = composite2 = new Composite(composite3, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this.buildConfigNameField(composite2);
        this.buildRuleGroupTabs(composite2);
        this.buildButtons(composite2);
        this.buildDescriptionArea(composite2);
        composite2.layout();
        return composite3;
    }

    protected void okPressed() {
        String string = this.mConfigNameText.getText().trim();
        if (string == null || string.length() == 0) {
            MessageDialog.openError((Shell)this.mParentComposite.getShell(), (String)"Invalid Value", (String)"An check configuration name must be entered");
            return;
        }
        if (!string.equals(this.mCheckConfiguration.getConfigName())) {
            boolean bl = this.isNameInUse(string);
            if (bl) {
                MessageDialog.openError((Shell)this.mParentComposite.getShell(), (String)"Invalid Value", (String)("The check configuration name '" + string + "' is already in use, please choose a different name."));
                return;
            }
            try {
                bl = FileSetFactory.isCheckConfigInUse(this.mCheckConfiguration.getConfigName());
            }
            catch (CheckstylePluginException checkstylePluginException) {
                CheckstyleLog.warning("Error checking CheckConfiguration name in use", checkstylePluginException);
                CheckstyleLog.internalErrorDialog(this.mParentComposite.getShell());
            }
            if (bl) {
                MessageDialog.openError((Shell)this.mParentComposite.getShell(), (String)"Invalid Value", (String)("The check configuration name '" + string + "' is referenced by a project File Set and can not be changed."));
                return;
            }
        }
        this.mCheckConfigName = string;
        this.mOkWasPressed = true;
        super.okPressed();
    }

    CheckConfiguration getFinalConfiguration() {
        this.mCheckConfiguration.setName(this.mCheckConfigName);
        LinkedList<RuleConfiguration> linkedList = new LinkedList<RuleConfiguration>();
        for (int i = 0; i < this.mRuleConfigWorkingCopies.length; ++i) {
            Iterator iterator = this.mRuleConfigWorkingCopies[i].iterator();
            while (iterator.hasNext()) {
                RuleConfigWorkingCopy ruleConfigWorkingCopy = (RuleConfigWorkingCopy)iterator.next();
                RuleConfiguration ruleConfiguration = ruleConfigWorkingCopy.getRuleConfig();
                linkedList.add(ruleConfiguration);
            }
        }
        this.mCheckConfiguration.setRuleConfigs(linkedList);
        return this.mCheckConfiguration;
    }

    private void buildConfigNameField(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Audit Configuration Name:");
        this.mConfigNameText = new Text(composite2, 2052);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        gridData.heightHint = this.convertHeightInCharsToPixels(1);
        this.mConfigNameText.setLayoutData((Object)gridData);
        this.mConfigNameText.setFont(composite.getFont());
        String string = this.mCheckConfiguration.getConfigName();
        if (string != null) {
            this.mConfigNameText.setText(string);
        }
    }

    private void buildRuleGroupTabs(Composite composite) {
        this.mTabFolder = new TabFolder(composite, 0);
        this.mTabFolder.setLayout((Layout)new TabFolderLayout());
        List list = MetadataFactory.getRuleGroupMetadata();
        this.mTabItems = new TabItem[list.size()];
        this.mTableViewers = new TableViewer[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            TabItem tabItem;
            this.mTabItems[n] = tabItem = new TabItem(this.mTabFolder, 0);
            RuleGroupMetadata ruleGroupMetadata = (RuleGroupMetadata)iterator.next();
            tabItem.setText(ruleGroupMetadata.getGroupName());
            Composite composite2 = this.createTabItemComposite((Composite)this.mTabFolder, ruleGroupMetadata, n);
            tabItem.setControl((Control)composite2);
            ++n;
        }
        this.mTabFolder.setSelection(0);
        this.mTabFolder.addSelectionListener((SelectionListener)new TabSelectionListener());
    }

    private Composite createTabItemComposite(Composite composite, RuleGroupMetadata ruleGroupMetadata, int n) {
        TableViewer tableViewer;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        Table table = new Table(composite2, 67588);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData(1808);
        gridData.widthHint = this.convertWidthInCharsToPixels(80);
        gridData.heightHint = this.convertHeightInCharsToPixels(20);
        table.setLayoutData((Object)gridData);
        table.addSelectionListener((SelectionListener)new TableSelectionListener());
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setText("Severity");
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        TableColumn tableColumn2 = new TableColumn(table, 0);
        tableColumn2.setText("Rule");
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30));
        TableColumn tableColumn3 = new TableColumn(table, 0);
        tableColumn3.setText("Comment");
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        this.mTableViewers[n] = tableViewer = new TableViewer(table);
        tableViewer.setLabelProvider((IBaseLabelProvider)new RuleConfigurationLabelProvider());
        tableViewer.setContentProvider((IContentProvider)new RuleConfigurationProvider());
        tableViewer.setInput((Object)this.mRuleConfigWorkingCopies[n]);
        tableViewer.setSorter((ViewerSorter)new RuleConfigurationViewerSorter());
        tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                CheckConfigurationEditDialog.this.editRule();
            }
        });
        return composite2;
    }

    private void ruleSelected(SelectionEvent selectionEvent) {
        int n = this.mTabFolder.getSelectionIndex();
        TableViewer tableViewer = this.mTableViewers[n];
        IStructuredSelection iStructuredSelection = (IStructuredSelection)tableViewer.getSelection();
        this.mCurrentSelection = (RuleConfigWorkingCopy)iStructuredSelection.getFirstElement();
        Document document = new Document(this.mCurrentSelection.getRuleDescription());
        this.mRuleDescriptionText.setDocument((IDocument)document);
    }

    private void tabSelected(SelectionEvent selectionEvent) {
        int n = this.mTabFolder.getSelectionIndex();
        TableViewer tableViewer = this.mTableViewers[n];
        tableViewer.setSelection((ISelection)StructuredSelection.EMPTY, true);
        Document document = new Document("");
        this.mRuleDescriptionText.setDocument((IDocument)document);
    }

    private void buildButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        this.buildAddButton(composite2);
        this.buildEditButton(composite2);
        this.buildDeleteButton(composite2);
    }

    private void buildAddButton(Composite composite) {
        this.mConfigureButton = new Button(composite, 8);
        this.mConfigureButton.setText("Add Rule");
        this.mConfigureButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CheckConfigurationEditDialog.this.addRule();
            }
        });
    }

    private void buildEditButton(Composite composite) {
        this.mConfigureButton = new Button(composite, 8);
        this.mConfigureButton.setText("Edit Rule");
        this.mConfigureButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CheckConfigurationEditDialog.this.editRule();
            }
        });
    }

    private void buildDeleteButton(Composite composite) {
        this.mConfigureButton = new Button(composite, 8);
        this.mConfigureButton.setText("Delete Rule");
        this.mConfigureButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CheckConfigurationEditDialog.this.deleteRule();
            }
        });
    }

    private void buildDescriptionArea(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Rule Description");
        this.mRuleDescriptionText = new TextViewer(composite, 2624);
        Control control = this.mRuleDescriptionText.getControl();
        GridData gridData = new GridData(1808);
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        gridData.grabExcessVerticalSpace = false;
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        gridData.heightHint = this.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)gridData);
    }

    private void addRule() {
        int n = this.mTabFolder.getSelectionIndex();
        RuleGroupMetadata ruleGroupMetadata = (RuleGroupMetadata)MetadataFactory.getRuleGroupMetadata().get(n);
        List list = ruleGroupMetadata.getRuleMetadata();
        if (list.size() <= 0) {
            return;
        }
        RuleSelectionDialog ruleSelectionDialog = null;
        try {
            ruleSelectionDialog = new RuleSelectionDialog(this.mParentComposite.getShell(), list);
            ruleSelectionDialog.open();
        }
        catch (CheckstylePluginException checkstylePluginException) {
            CheckstyleLog.error("Failed to open RuleSelectionDialog, " + checkstylePluginException.getMessage(), checkstylePluginException);
            CheckstyleLog.internalErrorDialog();
            return;
        }
        RuleMetadata ruleMetadata = ruleSelectionDialog.getSelectedRule();
        if (ruleMetadata != null) {
            this.mCurrentSelection = new RuleConfigWorkingCopy(ruleMetadata, null);
            this.editRule();
        }
    }

    private void editRule() {
        if (this.mCurrentSelection == null) {
            return;
        }
        RuleConfigurationEditDialog ruleConfigurationEditDialog = null;
        try {
            ruleConfigurationEditDialog = new RuleConfigurationEditDialog(this.mParentComposite.getShell(), this.mCurrentSelection);
            ruleConfigurationEditDialog.open();
        }
        catch (CheckstylePluginException checkstylePluginException) {
            CheckstyleLog.error("Failed to open RuleConfigurationEditDialog, " + checkstylePluginException.getMessage(), checkstylePluginException);
            CheckstyleLog.internalErrorDialog();
            return;
        }
        if (ruleConfigurationEditDialog.okWasPressed()) {
            RuleConfigWorkingCopy ruleConfigWorkingCopy = ruleConfigurationEditDialog.getFinalRule();
            int n = this.mTabFolder.getSelectionIndex();
            this.mRuleConfigWorkingCopies[n].remove(this.mCurrentSelection);
            this.mRuleConfigWorkingCopies[n].add(ruleConfigWorkingCopy);
            this.mCurrentSelection = ruleConfigWorkingCopy;
            this.mTableViewers[n].setSelection((ISelection)new StructuredSelection((Object)ruleConfigWorkingCopy), true);
            this.mTableViewers[n].refresh(true);
        }
    }

    private void deleteRule() {
        if (this.mCurrentSelection == null) {
            return;
        }
        boolean bl = MessageDialog.openQuestion((Shell)this.mParentComposite.getShell(), (String)"Confirm Delete", (String)("Delete rule '" + this.mCurrentSelection.getRuleName() + "'?"));
        if (bl) {
            int n = this.mTabFolder.getSelectionIndex();
            this.mRuleConfigWorkingCopies[n].remove(this.mCurrentSelection);
            this.mCurrentSelection = null;
            this.mTableViewers[n].refresh(true);
        }
    }

    public boolean okWasPressed() {
        return this.mOkWasPressed;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Checkstyle Check Configuration Editor");
    }

    private RuleMetadata getRuleMetadata(RuleConfiguration ruleConfiguration) {
        return MetadataFactory.getRuleMetadata(ruleConfiguration);
    }

    private boolean isNameInUse(String string) {
        boolean bl = false;
        Iterator iterator = this.mCurrentCheckConfigs.iterator();
        while (iterator.hasNext()) {
            CheckConfiguration checkConfiguration = (CheckConfiguration)iterator.next();
            if (!checkConfiguration.getName().equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private class TabSelectionListener
    implements SelectionListener {
        private TabSelectionListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            CheckConfigurationEditDialog.this.tabSelected(selectionEvent);
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            this.widgetSelected(selectionEvent);
        }
    }

    private class TableSelectionListener
    implements SelectionListener {
        private TableSelectionListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            CheckConfigurationEditDialog.this.ruleSelected(selectionEvent);
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            this.widgetSelected(selectionEvent);
        }
    }
}

