/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.config;

import com.atlassw.tools.eclipse.checkstyle.config.ConfigPropertyMetadata;
import com.atlassw.tools.eclipse.checkstyle.config.ConfigPropertyType;
import com.atlassw.tools.eclipse.checkstyle.config.RuleConfiguration;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstyleLog;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstylePluginException;
import com.atlassw.tools.eclipse.checkstyle.util.XMLUtil;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RuleMetadata
implements Cloneable {
    private String mCheckImplClassname;
    private String mName;
    private String mDescription;
    private SeverityLevel mDefaultSeverityLevel = SeverityLevel.WARNING;
    private List mConfigPropMetadata = new LinkedList();
    private int mGroupIndex = -1;

    RuleMetadata(Node node) throws CheckstylePluginException {
        Node node2;
        String string = XMLUtil.getNodeAttributeValue(node, "name");
        if (string != null) {
            this.mName = string.trim();
        }
        if ((string = XMLUtil.getNodeAttributeValue(node, "classname")) != null) {
            this.mCheckImplClassname = string.trim();
        }
        if ((string = XMLUtil.getNodeAttributeValue(node, "default-severity")) != null) {
            this.mDefaultSeverityLevel = SeverityLevel.getInstance((String)string.trim());
        }
        if ((node2 = XMLUtil.getChildNode(node, "description")) != null && (string = XMLUtil.getNodeTextValue(node2)) != null) {
            this.mDescription = string.trim();
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node3 = nodeList.item(i);
            if (!node3.getNodeName().equals("property-metadata")) continue;
            ConfigPropertyMetadata configPropertyMetadata = null;
            try {
                configPropertyMetadata = new ConfigPropertyMetadata(node3);
            }
            catch (CheckstylePluginException checkstylePluginException) {
                CheckstyleLog.warning("Failed to get configuration property metadata, " + checkstylePluginException.getMessage(), checkstylePluginException);
            }
            if (configPropertyMetadata == null) continue;
            this.mConfigPropMetadata.add(configPropertyMetadata);
        }
    }

    RuleMetadata(RuleConfiguration ruleConfiguration) {
        this.mCheckImplClassname = ruleConfiguration.getImplClassname();
        this.mName = this.classToRuleName(this.mCheckImplClassname);
        this.mDescription = "";
        this.mDefaultSeverityLevel = ruleConfiguration.getSeverityLevel();
        String[] stringArray = ruleConfiguration.getAttributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.equals("severity")) continue;
            String string2 = ruleConfiguration.getConfigProperty(string).getValue();
            ConfigPropertyMetadata configPropertyMetadata = new ConfigPropertyMetadata(ConfigPropertyType.STRING, string, string2);
            this.mConfigPropMetadata.add(configPropertyMetadata);
        }
    }

    public SeverityLevel getDefaultSeverityLevel() {
        return this.mDefaultSeverityLevel;
    }

    public String getCheckImplClassname() {
        return this.mCheckImplClassname;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getRuleName() {
        return this.mName;
    }

    public List getConfigItemMetadata() {
        return this.mConfigPropMetadata;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int getGroupIndex() {
        return this.mGroupIndex;
    }

    public void setGroupIndex(int n) {
        this.mGroupIndex = n;
    }

    private String classToRuleName(String string) {
        String string2 = "Unknown";
        int n = string.lastIndexOf(".");
        string2 = string.substring(n + 1, string.length());
        return string2;
    }
}

