/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.config;

import com.atlassw.tools.eclipse.checkstyle.util.CheckstylePluginException;

public final class ConfigPropertyType {
    public static final ConfigPropertyType STRING = new ConfigPropertyType(10, "String");
    public static final ConfigPropertyType STRING_ARRAY = new ConfigPropertyType(20, "StringArray");
    public static final ConfigPropertyType INTEGER = new ConfigPropertyType(30, "Integer");
    public static final ConfigPropertyType SINGLE_SELECT = new ConfigPropertyType(40, "SingleSelect");
    public static final ConfigPropertyType BOOLEAN = new ConfigPropertyType(50, "Boolean");
    public static final ConfigPropertyType MULTI_CHECK = new ConfigPropertyType(60, "MultiCheck");
    public static final ConfigPropertyType HIDDEN = new ConfigPropertyType(70, "Hidden");
    private String mLabel;
    private int mValue;

    private ConfigPropertyType(int n, String string) {
        this.mValue = n;
        this.mLabel = string;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof ConfigPropertyType && ((ConfigPropertyType)object).mValue == this.mValue) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        return this.mValue;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public static ConfigPropertyType getConfigPropertyType(String string) throws CheckstylePluginException {
        ConfigPropertyType configPropertyType = null;
        if (string.equalsIgnoreCase(ConfigPropertyType.STRING.mLabel)) {
            configPropertyType = STRING;
        } else if (string.equalsIgnoreCase(ConfigPropertyType.STRING_ARRAY.mLabel)) {
            configPropertyType = STRING_ARRAY;
        } else if (string.equalsIgnoreCase(ConfigPropertyType.INTEGER.mLabel)) {
            configPropertyType = INTEGER;
        } else if (string.equalsIgnoreCase(ConfigPropertyType.SINGLE_SELECT.mLabel)) {
            configPropertyType = SINGLE_SELECT;
        } else if (string.equalsIgnoreCase(ConfigPropertyType.BOOLEAN.mLabel)) {
            configPropertyType = BOOLEAN;
        } else if (string.equalsIgnoreCase(ConfigPropertyType.MULTI_CHECK.mLabel)) {
            configPropertyType = MULTI_CHECK;
        } else if (string.equalsIgnoreCase(ConfigPropertyType.HIDDEN.mLabel)) {
            configPropertyType = HIDDEN;
        } else {
            throw new CheckstylePluginException("Unknown config property type label: " + string);
        }
        return configPropertyType;
    }
}

