/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.config;

import com.atlassw.tools.eclipse.checkstyle.config.ConfigPropertyEnumerationMetadata;
import com.atlassw.tools.eclipse.checkstyle.config.ConfigPropertyType;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstyleLog;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstylePluginException;
import com.atlassw.tools.eclipse.checkstyle.util.XMLUtil;
import org.w3c.dom.Node;

public class ConfigPropertyMetadata
implements Cloneable {
    private ConfigPropertyType mDatatype = null;
    private String mName = "";
    private String mDefaultValue = "";
    private String mDescription = "";
    private boolean mHidden = false;
    private ConfigPropertyEnumerationMetadata mEnumeration = null;

    ConfigPropertyMetadata(Node node) throws CheckstylePluginException {
        Node node2;
        Node node3;
        String string = XMLUtil.getNodeAttributeValue(node, "name");
        if (string != null) {
            this.mName = string.trim();
        }
        if ((string = XMLUtil.getNodeAttributeValue(node, "default-value")) != null) {
            this.mDefaultValue = string.trim();
        }
        if ((string = XMLUtil.getNodeAttributeValue(node, "datatype")) != null) {
            this.mDatatype = ConfigPropertyType.getConfigPropertyType(string.trim());
        }
        if ((node3 = XMLUtil.getChildNode(node, "description")) != null && (string = XMLUtil.getNodeTextValue(node3)) != null) {
            this.mDescription = string.trim();
        }
        if ((node2 = XMLUtil.getChildNode(node, "enumeration")) != null) {
            ConfigPropertyEnumerationMetadata configPropertyEnumerationMetadata = null;
            try {
                configPropertyEnumerationMetadata = new ConfigPropertyEnumerationMetadata(node2);
            }
            catch (CheckstylePluginException checkstylePluginException) {
                CheckstyleLog.warning("Failed to get configuration property metadata, " + checkstylePluginException.getMessage(), checkstylePluginException);
            }
            if (configPropertyEnumerationMetadata != null) {
                this.mEnumeration = configPropertyEnumerationMetadata;
            }
        }
    }

    ConfigPropertyMetadata(ConfigPropertyType configPropertyType, String string, String string2) {
        this.mDatatype = configPropertyType;
        this.mName = string;
        this.mDefaultValue = string2;
        this.mDescription = "No Description Available";
    }

    public ConfigPropertyType getDatatype() {
        return this.mDatatype;
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getDefaultValue() {
        return this.mDefaultValue;
    }

    public ConfigPropertyEnumerationMetadata getPropertyEnumeration() {
        return this.mEnumeration;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isHidden() {
        return this.mHidden;
    }

    public void setHidden(boolean bl) {
        this.mHidden = bl;
    }
}

