/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.config;

import com.atlassw.tools.eclipse.checkstyle.util.CheckstyleLog;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstylePluginException;
import com.atlassw.tools.eclipse.checkstyle.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConfigProperty
implements Comparable {
    private String mName;
    private String mValue;

    public ConfigProperty() {
    }

    public ConfigProperty(String string, String string2) {
        this.setName(string);
        this.setValue(string2);
    }

    ConfigProperty(Node node) throws CheckstylePluginException {
        String string = XMLUtil.getNodeAttributeValue(node, "name");
        if (string == null) {
            String string2 = "ConfigProperty missing name attribute";
            CheckstyleLog.warning(string2);
            throw new CheckstylePluginException(string2);
        }
        this.setName(string.trim());
        String string3 = XMLUtil.getNodeAttributeValue(node, "value");
        if (string3 == null) {
            String string4 = "ConfigProperty missing value attribute";
            CheckstyleLog.warning(string4);
            throw new CheckstylePluginException(string4);
        }
        this.mValue = string3.trim();
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String string) {
        this.mName = string;
    }

    public String getValue() {
        return this.mValue;
    }

    public void setValue(String string) {
        this.mValue = string;
    }

    String getConfigItemTypeTag() {
        return "config-property";
    }

    Node toDOMNode(Document document) {
        Element element = document.createElement("config-property");
        element.setAttribute("name", this.getName());
        element.setAttribute("value", this.mValue);
        return element;
    }

    Node toCSDOMNode(Document document) {
        Element element = document.createElement("property");
        element.setAttribute("name", this.getName());
        element.setAttribute("value", this.mValue);
        return element;
    }

    public int compareTo(Object object) {
        return this.mName.compareTo(((ConfigProperty)object).mName);
    }
}

