/*
 * Decompiled with CFR 0.152.
 */
package com.atlassw.tools.eclipse.checkstyle.config;

import com.atlassw.tools.eclipse.checkstyle.CheckstylePlugin;
import com.atlassw.tools.eclipse.checkstyle.config.CheckConfiguration;
import com.atlassw.tools.eclipse.checkstyle.config.CheckstyleConfigurationSerializer;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstyleLog;
import com.atlassw.tools.eclipse.checkstyle.util.CheckstylePluginException;
import com.atlassw.tools.eclipse.checkstyle.util.XMLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CheckConfigurationFactory {
    private static final String DEFAULT_CHECK_CONFIGS = "DefaultChecks.xml";
    private static final String CHECKSTYLE_CONFIG_FILE = "checkstyle-config.xml";
    private static final String VERSION_1_0_0 = "1.0.0";
    private static final String VERSION_3_2_0 = "3.2.0";
    private static final String CURRENT_CONFIG_FILE_FORMAT_VERSION = "3.2.0";
    private static final String CLASSNAMES_V3_2_0_UPDATE = "com/atlassw/tools/eclipse/checkstyle/config/classnames_v3.2.0_update.properties";
    static /* synthetic */ Class class$com$atlassw$tools$eclipse$checkstyle$config$CheckConfigurationFactory;

    private CheckConfigurationFactory() {
    }

    public static CheckConfiguration getNewInstance() throws CheckstylePluginException {
        CheckConfiguration checkConfiguration = new CheckConfiguration();
        return checkConfiguration;
    }

    public static CheckConfiguration getByName(String string) throws CheckstylePluginException {
        CheckConfiguration checkConfiguration = null;
        if (string != null) {
            List list = CheckConfigurationFactory.loadFromPersistence();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                CheckConfiguration checkConfiguration2 = (CheckConfiguration)iterator.next();
                if (!checkConfiguration2.getConfigName().equals(string)) continue;
                checkConfiguration = checkConfiguration2;
                break;
            }
        }
        return checkConfiguration;
    }

    public static List getCheckConfigurations() throws CheckstylePluginException {
        return CheckConfigurationFactory.loadFromPersistence();
    }

    public static void setCheckConfigurations(List list) throws CheckstylePluginException {
        CheckConfigurationFactory.storeToPersistence(list);
    }

    public static void addCheckConfiguration(CheckConfiguration checkConfiguration) throws CheckstylePluginException {
        List list = CheckConfigurationFactory.loadFromPersistence();
        list.add(checkConfiguration);
        CheckConfigurationFactory.storeToPersistence(list);
    }

    public static void removeCheckConfiguration(CheckConfiguration checkConfiguration) throws CheckstylePluginException {
        List list = CheckConfigurationFactory.loadFromPersistence();
        list.remove(checkConfiguration);
        CheckConfigurationFactory.storeToPersistence(list);
    }

    public static List importPluginCheckConfigurations(File file) throws CheckstylePluginException {
        List list = null;
        if (file.exists()) {
            list = CheckConfigurationFactory.loadFile(file);
        }
        return list;
    }

    public static void exportPluginCheckConfigurations(File file, CheckConfiguration checkConfiguration) throws CheckstylePluginException {
        LinkedList<CheckConfiguration> linkedList = new LinkedList<CheckConfiguration>();
        linkedList.add(checkConfiguration);
        CheckConfigurationFactory.writeFile(file, linkedList);
    }

    public static void exportCheckstyleCheckConfigurations(File file, CheckConfiguration checkConfiguration) throws CheckstylePluginException {
        CheckConfigurationFactory.writeCSFile(file, checkConfiguration);
    }

    private static List loadFromPersistence() throws CheckstylePluginException {
        List list = new LinkedList();
        IPath iPath = CheckstylePlugin.getDefault().getStateLocation();
        File file = (iPath = iPath.append(CHECKSTYLE_CONFIG_FILE)).toFile();
        if (file.exists()) {
            list.addAll(CheckConfigurationFactory.loadFile(file));
        } else {
            list = CheckConfigurationFactory.loadDefaultCheckConfigs();
            CheckConfigurationFactory.storeToPersistence(list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List loadDefaultCheckConfigs() {
        void var0_2;
        LinkedList linkedList = new LinkedList();
        Path path = new Path(DEFAULT_CHECK_CONFIGS);
        InputStream inputStream = null;
        inputStream = CheckstylePlugin.getDefault().openStream((IPath)path);
        List list = CheckConfigurationFactory.loadInputStream(inputStream);
        Object var5_5 = null;
        if (inputStream == null) return var0_2;
        try {
            inputStream.close();
            return var0_2;
        }
        catch (Exception exception) {
            CheckstyleLog.warning("Error closing default checks file", exception);
        }
        return var0_2;
        {
            catch (IOException iOException) {
                CheckstyleLog.warning("Failed to load default check configurations", iOException);
                Object var5_6 = null;
                if (inputStream == null) return var0_2;
                try {
                    inputStream.close();
                    return var0_2;
                }
                catch (Exception exception) {
                    CheckstyleLog.warning("Error closing default checks file", exception);
                }
                return var0_2;
            }
            catch (CheckstylePluginException checkstylePluginException) {
                CheckstyleLog.warning("Failed to load default check configurations", checkstylePluginException);
                Object var5_7 = null;
                if (inputStream == null) return var0_2;
                try {
                    inputStream.close();
                    return var0_2;
                }
                catch (Exception exception) {
                    CheckstyleLog.warning("Error closing default checks file", exception);
                }
                return var0_2;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                CheckstyleLog.warning("Error closing default checks file", exception);
            }
            throw throwable;
        }
    }

    private static void storeToPersistence(List list) throws CheckstylePluginException {
        IPath iPath = CheckstylePlugin.getDefault().getStateLocation();
        iPath = iPath.append(CHECKSTYLE_CONFIG_FILE);
        File file = iPath.toFile();
        CheckConfigurationFactory.writeFile(file, list);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List loadFile(File file) throws CheckstylePluginException {
        List list = null;
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(file);
        list = CheckConfigurationFactory.loadInputStream(fileInputStream);
        Object var6_3 = null;
        if (fileInputStream == null) return list;
        try {
            fileInputStream.close();
            return list;
        }
        catch (Exception exception) {
            CheckstyleLog.warning("Error closing input file", exception);
        }
        return list;
        {
            catch (FileNotFoundException fileNotFoundException) {
                String string = "Failed to read check configurations: " + fileNotFoundException.getMessage();
                CheckstyleLog.warning(string, fileNotFoundException);
                throw new CheckstylePluginException(string);
            }
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                CheckstyleLog.warning("Error closing input file", exception);
            }
            throw throwable;
        }
    }

    private static List loadInputStream(InputStream inputStream) throws CheckstylePluginException {
        LinkedList<CheckConfiguration> linkedList = new LinkedList<CheckConfiguration>();
        Document document = XMLUtil.newDocument(inputStream);
        if (document == null) {
            String string = "Failed to read and parse check configurations";
            CheckstyleLog.warning(string);
            throw new CheckstylePluginException(string);
        }
        Node node = CheckConfigurationFactory.checkFileFormatVersion(document);
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals("check-configuration")) continue;
            CheckConfiguration checkConfiguration = new CheckConfiguration(node2);
            if (checkConfiguration == null) {
                CheckstyleLog.warning("Failed to create CheckConfiguration, ignoring");
                continue;
            }
            linkedList.add(checkConfiguration);
        }
        return linkedList;
    }

    private static void writeFile(File file, List list) throws CheckstylePluginException {
        try {
            Object object;
            Object object2;
            Document document = XMLUtil.newDocument();
            Element element = document.createElement("checkstyle-configurations");
            document.appendChild(element);
            element.setAttribute("file-format-version", "3.2.0");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object2 = (CheckConfiguration)iterator.next();
                object = ((CheckConfiguration)object2).toDOMNode(document);
                element.appendChild((Node)object);
            }
            object2 = XMLUtil.serializeDocument(document, true);
            object = null;
            try {
                object = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8");
                ((Writer)object).write((String)object2);
            }
            catch (Exception exception) {
                String string = "Failed to write check configuration file: " + exception.getMessage();
                CheckstyleLog.warning(string, exception);
                throw new CheckstylePluginException(string);
            }
            finally {
                if (object != null) {
                    ((OutputStreamWriter)object).close();
                }
            }
        }
        catch (Exception exception) {
            String string = "Failed to write check configuration file: " + exception.getMessage();
            CheckstyleLog.warning(string, exception);
            throw new CheckstylePluginException(string);
        }
    }

    private static void writeCSFile(File file, CheckConfiguration checkConfiguration) throws CheckstylePluginException {
        try {
            String string = CheckstyleConfigurationSerializer.serialize(checkConfiguration);
            OutputStreamWriter outputStreamWriter = null;
            try {
                outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8");
                outputStreamWriter.write(string);
            }
            catch (Exception exception) {
                String string2 = "Failed to write check configuration file: " + exception.getMessage();
                CheckstyleLog.warning(string2, exception);
                throw new CheckstylePluginException(string2);
            }
            finally {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
        }
        catch (Exception exception) {
            String string = "Failed to write check configuration file: " + exception.getMessage();
            CheckstyleLog.warning(string, exception);
            throw new CheckstylePluginException(string);
        }
    }

    private static Node checkFileFormatVersion(Document document) throws CheckstylePluginException {
        Node node = document.getDocumentElement();
        String string = XMLUtil.getNodeAttributeValue(node, "file-format-version");
        if (string.equals(VERSION_1_0_0)) {
            node = CheckConfigurationFactory.updateCheckClassnamesTo_v3_2_0(node);
        }
        return node;
    }

    public static boolean isNameInUse(String string) throws CheckstylePluginException {
        boolean bl = true;
        if (CheckConfigurationFactory.getByName(string) == null) {
            bl = false;
        }
        return bl;
    }

    private static Node updateCheckClassnamesTo_v3_2_0(Node node) throws CheckstylePluginException {
        Properties properties = new Properties();
        ClassLoader classLoader = (class$com$atlassw$tools$eclipse$checkstyle$config$CheckConfigurationFactory == null ? (class$com$atlassw$tools$eclipse$checkstyle$config$CheckConfigurationFactory = CheckConfigurationFactory.class$("com.atlassw.tools.eclipse.checkstyle.config.CheckConfigurationFactory")) : class$com$atlassw$tools$eclipse$checkstyle$config$CheckConfigurationFactory).getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(CLASSNAMES_V3_2_0_UPDATE);
        if (inputStream == null) {
            throw new CheckstylePluginException("Failed to load check classname update map");
        }
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            throw new CheckstylePluginException("Failed to load check classname update map");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals("check-configuration")) continue;
            NodeList nodeList2 = node2.getChildNodes();
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                NamedNodeMap namedNodeMap;
                Attr attr;
                String string;
                String string2;
                Node node3 = nodeList2.item(j);
                if (!node3.getNodeName().equals("rule-configuration") || (string2 = properties.getProperty(string = (attr = (Attr)(namedNodeMap = node3.getAttributes()).getNamedItem("classname")).getValue(), string)).equals(string)) continue;
                attr.setValue(string2);
            }
        }
        return node;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

