/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.support;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wb.internal.swt.model.property.editor.font.FontInfo;
import org.eclipse.wb.internal.swt.support.AbstractSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFaceSupport
extends AbstractSupport {
    public static boolean isAvialable() {
        try {
            JFaceSupport.getJFaceResourceClass();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static Class<?> getResourceRegistryClass() throws Exception {
        return JFaceSupport.loadClass("org.eclipse.jface.resource.ResourceRegistry");
    }

    private static Class<?> getJFaceResourceClass() throws Exception {
        return JFaceSupport.loadClass("org.eclipse.jface.resource.JFaceResources");
    }

    public static List<FontInfo> getJFaceFonts() throws Exception {
        ArrayList jfaceFonts = Lists.newArrayList();
        Method[] methods = JFaceSupport.getJFaceResourceClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            String name;
            Method method = methods[i];
            int modifiers = method.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && (name = method.getName()).startsWith("get") && name.endsWith("Font") && method.getParameterTypes().length == 0 && method.getReturnType().getName().equals("org.eclipse.swt.graphics.Font")) {
                Object font = method.invoke(null, new Object[0]);
                jfaceFonts.add(new FontInfo(String.valueOf(name) + "()", font, "org.eclipse.jface.resource.JFaceResources." + name + "()", false));
            }
            ++i;
        }
        return jfaceFonts;
    }
}

