/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.wizards;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.description.LayoutDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.helpers.LayoutDescriptionHelper;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.core.wizards.AbstractDesignWizardPage;

public abstract class TemplateDesignWizardPage
extends AbstractDesignWizardPage {
    protected void fillTypeFromTemplate(IType newType, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor, InputStream file) throws CoreException {
        try {
            try {
                StringBuffer method = null;
                StringBuffer constructor = null;
                boolean isMethod = false;
                boolean isConstructor = false;
                List lines = IOUtils.readLines((InputStream)file);
                Iterator I = lines.iterator();
                while (I.hasNext()) {
                    int start;
                    int end;
                    String line = (String)I.next();
                    if (line.startsWith("import ") && (end = line.indexOf(59, (start = 7) + 1)) != -1) {
                        imports.addImport(line.substring(start, end));
                    }
                    if (line.startsWith("constructor")) {
                        isMethod = false;
                        isConstructor = true;
                        constructor = new StringBuffer();
                        method = null;
                        continue;
                    }
                    if (line.startsWith("method")) {
                        isMethod = true;
                        isConstructor = false;
                        method = new StringBuffer();
                        constructor = null;
                        continue;
                    }
                    if (line.startsWith("field")) {
                        line = (String)I.next();
                        StringBuffer field = new StringBuffer(line);
                        field = this.performSubstitutions(field, imports);
                        String string = field.toString();
                        newType.createField(string, null, false, null);
                        continue;
                    }
                    if (line.startsWith("innerTypeLine")) {
                        line = (String)I.next();
                        StringBuffer buffer = new StringBuffer(line);
                        buffer = this.performSubstitutions(buffer, imports);
                        String content = buffer.toString();
                        newType.createType(content, null, false, null);
                        continue;
                    }
                    if (line.length() == 0) {
                        if (method != null) {
                            method = this.performSubstitutions(method, imports);
                        }
                        if (constructor != null) {
                            constructor = this.performSubstitutions(constructor, imports);
                        }
                        if (isMethod && method != null && method.length() > 0) {
                            newType.createMethod(method.toString(), null, false, null);
                        } else if (isConstructor && constructor != null && constructor.length() > 0) {
                            newType.createMethod("public " + this.getTypeName() + constructor.toString(), null, false, null);
                        }
                        isMethod = false;
                        isConstructor = false;
                        method = null;
                        constructor = null;
                        continue;
                    }
                    if (isMethod && method != null) {
                        if (ProjectUtils.isJDK15(newType.getJavaProject()) || !line.trim().equals("@Override")) {
                            method.append(String.valueOf(line) + AstEditor.DEFAULT_END_OF_LINE);
                        }
                    } else if (isConstructor && constructor != null) {
                        constructor.append(String.valueOf(line) + AstEditor.DEFAULT_END_OF_LINE);
                    }
                    if (I.hasNext() || !isMethod || method == null || method.length() <= 0) continue;
                    newType.createMethod(method.toString(), null, false, null);
                }
            }
            catch (Throwable e) {
                DesignerPlugin.log(e);
                IOUtils.closeQuietly((InputStream)file);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)file);
        }
    }

    private StringBuffer performSubstitutions(StringBuffer buffer, NewTypeWizardPage.ImportsManager imports) {
        String code = this.performSubstitutions(buffer.toString(), imports);
        return new StringBuffer(code);
    }

    protected String performSubstitutions(String code, NewTypeWizardPage.ImportsManager imports) {
        this.loadUIClasses();
        code = StringUtils.replace((String)code, (String)"%TypeName%", (String)this.getTypeName());
        code = StringUtils.replace((String)code, (String)"%DefaultFormSize%", (String)this.getDefaultFormSize());
        code = StringUtils.replace((String)code, (String)"%this%", (String)this.getInstanceFieldQualification());
        code = TemplateDesignWizardPage.performFieldPrefixesSubstitutions(code);
        return code;
    }

    protected static String performFieldPrefixesSubstitutions(String code) {
        code = StringUtils.replace((String)code, (String)"%field-prefix%", (String)JavaCore.getOption((String)"org.eclipse.jdt.core.codeComplete.fieldPrefixes"));
        code = StringUtils.replace((String)code, (String)"%static-field-prefix%", (String)JavaCore.getOption((String)"org.eclipse.jdt.core.codeComplete.staticFieldPrefixes"));
        return code;
    }

    protected void loadUIClasses() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    Class.forName("org.eclipse.wb.internal.draw2d.IColorConstants");
                }
                catch (Throwable throwable) {}
            }
        });
    }

    public String getDefaultFormSize() {
        IPreferenceStore preferences = this.getToolkitDescription().getPreferences();
        int width = preferences.getInt("general.topBoundsDefaultWidth");
        int height = preferences.getInt("general.topBoundsDefaultHeight");
        return String.valueOf(Integer.toString(width)) + ", " + Integer.toString(height);
    }

    public String getInstanceFieldQualification() {
        IPreferenceStore preferences = this.getToolkitDescription().getPreferences();
        return preferences.getBoolean("variable.fieldUnique.prefixThis") ? "this." : "";
    }

    public final String getCreateMethod(String defaultMethod) {
        String forcedMethodName = this.getToolkitDescription().getGenerationSettings().getForcedMethodName();
        return StringUtils.isEmpty((String)forcedMethodName) ? defaultMethod : forcedMethodName;
    }

    public final String getLayoutCode(String codePrefix, NewTypeWizardPage.ImportsManager imports) {
        ToolkitDescription toolkit = this.getToolkitDescription();
        LayoutDescription layoutDescription = LayoutDescriptionHelper.get(toolkit, toolkit.getPreferences().getString("layout.default"));
        if (layoutDescription != null) {
            imports.addImport(layoutDescription.getLayoutClassName());
            return String.valueOf(codePrefix) + "setLayout(" + layoutDescription.getSourceSmart() + ");";
        }
        return "";
    }

    protected abstract ToolkitDescription getToolkitDescription();
}

