/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui.dialogs.color;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.wb.internal.core.utils.Messages;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ReusableDialog;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.AbstractColorsComposite;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.ColorInfo;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.ColorPreviewCanvas;

public abstract class AbstractColorDialog
extends ReusableDialog {
    private ColorInfo m_colorInfo;
    private ColorPreviewCanvas m_previewCanvas;
    private TabFolder m_tabFolder;

    public AbstractColorDialog(Shell parentShell) {
        super(parentShell);
    }

    public final ColorInfo getColorInfo() {
        return this.m_colorInfo;
    }

    public void setColorInfo(ColorInfo colorInfo) {
        this.m_colorInfo = colorInfo;
    }

    protected final String getSelectedPageTitle() {
        int selectionIndex = this.m_tabFolder.getSelectionIndex();
        return this.m_tabFolder.getItem(selectionIndex).getText();
    }

    protected final void selectPageByTitle(String title) {
        TabItem[] tabItems = this.m_tabFolder.getItems();
        int i = 0;
        while (i < tabItems.length) {
            TabItem tabItem = tabItems[i];
            if (tabItem.getText().equals(title)) {
                this.m_tabFolder.setSelection(new TabItem[]{tabItem});
                break;
            }
            ++i;
        }
    }

    protected final Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        area.setLayout((Layout)new GridLayout());
        Group group = new Group(area, 0);
        GridDataFactory.create((Control)group).fillH();
        group.setLayout((Layout)new FillLayout());
        group.setText(Messages.AbstractColorDialog_previewGroup);
        this.m_previewCanvas = new ColorPreviewCanvas((Composite)group, 0, this.showShortTextInColorPreview());
        this.m_tabFolder = new TabFolder(area, 0);
        this.m_tabFolder.setLayoutData((Object)new GridData(1808));
        this.addPages((Composite)this.m_tabFolder);
        return area;
    }

    protected boolean showShortTextInColorPreview() {
        return false;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AbstractColorDialog_title);
    }

    protected void onBeforeOpen() {
        this.m_previewCanvas.setColor(this.m_colorInfo);
    }

    protected final void addPage(String title, AbstractColorsComposite composite) {
        TabItem tabItem = new TabItem(this.m_tabFolder, 0);
        tabItem.setText(title);
        tabItem.setControl((Control)composite);
    }

    protected abstract void addPages(Composite var1);

    public final void setResultColor(ColorInfo colorInfo) {
        this.m_colorInfo = colorInfo;
        this.m_previewCanvas.setColor(this.m_colorInfo);
    }

    public final void closeOk() {
        this.buttonPressed(0);
    }
}

