/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ast;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstReflectionUtils {
    private AstReflectionUtils() {
    }

    public static Class<?> getClass(ClassLoader classLoader, ITypeBinding typeBinding) throws Exception {
        Assert.isNotNull(typeBinding);
        String className = AstNodeUtils.getFullyQualifiedName(typeBinding, true);
        return ReflectionUtils.getClassByName(classLoader, className);
    }

    public static Object[] updateForVarArgs(ClassLoader classLoader, IMethodBinding methodBinding, Object[] values) throws Exception {
        if (methodBinding.isVarargs()) {
            Object varArgs;
            ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
            int parameterCount = parameterTypes.length;
            Object[] newValues = new Object[parameterCount];
            System.arraycopy(values, 0, newValues, 0, parameterCount - 1);
            ITypeBinding varArrayTypeBinding = parameterTypes[parameterCount - 1];
            newValues[parameterCount - 1] = varArgs = AstReflectionUtils.getVarArgsArgument(classLoader, values, parameterCount - 1, varArrayTypeBinding);
            return newValues;
        }
        return values;
    }

    private static Object getVarArgsArgument(ClassLoader classLoader, Object[] values, int varArrayFirstIndex, ITypeBinding varArrayTypeBinding) throws Exception {
        Object varArgValue;
        Class<?> varClass = AstReflectionUtils.getClass(classLoader, varArrayTypeBinding.getElementType());
        int varArgsLength = values.length - varArrayFirstIndex;
        if (varArgsLength == 1 && (varArgValue = values[varArrayFirstIndex]) != null && varArgValue.getClass().isArray() && varClass.isAssignableFrom(varArgValue.getClass().getComponentType())) {
            return varArgValue;
        }
        Object varArgs = Array.newInstance(varClass, varArgsLength);
        int i = 0;
        while (i < varArgsLength) {
            Object element = values[varArrayFirstIndex + i];
            Array.set(varArgs, i, element);
            ++i;
        }
        return varArgs;
    }

    public static Constructor<?> getConstructor(Class<?> clazz, IMethodBinding binding) {
        Assert.isLegal(binding.isConstructor());
        String signature = AstNodeUtils.getMethodSignature(binding);
        Constructor<?> constructor = ReflectionUtils.getConstructorBySignature(clazz, signature);
        if (constructor == null) {
            signature = AstNodeUtils.getMethodGenericSignature(binding);
            constructor = ReflectionUtils.getConstructorByGenericSignature(clazz, signature);
        }
        return constructor;
    }

    public static Constructor<?> getConstructor(Class<?> clazz, SuperConstructorInvocation invocation) {
        IMethodBinding binding = AstNodeUtils.getSuperBinding(invocation);
        return AstReflectionUtils.getConstructor(clazz, binding);
    }

    public static Constructor<?> getConstructor(Class<?> clazz, ClassInstanceCreation creation) {
        IMethodBinding binding = AstNodeUtils.getCreationBinding(creation);
        return AstReflectionUtils.getConstructor(clazz, binding);
    }

    public static Method getMethod(Class<?> clazz, IMethodBinding binding) {
        Assert.isLegal(!binding.isConstructor());
        String signature = AstNodeUtils.getMethodSignature(binding);
        Method method = ReflectionUtils.getMethodBySignature(clazz, signature);
        if (method == null) {
            signature = AstNodeUtils.getMethodGenericSignature(binding);
            method = ReflectionUtils.getMethodByGenericSignature(clazz, signature);
        }
        return method;
    }

    public static Method getMethod(Class<?> clazz, MethodInvocation invocation) {
        IMethodBinding binding = AstNodeUtils.getMethodBinding(invocation);
        return AstReflectionUtils.getMethod(clazz, binding);
    }
}

