/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.model;

import java.util.Locale;

public final class LocaleInfo {
    public static final LocaleInfo DEFAULT = new LocaleInfo(null);
    private final Locale m_locale;

    public LocaleInfo(Locale locale) {
        this.m_locale = locale;
    }

    public String toString() {
        return this.getTitle();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LocaleInfo) {
            LocaleInfo localeInfo = (LocaleInfo)obj;
            if (this.isDefault()) {
                return localeInfo.isDefault();
            }
            return this.m_locale.equals(localeInfo.m_locale);
        }
        return false;
    }

    public int hashCode() {
        if (this.isDefault()) {
            return 0;
        }
        return this.m_locale.hashCode();
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public boolean isDefault() {
        return this.m_locale == null;
    }

    public String getTitle() {
        if (this.isDefault()) {
            return "(default)";
        }
        return this.m_locale.toString();
    }

    public LocaleInfo getParent(LocaleInfo[] locales) {
        String localeName = this.m_locale.toString();
        int lastSeparatorIndex = localeName.lastIndexOf(95);
        if (lastSeparatorIndex != -1) {
            String parentLocaleName = localeName.substring(0, lastSeparatorIndex);
            LocaleInfo[] localeInfoArray = locales;
            int n = locales.length;
            int n2 = 0;
            while (n2 < n) {
                LocaleInfo locale = localeInfoArray[n2];
                if (locale.getLocale() != null && locale.getLocale().toString().equals(parentLocaleName)) {
                    return locale;
                }
                ++n2;
            }
        }
        return DEFAULT;
    }

    public static LocaleInfo create(String localeName, String localeDescription) {
        Locale[] locales = Locale.getAvailableLocales();
        int i = 0;
        while (i < locales.length) {
            Locale locale = locales[i];
            if (locale.toString().equals(localeName)) {
                return new LocaleInfo(locale);
            }
            ++i;
        }
        try {
            Locale locale;
            int separatorIndex = localeName.indexOf(95);
            if (separatorIndex != -1) {
                String language = localeName.substring(0, separatorIndex);
                String country = localeName.substring(separatorIndex + 1);
                locale = new Locale(language, country);
            } else {
                locale = new Locale(localeName);
            }
            return new LocaleInfo(locale);
        }
        catch (Throwable throwable) {
            String msg = "Locale not found for " + localeDescription;
            throw new IllegalArgumentException(msg);
        }
    }
}

