/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.variable;

import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.editor.AbstractTextPropertyEditor;
import org.eclipse.wb.internal.core.model.variable.AbstractNamedVariableSupport;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;

public final class VariableProperty
extends Property {
    private final AbstractNamedVariableSupport m_variableSupport;

    public VariableProperty(AbstractNamedVariableSupport variableSupport) {
        super(new VariablePropertyEditor());
        this.m_variableSupport = variableSupport;
        this.setCategory(PropertyCategory.system(0));
    }

    public String getTitle() {
        return "Variable";
    }

    public Object getValue() throws Exception {
        return this.m_variableSupport.getName();
    }

    public boolean isModified() throws Exception {
        return true;
    }

    public void setValue(Object value) throws Exception {
        if (!(value instanceof String)) {
            return;
        }
        String text = ((String)value).trim();
        JavaInfo javaInfo = this.m_variableSupport.getJavaInfo();
        try {
            javaInfo.startEdit();
            this.m_variableSupport.setName(text);
        }
        finally {
            javaInfo.endEdit();
        }
    }

    private static final class VariablePropertyEditor
    extends AbstractTextPropertyEditor {
        private VariablePropertyEditor() {
        }

        protected String getText(Property property) throws Exception {
            return (String)property.getValue();
        }

        protected String getEditorText(Property property) throws Exception {
            return this.getText(property);
        }

        protected boolean setEditorText(Property property, String text) throws Exception {
            text = text.trim();
            VariableProperty variableProperty = (VariableProperty)property;
            String errorMessage = variableProperty.m_variableSupport.validateName(text);
            if (errorMessage != null) {
                UiUtils.openWarning(DesignerPlugin.getShell(), property.getTitle(), errorMessage);
                return false;
            }
            property.setValue(text);
            return true;
        }
    }
}

