/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.event;

import java.text.MessageFormat;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.event.AbstractListenerProperty;
import org.eclipse.wb.internal.core.model.property.event.EventsPropertyUtils;
import org.eclipse.wb.internal.core.model.property.event.ListenerInfo;
import org.eclipse.wb.internal.core.model.property.event.ListenerMethodProperty;
import org.eclipse.wb.internal.core.model.property.event.ListenerPropertyEditor;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.core.utils.ui.MenuManagerEx;

final class ListenerProperty
extends AbstractListenerProperty {
    private final ListenerInfo m_listener;
    private final String m_addSignature;

    public ListenerProperty(JavaInfo javaInfo, ListenerInfo listener) {
        super(javaInfo, listener.getName(), new ListenerPropertyEditor(listener));
        this.m_listener = listener;
        this.m_addSignature = listener.getMethodSignature();
        if (listener.isDeprecated()) {
            this.setCategory(PropertyCategory.ADVANCED);
        }
    }

    public boolean isModified() throws Exception {
        return this.m_javaInfo.getMethodInvocation(this.m_addSignature) != null;
    }

    public void setValue(Object value) throws Exception {
        if (value == UNKNOWN_VALUE && MessageDialog.openConfirm((Shell)DesignerPlugin.getShell(), (String)ModelMessages.ListenerProperty_removeTitle, (String)MessageFormat.format(ModelMessages.ListenerProperty_removeMessage, this.m_listener.getName()))) {
            this.removeListener();
        }
    }

    protected void removeListener() throws Exception {
        ListenerMethodProperty[] methodProperties = this.getMethodProperties();
        ListenerMethodProperty methodProperty = methodProperties[0];
        methodProperty.removeListener();
    }

    private ListenerMethodProperty[] getMethodProperties() throws Exception {
        return ((ListenerPropertyEditor)this.getEditor()).getProperties(this);
    }

    protected void addListenerActions(IMenuManager manager, IMenuManager implementMenuManager) throws Exception {
        if (this.m_listener.isDeprecated()) {
            return;
        }
        MenuManagerEx listenerMenuManager = null;
        ListenerMethodProperty[] listenerMethodPropertyArray = this.getMethodProperties();
        int n = listenerMethodPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAction[] actions;
            ListenerMethodProperty methodProperty = listenerMethodPropertyArray[n2];
            if (listenerMenuManager == null) {
                ListenerInfo listenerInfo = methodProperty.getListener();
                listenerMenuManager = new MenuManagerEx(listenerInfo.getName());
                implementMenuManager.add((IContributionItem)listenerMenuManager);
                TypeDeclaration listenerType = methodProperty.findListenerType();
                Image image = listenerType != null ? (listenerInfo.hasAdapter() ? EventsPropertyUtils.EXISTING_CLASS_IMAGE : EventsPropertyUtils.EXISTING_INTERFACE_IMAGE) : (listenerInfo.hasAdapter() ? EventsPropertyUtils.LISTENER_CLASS_IMAGE : EventsPropertyUtils.LISTENER_INTERFACE_IMAGE);
                listenerMenuManager.setImage(image);
            }
            if ((actions = this.createListenerMethodActions(methodProperty))[0] != null) {
                manager.appendToGroup("org.eclipse.wb.popup.group.events", actions[0]);
            }
            listenerMenuManager.add(actions[0] != null ? actions[0] : actions[1]);
            ++n2;
        }
    }

    private IAction[] createListenerMethodActions(final ListenerMethodProperty property) {
        IAction[] actions = new IAction[2];
        MethodDeclaration stubMethod = property.findStubMethod();
        if (stubMethod != null) {
            actions[0] = new ObjectInfoAction(this.m_javaInfo){

                protected void runEx() throws Exception {
                    property.openStubMethod();
                }
            };
            int line = this.m_javaInfo.getEditor().getLineNumber(stubMethod.getStartPosition());
            actions[0].setText(String.valueOf(property.getMethod().getName()) + ModelMessages.ListenerProperty_line + line);
            actions[0].setImageDescriptor(EventsPropertyUtils.LISTENER_METHOD_IMAGE_DESCRIPTOR);
        }
        actions[1] = new ObjectInfoAction(this.m_javaInfo){

            protected void runEx() throws Exception {
                property.openStubMethod();
            }
        };
        actions[1].setText(property.getMethod().getName());
        actions[1].setImageDescriptor(EventsPropertyUtils.LISTENER_METHOD_IMAGE_DESCRIPTOR);
        return actions;
    }
}

