/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor.style.impl;

import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.StringComboPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.style.AbstractStylePropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.style.SubStylePropertyImpl;
import org.eclipse.wb.internal.core.model.property.editor.style.actions.RadioStyleAction;

public final class SelectionUsingEqualsStylePropertyImpl
extends SubStylePropertyImpl {
    private final long[] m_flags;
    private final String[] m_sFlags;
    private final String m_className;

    public SelectionUsingEqualsStylePropertyImpl(AbstractStylePropertyEditor editor, String title, long[] flags, String[] sFlags, String className) {
        super(editor, title);
        this.m_flags = flags;
        this.m_sFlags = sFlags;
        this.m_className = className;
    }

    public void getAsString(StringBuilder builder) {
        builder.append(this.getTitle());
        builder.append(" select: ");
        String[] stringArray = this.m_sFlags;
        int n = this.m_sFlags.length;
        int n2 = 0;
        while (n2 < n) {
            String sFlag = stringArray[n2];
            builder.append(" ");
            builder.append(sFlag);
            ++n2;
        }
    }

    public PropertyEditor createEditor() {
        return new StringComboPropertyEditor(this.m_sFlags);
    }

    public long getFlag(String sFlag) {
        return this.m_flags[ArrayUtils.indexOf((Object[])this.m_sFlags, (Object)sFlag)];
    }

    public String getFlagValue(Property property) throws Exception {
        if (property instanceof GenericProperty) {
            String expressionString = this.getCurrentSource((GenericProperty)property);
            int i = 0;
            while (i < this.m_flags.length) {
                if (expressionString.indexOf(String.valueOf('.') + this.m_sFlags[i]) != -1) {
                    return this.m_sFlags[i];
                }
                ++i;
            }
        }
        return null;
    }

    public Object getValue(Property property) throws Exception {
        return this.getFlagValue(property);
    }

    public void setValue(Property property, Object value) throws Exception {
        GenericProperty genericProperty = (GenericProperty)property;
        String source = this.getSource(genericProperty, value.toString());
        genericProperty.setExpression(source, Property.UNKNOWN_VALUE);
    }

    public void contributeActions(Property property, IMenuManager manager) throws Exception {
        manager.add((IContributionItem)new Separator());
        Object defaultAction = null;
        boolean defineChecked = false;
        long style = this.getStyleValue(property);
        int i = 0;
        while (i < this.m_flags.length) {
            RadioStyleAction action = new RadioStyleAction(property, this, this.m_sFlags[i]);
            if ((style & this.m_flags[i]) != 0L) {
                action.setChecked(true);
                defineChecked = true;
            }
            manager.add((IAction)action);
            ++i;
        }
        if (!defineChecked) {
            defaultAction.setChecked(true);
        }
    }

    private String getCurrentSource(GenericProperty genericProperty) throws Exception {
        return genericProperty.getExpression().toString();
    }

    private String getSource(GenericProperty genericProperty, String style) throws Exception {
        return this.getSource(genericProperty, style, true, " | ");
    }

    private String getSource(GenericProperty genericProperty, String style, boolean addClassAndDefault, String separator) throws Exception {
        String currentSource = this.getCurrentSource(genericProperty);
        currentSource = currentSource.trim();
        if (style.equals("UNKNOWN_VALUE")) {
            char ch;
            String flagValue = this.getFlagValue(genericProperty);
            if (flagValue == null) {
                return currentSource;
            }
            if (currentSource.length() == 0) {
                return currentSource;
            }
            int beginIndex = currentSource.indexOf(String.valueOf('.') + flagValue);
            int endIndex = currentSource.indexOf(String.valueOf('.') + flagValue) + flagValue.length() + 1;
            while (beginIndex > 0) {
                ch = currentSource.charAt(beginIndex);
                if (!Character.isLetter(ch) && ch != '.') break;
                --beginIndex;
            }
            while (beginIndex > 0) {
                ch = currentSource.charAt(beginIndex);
                if (!Character.isWhitespace(ch)) break;
                --beginIndex;
            }
            while (endIndex <= currentSource.length() - 1) {
                ch = currentSource.charAt(endIndex);
                if (!Character.isWhitespace(ch)) break;
                ++endIndex;
            }
            if (beginIndex > 0 && currentSource.charAt(beginIndex) == '|') {
                --beginIndex;
            } else if (endIndex < currentSource.length() && currentSource.charAt(endIndex) == '|') {
                ++endIndex;
            } else {
                return currentSource;
            }
            return String.valueOf(currentSource.substring(0, beginIndex)) + currentSource.substring(endIndex, currentSource.length());
        }
        if (currentSource.indexOf(String.valueOf('.') + style) == -1) {
            String flagValue = this.getFlagValue(genericProperty);
            if (flagValue == null) {
                StringBuffer newSource = new StringBuffer();
                if (currentSource.length() != 0) {
                    newSource.append(currentSource);
                }
                newSource.append(separator);
                if (addClassAndDefault) {
                    newSource.append(this.m_className);
                    newSource.append('.');
                }
                newSource.append(style);
                return newSource.toString();
            }
            int beginIndex = currentSource.indexOf(String.valueOf('.') + flagValue);
            int endIndex = currentSource.indexOf(String.valueOf('.') + flagValue) + flagValue.length() + 1;
            while (beginIndex > 0) {
                char ch = currentSource.charAt(beginIndex);
                if (!Character.isLetter(ch) && ch != '.') break;
                --beginIndex;
            }
            currentSource = addClassAndDefault ? String.valueOf(currentSource.substring(0, beginIndex)) + this.m_className + '.' + style + currentSource.substring(endIndex) : String.valueOf(currentSource.substring(0, beginIndex)) + style + currentSource.substring(endIndex);
            return currentSource;
        }
        return currentSource;
    }
}

