/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.accessor;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public final class MethodInvocationArgumentAccessor
extends ExpressionAccessor {
    private final Method m_method;
    private final String m_methodSignature;
    private final int m_index;

    public MethodInvocationArgumentAccessor(Method method, int index) {
        this.m_method = method;
        this.m_methodSignature = ReflectionUtils.getMethodSignature(this.m_method);
        this.m_index = index;
    }

    public Expression getExpression(JavaInfo javaInfo) throws Exception {
        MethodInvocation invocation = this.getMethodInvocation(javaInfo);
        return this.getArgumentExpression(invocation);
    }

    public boolean setExpression(final JavaInfo javaInfo, final String source) throws Exception {
        final List<String> defaultArguments = this.getMethodDescription(javaInfo).getDefaultArguments();
        final MethodInvocation invocation = this.getMethodInvocation(javaInfo);
        if (invocation != null) {
            String argumentSource;
            final AstEditor editor = javaInfo.getEditor();
            final Expression oldArgumentExpression = this.getArgumentExpression(invocation);
            String string = argumentSource = source != null ? source : defaultArguments.get(this.m_index);
            if (!MethodInvocationArgumentAccessor.isSameSource(editor, oldArgumentExpression, argumentSource)) {
                ExecutionUtils.run(javaInfo, new RunnableEx(){

                    public void run() throws Exception {
                        editor.replaceExpression(oldArgumentExpression, argumentSource);
                        if (MethodInvocationArgumentAccessor.this.isDefaultArguments(javaInfo, invocation)) {
                            editor.removeEnclosingStatement((ASTNode)invocation);
                        }
                    }
                });
            }
        } else if (source != null) {
            ExecutionUtils.run(javaInfo, new RunnableEx(){

                public void run() throws Exception {
                    String argumentsSource = this.getNewInvocationArguments();
                    javaInfo.addMethodInvocation(MethodInvocationArgumentAccessor.this.m_methodSignature, argumentsSource);
                }

                private String getNewInvocationArguments() {
                    List arguments = Lists.newArrayList((Iterable)defaultArguments);
                    arguments.set(MethodInvocationArgumentAccessor.this.m_index, source);
                    return StringUtils.join(arguments.iterator(), (String)", ");
                }
            });
        }
        return true;
    }

    private MethodInvocation getMethodInvocation(JavaInfo javaInfo) throws Exception {
        return javaInfo.getMethodInvocation(this.m_methodSignature);
    }

    private Expression getArgumentExpression(MethodInvocation invocation) {
        return invocation != null ? DomGenerics.arguments(invocation).get(this.m_index) : null;
    }

    private MethodDescription getMethodDescription(JavaInfo javaInfo) {
        MethodDescription methodDescription = javaInfo.getDescription().getMethod(this.m_methodSignature);
        Assert.isNotNull(methodDescription, "Can not find description for method with signature %s", this.m_methodSignature);
        return methodDescription;
    }

    private boolean isDefaultArguments(JavaInfo javaInfo, MethodInvocation invocation) {
        AstEditor editor = javaInfo.getEditor();
        boolean allDefault = true;
        List<ParameterDescription> parameters = this.getMethodDescription(javaInfo).getParameters();
        List<Expression> arguments = DomGenerics.arguments(invocation);
        for (ParameterDescription parameter : parameters) {
            int index = parameter.getIndex();
            Expression argument = arguments.get(index);
            allDefault &= MethodInvocationArgumentAccessor.isDefaultArgument(editor, argument, parameter);
        }
        return allDefault;
    }

    private static boolean isDefaultArgument(AstEditor editor, Expression argument, ParameterDescription parameter) {
        String defaultArgumentSource = parameter.getDefaultSource();
        return MethodInvocationArgumentAccessor.isSameSource(editor, argument, defaultArgumentSource);
    }

    private static boolean isSameSource(AstEditor editor, Expression expression, String expectedSource) {
        String currentArgumentSource = MethodInvocationArgumentAccessor.getNormalizedSource(editor, expression);
        return expectedSource.equals(currentArgumentSource);
    }

    private static String getNormalizedSource(AstEditor editor, Expression expression) {
        CastExpression castExpression;
        if (expression instanceof CastExpression && (castExpression = (CastExpression)expression).getExpression() instanceof NullLiteral) {
            String qualifiedTypeName = AstNodeUtils.getFullyQualifiedName(expression, false);
            return MessageFormat.format("({0}) null", qualifiedTypeName);
        }
        return editor.getSource((ASTNode)expression);
    }
}

