/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.creation.factory;

import java.text.MessageFormat;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.FactoryParentAssociation;
import org.eclipse.wb.internal.core.model.creation.ILiveCreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.AbstractFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.description.CreationInvocationDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;

public abstract class AbstractExplicitFactoryCreationSupport
extends AbstractFactoryCreationSupport
implements ILiveCreationSupport {
    protected String m_addArguments;

    public AbstractExplicitFactoryCreationSupport(FactoryMethodDescription description) {
        super(description);
    }

    public AbstractExplicitFactoryCreationSupport(FactoryMethodDescription description, MethodInvocation invocation) {
        super(description, invocation);
    }

    public final FactoryMethodDescription getDescription() {
        return (FactoryMethodDescription)this.m_description;
    }

    public final Association getAssociation() throws Exception {
        if (this.add_getSource(null).indexOf("%parent%") != -1) {
            return new FactoryParentAssociation();
        }
        return null;
    }

    public boolean canUseParent(JavaInfo parent) throws Exception {
        for (ParameterDescription parameter : this.m_description.getParameters()) {
            Class<?> parentType;
            Class<?> requiredType;
            if (!parameter.isParent() || (requiredType = parameter.getType()).isAssignableFrom(parentType = parent.getDescription().getComponentClass())) continue;
            return false;
        }
        return super.canUseParent(parent);
    }

    public final boolean canReorder() {
        return true;
    }

    public final boolean canReparent() {
        return true;
    }

    public final String add_getSource(NodeTarget target) throws Exception {
        String argumentsSource;
        if (this.m_addArguments != null) {
            argumentsSource = this.m_addArguments;
        } else {
            argumentsSource = "";
            for (ParameterDescription parameter : this.m_description.getParameters()) {
                if (argumentsSource.length() != 0) {
                    argumentsSource = String.valueOf(argumentsSource) + ", ";
                }
                if (parameter.isParent()) {
                    argumentsSource = String.valueOf(argumentsSource) + "%parent%";
                    continue;
                }
                Assert.isNotNull(parameter.getDefaultSource());
                argumentsSource = String.valueOf(argumentsSource) + parameter.getDefaultSource();
            }
        }
        return MessageFormat.format("{0}{1}({2})", this.add_getSource_invocationExpression(target), this.m_description.getName(), argumentsSource);
    }

    protected abstract String add_getSource_invocationExpression(NodeTarget var1) throws Exception;

    public final void add_setSourceExpression(Expression expression) throws Exception {
        this.m_invocation = (MethodInvocation)expression;
        this.m_javaInfo.bindToExpression((Expression)this.m_invocation);
        for (CreationInvocationDescription invocation : this.getDescription().getInvocations()) {
            this.m_javaInfo.addMethodInvocation(invocation.getSignature(), invocation.getArguments());
        }
    }

    protected final String getClipboardArguments() throws Exception {
        String argumentsSource = "";
        for (ParameterDescription parameter : this.m_description.getParameters()) {
            if (argumentsSource.length() != 0) {
                argumentsSource = String.valueOf(argumentsSource) + ", ";
            }
            if (parameter.isParent()) {
                argumentsSource = String.valueOf(argumentsSource) + "%parent%";
                continue;
            }
            String argumentSource = null;
            GenericPropertyImpl argumentProperty = (GenericPropertyImpl)this.getGenericProperty(parameter);
            if (argumentProperty != null) {
                argumentSource = argumentProperty.getClipboardSource();
            }
            if (argumentSource == null && Object.class.isAssignableFrom(parameter.getType())) {
                argumentSource = parameter.getDefaultSource();
            }
            Assert.isNotNull(argumentSource, "No source for " + parameter.getIndex() + "-th argument of " + this.m_invocation);
            argumentsSource = String.valueOf(argumentsSource) + argumentSource;
        }
        return argumentsSource;
    }
}

