/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.tools;

import java.util.List;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.wb.core.gef.policy.TabOrderContainerEditPolicy;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.draw2d.ICursorConstants;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.core.tools.TargetingTool;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.gef.tools.TabOrderContainerRequest;

public final class TabOrderTool
extends TargetingTool {
    private final TabOrderContainerRequest m_containerRequest = new TabOrderContainerRequest("container tab order");
    private final IEditPartViewer m_viewer;
    private EditPolicy m_containerPolicy;
    private int m_currentIndex;
    private boolean m_saveTabOrder;
    private boolean m_changingContainer;
    private final ISelectionChangedListener m_selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            if (TabOrderTool.this.m_changingContainer) {
                return;
            }
            List<EditPart> selectedParts = TabOrderTool.this.m_viewer.getSelectedEditParts();
            if (selectedParts.size() == 1) {
                if (TabOrderTool.this.m_containerPolicy != null) {
                    TabOrderTool.this.deactivateTabContainerPolicy();
                }
                TabOrderTool.this.activateTabContainerPolicy(selectedParts.get(0));
            } else {
                TabOrderTool.this.m_containerPolicy = null;
            }
        }
    };

    public TabOrderTool(EditPart part) {
        this.setDefaultCursor(ICursorConstants.ARROW);
        this.m_viewer = part.getViewer();
        this.m_viewer.addSelectionChangedListener(this.m_selectionListener);
        this.m_containerPolicy = TabOrderTool.getContainerRole(part);
    }

    public void activate() {
        super.activate();
        this.activateTabContainerPolicy();
    }

    public void deactivate() {
        super.deactivate();
        this.m_viewer.removeSelectionChangedListener(this.m_selectionListener);
        if (this.m_viewer.getControl() != null) {
            this.deactivateTabContainerPolicy();
        }
    }

    protected Request getTargetRequest() {
        return TabOrderContainerEditPolicy.TAB_ORDER_REQUEST;
    }

    protected void handleButtonDown(int button) {
        if (this.m_containerPolicy != null && this.m_containerRequest.getPossibleChildren() != null && this.m_containerRequest.getChildren() != null) {
            this.updateTargetUnderMouse();
            EditPart editPart = this.getTargetEditPart();
            if (editPart != null) {
                AbstractComponentInfo model = (AbstractComponentInfo)editPart.getModel();
                List<AbstractComponentInfo> children = this.m_containerRequest.getChildren();
                List<AbstractComponentInfo> possibleChildren = this.m_containerRequest.getPossibleChildren();
                if (possibleChildren.contains(model)) {
                    if (children.contains(model)) {
                        if (DesignerPlugin.isCtrlPressed()) {
                            this.m_containerRequest.setSelectedChild(editPart.getModel());
                        } else if (DesignerPlugin.isShiftPressed()) {
                            children.remove(model);
                            if (this.m_containerRequest.getSelectedChild() == model) {
                                this.m_containerRequest.setSelectedChild(null);
                            }
                            this.m_saveTabOrder = true;
                        } else if (this.m_containerRequest.getSelectedChild() != null) {
                            Object selectedChild = this.m_containerRequest.getSelectedChild();
                            int selectedIndex = children.indexOf(selectedChild);
                            this.m_containerRequest.setSelectedChild(null);
                            children.remove(model);
                            children.add(selectedIndex, model);
                            this.m_saveTabOrder = true;
                        } else {
                            children.remove(model);
                            children.add(this.m_currentIndex++, model);
                            this.m_currentIndex = Math.min(this.m_currentIndex, children.size() - 1);
                            this.m_saveTabOrder = true;
                        }
                        this.m_containerPolicy.showTargetFeedback(this.m_containerRequest);
                    } else if (DesignerPlugin.isShiftPressed()) {
                        children.add(model);
                        this.m_containerPolicy.showTargetFeedback(this.m_containerRequest);
                    }
                } else {
                    EditPart activateOnPart = null;
                    if (TabOrderTool.hasContainerRole(editPart)) {
                        activateOnPart = editPart;
                    } else if (TabOrderTool.hasContainerRole(editPart.getParent())) {
                        activateOnPart = editPart.getParent();
                    }
                    if (activateOnPart != null) {
                        try {
                            this.m_changingContainer = true;
                            this.deactivateTabContainerPolicy();
                            this.activateTabContainerPolicy(activateOnPart);
                        }
                        finally {
                            this.m_changingContainer = false;
                        }
                    }
                }
            }
        }
    }

    protected void updateTargetUnderMouse() {
        EditPart editPart = this.getViewer().findTargetEditPart(this.m_currentScreenX, this.m_currentScreenY, this.getExclusionSet(), this.getTargetingConditional(), "Clickable Layer");
        if (editPart == null) {
            editPart = this.getViewer().findTargetEditPart(this.m_currentScreenX, this.m_currentScreenY, this.getExclusionSet(), this.getTargetingConditional());
        }
        if (editPart != null) {
            editPart = editPart.getTargetEditPart(this.getTargetRequest());
        }
        this.setTargetEditPart(editPart);
    }

    public void keyPressed(KeyEvent event, IEditPartViewer viewer) {
        if (event.keyCode == 27) {
            viewer.getEditDomain().loadDefaultTool();
        }
    }

    private void activateTabContainerPolicy(EditPart editPart) {
        this.m_containerPolicy = TabOrderTool.getContainerRole(editPart);
        this.activateTabContainerPolicy();
    }

    private void activateTabContainerPolicy() {
        if (this.isActive() && this.m_containerPolicy != null) {
            this.m_containerRequest.setChildren(null);
            this.m_containerPolicy.showTargetFeedback(this.m_containerRequest);
        }
        this.m_currentIndex = 0;
        this.m_saveTabOrder = false;
    }

    private void deactivateTabContainerPolicy() {
        if (this.m_containerPolicy != null) {
            this.m_containerPolicy.eraseTargetFeedback(this.m_containerRequest);
            if (this.m_saveTabOrder && this.m_containerRequest.getCommand() != null) {
                this.getDomain().executeCommand(this.m_containerRequest.getCommand());
            }
        }
    }

    private static EditPolicy getContainerRole(EditPart part) {
        if (part != null) {
            EditPolicy policy = part.getEditPolicy("tab container role");
            if (policy != null) {
                return policy;
            }
            return TabOrderTool.getContainerRole(part.getParent());
        }
        return null;
    }

    public static boolean hasContainerRole(EditPart part) {
        return TabOrderTool.getContainerRole(part) != null;
    }
}

