/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef;

import java.util.List;
import org.eclipse.wb.core.gef.IEditPartConfigurator;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.internal.core.gef.policy.layout.generic.FlowContainerLayoutEditPolicy;
import org.eclipse.wb.internal.core.gef.policy.layout.generic.SimpleContainerLayoutEditPolicy;
import org.eclipse.wb.internal.core.model.generic.FlowContainer;
import org.eclipse.wb.internal.core.model.generic.FlowContainerFactory;
import org.eclipse.wb.internal.core.model.generic.SimpleContainer;
import org.eclipse.wb.internal.core.model.generic.SimpleContainerFactory;

public final class GenericContainersConfigurator
implements IEditPartConfigurator {
    public void configure(EditPart context, EditPart editPart) {
        if (editPart.getModel() instanceof JavaInfo) {
            JavaInfo component = (JavaInfo)editPart.getModel();
            this.configureComponent(editPart, component);
        }
    }

    private void configureComponent(EditPart editPart, JavaInfo component) {
        this.configureSimpleContainer(editPart, component);
        this.configureFlowContainer(editPart, component);
    }

    private void configureSimpleContainer(EditPart editPart, JavaInfo component) {
        List<SimpleContainer> containers = new SimpleContainerFactory(component, true).get();
        for (SimpleContainer container : containers) {
            SimpleContainerLayoutEditPolicy layoutPolicy = new SimpleContainerLayoutEditPolicy(component, container);
            editPart.installEditPolicy(container, layoutPolicy);
        }
    }

    private void configureFlowContainer(EditPart editPart, JavaInfo component) {
        List<FlowContainer> containers = new FlowContainerFactory(component, true).get();
        for (FlowContainer container : containers) {
            FlowContainerLayoutEditPolicy layoutPolicy = new FlowContainerLayoutEditPolicy(component, container);
            editPart.installEditPolicy(container, layoutPolicy);
        }
    }
}

