/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.core.tools;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.DragPermissionRequest;
import org.eclipse.wb.gef.core.requests.GroupRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.core.tools.SelectEditPartTracker;
import org.eclipse.wb.gef.core.tools.ToolUtilities;
import org.eclipse.wb.internal.gef.core.CompoundCommand;
import org.eclipse.wb.internal.gef.core.ISharedCursors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DragEditPartTracker
extends SelectEditPartTracker {
    private boolean m_canMove;
    private boolean m_canReparent;
    private Collection<EditPart> m_exclusionSet;

    public DragEditPartTracker(EditPart sourceEditPart) {
        super(sourceEditPart);
        this.setDefaultCursor(ISharedCursors.CURSOR_MOVE);
        this.setDisabledCursor(ISharedCursors.CURSOR_NO);
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.m_exclusionSet = null;
    }

    @Override
    protected void handleButtonUp(int button) {
        if (this.m_state == 3) {
            List<Object> models = this.isMove() ? null : this.getOperationSetModels();
            this.eraseTargetFeedback();
            this.executeCommand();
            this.m_state = 0;
            this.restoreSelectionFromModels(models);
        } else {
            super.handleButtonUp(button);
        }
    }

    @Override
    protected void handleDragStarted() {
        super.handleDragStarted();
        if (this.m_state == 3) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
        }
    }

    @Override
    protected void handleDragInProgress() {
        if (this.m_state == 3) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
            this.showTargetFeedback();
            this.updateCommand();
        }
    }

    @Override
    protected Collection<EditPart> getExclusionSet() {
        if (this.m_exclusionSet == null) {
            this.m_exclusionSet = new ArrayList<EditPart>(this.getOperationSet());
        }
        return this.m_exclusionSet;
    }

    @Override
    protected IEditPartViewer.IConditional getTargetingConditional() {
        if (!this.getViewer().getSelectedEditParts().isEmpty() && this.getOperationSet().isEmpty()) {
            return new IEditPartViewer.IConditional(){

                public boolean evaluate(EditPart editPart) {
                    return false;
                }
            };
        }
        return super.getTargetingConditional();
    }

    @Override
    protected List<EditPart> createOperationSet() {
        List<EditPart> operationSet = ToolUtilities.getSelectionWithoutDependants(this.getViewer());
        Request request = (ChangeBoundsRequest)this.getTargetRequest();
        ((GroupRequest)request).setEditParts(operationSet);
        request = new DragPermissionRequest();
        for (EditPart editPart : operationSet) {
            editPart.performRequest(request);
        }
        this.m_canMove = ((DragPermissionRequest)request).canMove();
        this.m_canReparent = ((DragPermissionRequest)request).canReparent();
        return operationSet;
    }

    @Override
    protected Request createTargetRequest() {
        return new ChangeBoundsRequest("move");
    }

    @Override
    protected void updateTargetRequest() {
        super.updateTargetRequest();
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getTargetRequest();
        request.setEditParts(this.getOperationSet());
        request.setMoveDelta(new Point(this.getDragMoveDelta()));
        request.setLocation(this.getLocation());
    }

    @Override
    protected void updateTargetRequest(EditPart target) {
        super.updateTargetRequest(target);
        ChangeBoundsRequest request = (ChangeBoundsRequest)this.getTargetRequest();
        List<EditPart> editParts = request.getEditParts();
        if (!editParts.isEmpty()) {
            if (editParts.get(0).getParent() == target) {
                request.setType("move");
            } else {
                request.setType("add children");
            }
        }
    }

    private boolean isMove() {
        return this.getTargetRequest().getType() == "move";
    }

    private List<Object> getOperationSetModels() {
        List models = Lists.newArrayList();
        for (EditPart part : this.getOperationSet()) {
            models.add(part.getModel());
        }
        return models;
    }

    private void restoreSelectionFromModels(List<Object> models) {
        if (models != null) {
            IEditPartViewer viewer = this.getViewer();
            List newEditParts = Lists.newArrayList();
            for (Object model : models) {
                EditPart newEditPart = viewer.getEditPartByModel(model);
                if (newEditPart == null) continue;
                newEditParts.add(newEditPart);
            }
            viewer.setSelection(newEditParts);
        }
    }

    @Override
    protected Command getCommand() {
        EditPart targetEditPart;
        Request request = this.getTargetRequest();
        List<EditPart> operationSet = this.getOperationSet();
        if (this.isMove()) {
            if (this.m_canMove && !operationSet.isEmpty()) {
                EditPart firstPart = operationSet.get(0);
                return firstPart.getParent().getCommand(request);
            }
        } else if (this.m_canReparent && (targetEditPart = this.getTargetEditPart()) != null) {
            Command reparentCommand;
            CompoundCommand compoundCommand = targetEditPart.createCompoundCommand();
            if (!operationSet.isEmpty()) {
                EditPart firstPart = operationSet.get(0);
                GroupRequest orphanRequest = new GroupRequest("orphan children");
                orphanRequest.setEditParts(operationSet);
                compoundCommand.add(firstPart.getParent().getCommand(orphanRequest));
            }
            if ((reparentCommand = targetEditPart.getCommand(request)) != null) {
                compoundCommand.add(reparentCommand);
                return compoundCommand;
            }
        }
        return null;
    }
}

