/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy.validator;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.gef.core.requests.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CachingLayoutRequestValidator
implements ILayoutRequestValidator {
    private final ILayoutRequestValidator m_validator;

    public CachingLayoutRequestValidator(ILayoutRequestValidator validator) {
        this.m_validator = validator;
    }

    @Override
    public boolean validateCreateRequest(EditPart host, CreateRequest request) {
        Map<EditPart, Boolean> cache = this.getCache(request);
        Boolean cachedResult = cache.get(host);
        if (cachedResult == null) {
            cachedResult = this.m_validator.validateCreateRequest(host, request);
            cache.put(host, cachedResult);
        }
        return cachedResult;
    }

    @Override
    public boolean validatePasteRequest(EditPart host, PasteRequest request) {
        Map<EditPart, Boolean> cache = this.getCache(request);
        Boolean cachedResult = cache.get(host);
        if (cachedResult == null) {
            cachedResult = this.m_validator.validatePasteRequest(host, request);
            cache.put(host, cachedResult);
        }
        return cachedResult;
    }

    @Override
    public boolean validateMoveRequest(EditPart host, ChangeBoundsRequest request) {
        Map<EditPart, Boolean> cache = this.getCache(request);
        Boolean cachedResult = cache.get(host);
        if (cachedResult == null) {
            cachedResult = this.m_validator.validateMoveRequest(host, request);
            cache.put(host, cachedResult);
        }
        return cachedResult;
    }

    @Override
    public boolean validateAddRequest(EditPart host, ChangeBoundsRequest request) {
        Map<EditPart, Boolean> cache = this.getCache(request);
        Boolean cachedResult = cache.get(host);
        if (cachedResult == null) {
            cachedResult = this.m_validator.validateAddRequest(host, request);
            cache.put(host, cachedResult);
        }
        return cachedResult;
    }

    private Map<EditPart, Boolean> getCache(Request request) {
        Map cache = (Map)request.getArbitraryValue(this);
        if (cache == null) {
            cache = Maps.newHashMap();
            request.putArbitraryValue(this, cache);
        }
        return cache;
    }
}

