/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy.layout.grid;

import java.lang.reflect.Field;
import org.eclipse.swt.graphics.Color;
import org.eclipse.wb.core.gef.policy.PolicyUtils;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.Polyline;
import org.eclipse.wb.draw2d.RectangleFigure;
import org.eclipse.wb.draw2d.events.IFigureListener;
import org.eclipse.wb.draw2d.geometry.Interval;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.geometry.Translatable;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.gef.graphical.policies.GraphicalEditPolicy;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.gef.graphical.policies.SelectionEditPolicy;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;

public abstract class AbstractGridHelper {
    private static final Color BORDER_COLOR = new Color(null, 250, 165, 165);
    private static final Color EXISTING_COLOR = new Color(null, 219, 158, 158);
    private static final Color VIRTUAL_COLOR = new Color(null, 240, 204, 204);
    private static final Color SELECTION_COLOR = DrawUtils.getShiftedColor(IColorConstants.lightGray, -16);
    private final GraphicalEditPolicy m_editPolicy;
    private final Color m_borderColor;
    private final Color m_existingLineColor;
    private final Color m_virtualLineColor;
    private Rectangle hostClientArea;
    private Figure m_gridFigure = null;
    private final RootFigureListener m_rootFigureListener = new RootFigureListener();

    public AbstractGridHelper(GraphicalEditPolicy editPolicy, boolean forTarget) {
        this.m_editPolicy = editPolicy;
        if (forTarget) {
            this.m_borderColor = BORDER_COLOR;
            this.m_existingLineColor = EXISTING_COLOR;
            this.m_virtualLineColor = VIRTUAL_COLOR;
        } else {
            this.m_borderColor = null;
            this.m_existingLineColor = SELECTION_COLOR;
            this.m_virtualLineColor = null;
        }
    }

    protected abstract IGridInfo getGridInfo();

    public final void showGridFeedback() {
        Interval interval;
        int n;
        int n2;
        Interval[] intervalArray;
        if (this.m_gridFigure != null) {
            return;
        }
        this.m_gridFigure = new Figure();
        ObjectInfo rootObjectInfo = ((ObjectInfo)this.getHost().getModel()).getRoot();
        GraphicalEditPart rootEditPart = (GraphicalEditPart)this.getHost().getViewer().getEditPartByModel(rootObjectInfo);
        this.m_rootFigureListener.install(rootEditPart.getFigure());
        IGridInfo gridInfo = this.getGridInfo();
        Interval[] columnIntervals = gridInfo.getColumnIntervals();
        Interval[] rowIntervals = gridInfo.getRowIntervals();
        this.prepareHostClientArea();
        int y = this.hostClientArea.top();
        if (columnIntervals.length != 0) {
            int x1 = this.hostClientArea.left();
            int x2 = columnIntervals[columnIntervals.length - 1].end();
            intervalArray = rowIntervals;
            n2 = rowIntervals.length;
            n = 0;
            while (n < n2) {
                interval = intervalArray[n];
                y = interval.begin;
                this.addGridLine(x1, y, x2, y, this.m_existingLineColor);
                this.addGridLine(x2, y, this.hostClientArea.right(), y, this.m_virtualLineColor);
                y = interval.end();
                this.addGridLine(x1, y, x2, y, this.m_existingLineColor);
                this.addGridLine(x2, y, this.hostClientArea.right(), y, this.m_virtualLineColor);
                ++n;
            }
        }
        if (gridInfo.hasVirtualRows()) {
            while ((y += gridInfo.getVirtualRowGap()) < this.hostClientArea.bottom()) {
                this.addGridLine(this.hostClientArea.left(), y, this.hostClientArea.right(), y, this.m_virtualLineColor);
                if ((y += gridInfo.getVirtualRowSize()) >= this.hostClientArea.bottom()) break;
                this.addGridLine(this.hostClientArea.left(), y, this.hostClientArea.right(), y, this.m_virtualLineColor);
            }
        }
        int x = this.hostClientArea.left();
        if (rowIntervals.length != 0) {
            int y1 = this.hostClientArea.top();
            int y2 = rowIntervals[rowIntervals.length - 1].end();
            intervalArray = columnIntervals;
            n2 = columnIntervals.length;
            n = 0;
            while (n < n2) {
                interval = intervalArray[n];
                x = interval.begin;
                this.addGridLine(x, y1, x, y2, this.m_existingLineColor);
                this.addGridLine(x, y2, x, this.hostClientArea.bottom(), this.m_virtualLineColor);
                x = interval.end();
                this.addGridLine(x, y1, x, y2, this.m_existingLineColor);
                this.addGridLine(x, y2, x, this.hostClientArea.bottom(), this.m_virtualLineColor);
                ++n;
            }
        }
        if (gridInfo.hasVirtualColumns()) {
            while ((x += gridInfo.getVirtualColumnGap()) < this.hostClientArea.right()) {
                this.addGridLine(x, this.hostClientArea.top(), x, this.hostClientArea.bottom(), this.m_virtualLineColor);
                if ((x += gridInfo.getVirtualRowSize()) >= this.hostClientArea.right()) break;
                this.addGridLine(x, this.hostClientArea.top(), x, this.hostClientArea.bottom(), this.m_virtualLineColor);
            }
        }
        RectangleFigure borderFigure = new RectangleFigure();
        borderFigure.setForeground(this.m_borderColor);
        borderFigure.setBounds(new Rectangle(new Point(0, 0), this.hostClientArea.getSize()));
        this.m_gridFigure.add(borderFigure);
        this.translateModelToFeedback(this.hostClientArea);
        this.m_gridFigure.setBounds(this.hostClientArea);
        this.getHost().getViewer().getLayer("Handle Layer Sub 2").add(this.m_gridFigure);
    }

    private void prepareHostClientArea() {
        IAbstractComponentInfo containerInfo = (IAbstractComponentInfo)this.getHost().getModel();
        this.hostClientArea = this.getHost().getFigure().getBounds().getCopy();
        this.hostClientArea.crop(containerInfo.getClientAreaInsets());
        this.hostClientArea.y = 0;
        this.hostClientArea.x = 0;
        this.hostClientArea.crop(this.getGridInfo().getInsets());
    }

    private void addGridLine(int x1, int y1, int x2, int y2, Color color) {
        if (color != null) {
            Polyline line = new Polyline();
            line.setForeground(color);
            Point p1 = new Point(x1, y1);
            Point p2 = new Point(x2, y2);
            if (this.getGridInfo().isRTL()) {
                p1.x = this.hostClientArea.width - p1.x;
                p2.x = this.hostClientArea.width - p2.x;
            }
            if (x1 == x2) {
                --p2.y;
            }
            if (y1 == y2) {
                --p2.x;
            }
            line.addPoint(p1);
            line.addPoint(p2);
            this.m_gridFigure.add(line);
        }
    }

    public final void eraseGridFeedback() {
        if (this.m_gridFigure != null) {
            this.m_rootFigureListener.uninstall();
            FigureUtils.removeFigure(this.m_gridFigure);
            this.m_gridFigure = null;
        }
    }

    protected final Object getAbstractLayout() {
        try {
            Field field = this.m_editPolicy.getClass().getDeclaredField("m_layout");
            field.setAccessible(true);
            return field.get(this.m_editPolicy);
        }
        catch (Throwable e) {
            throw ReflectionUtils.propagate(e);
        }
    }

    protected GraphicalEditPart getHost() {
        if (this.m_editPolicy instanceof LayoutEditPolicy) {
            return this.m_editPolicy.getHost();
        }
        return (GraphicalEditPart)this.m_editPolicy.getHost().getParent();
    }

    protected void translateModelToFeedback(Translatable t) {
        if (this.m_editPolicy instanceof LayoutEditPolicy) {
            PolicyUtils.translateModelToFeedback((LayoutEditPolicy)this.m_editPolicy, t);
        } else {
            PolicyUtils.translateModelToFeedback((SelectionEditPolicy)this.m_editPolicy, t);
        }
    }

    private class RootFigureListener
    implements IFigureListener {
        private Figure m_rootFigure;

        private RootFigureListener() {
        }

        public void figureMoved(Figure source) {
            if (source == this.m_rootFigure) {
                AbstractGridHelper.this.prepareHostClientArea();
                AbstractGridHelper.this.translateModelToFeedback(AbstractGridHelper.this.hostClientArea);
                AbstractGridHelper.this.m_gridFigure.setBounds(AbstractGridHelper.this.hostClientArea);
            }
        }

        public void figureReparent(Figure source, Figure oldParent, Figure newParent) {
        }

        void install(Figure rootFigure) {
            if (this.m_rootFigure != null) {
                this.uninstall();
            }
            if (rootFigure != null) {
                rootFigure.addFigureListener(this);
                this.m_rootFigure = rootFigure;
            }
        }

        void uninstall() {
            if (this.m_rootFigure != null) {
                this.m_rootFigure.removeFigureListener(this);
                this.m_rootFigure = null;
            }
        }
    }
}

