/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.parser;

import com.google.common.collect.ImmutableMap;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wb.internal.core.model.description.resource.IDescriptionVersionsProvider;
import org.eclipse.wb.internal.core.model.description.resource.IDescriptionVersionsProviderFactory;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.reflect.BundleClassLoader;
import org.eclipse.wb.internal.core.utils.reflect.CompositeClassLoader;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.ILiveEditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.rcp.RcpToolkitDescription;
import org.eclipse.wb.internal.xwt.parser.XwtParser;

public final class XwtEditorContext
extends EditorContext {
    private final ILiveEditorContext m_liveEditorContext = new ILiveEditorContext(){

        public XmlObjectInfo parse(String[] sourceLines) throws Exception {
            String source = StringUtils.join((Object[])sourceLines, (String)"\n");
            Document document = new Document(source);
            XwtParser parser = new XwtParser(XwtEditorContext.this.m_file, (IDocument)document);
            XmlObjectInfo root = parser.parse();
            root.getContext().setLiveComponent(true);
            return root;
        }

        public void dispose() throws Exception {
        }
    };

    public XwtEditorContext(IFile file, IDocument document) throws Exception {
        super(RcpToolkitDescription.INSTANCE, file, document);
        this.configureDescriptionVersionsProviders();
        this.addVersions((Map)ImmutableMap.of((Object)"isXWT", (Object)"true"));
    }

    protected void addParentClassLoaders(final CompositeClassLoader parentClassLoader) throws Exception {
        super.addParentClassLoaders(parentClassLoader);
        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                XwtEditorContext.addParentClassLoaders_impl(parentClassLoader);
                return null;
            }
        });
    }

    private static void addParentClassLoaders_impl(CompositeClassLoader parentClassLoader) {
        parentClassLoader.add((ClassLoader)new BundleClassLoader("org.eclipse.wb.xwt"), null);
    }

    public ILiveEditorContext getLiveContext() {
        return this.m_liveEditorContext;
    }

    private void configureDescriptionVersionsProviders() throws Exception {
        List factories = ExternalFactoriesHelper.getElementsInstances(IDescriptionVersionsProviderFactory.class, (String)"org.eclipse.wb.core.descriptionVersionsProviderFactories", (String)"factory");
        for (IDescriptionVersionsProviderFactory factory : factories) {
            this.addVersions(factory.getVersions(this.m_javaProject, this.m_classLoader));
            IDescriptionVersionsProvider provider = factory.getProvider(this.m_javaProject, this.m_classLoader);
            if (provider == null) continue;
            this.addDescriptionVersionsProvider(provider);
        }
    }
}

