/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.layout;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.layout.absolute.BoundsProperty;
import org.eclipse.wb.internal.core.model.layout.absolute.OrderingSupport;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.util.AbsoluteLayoutCreationFlowSupport;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.broadcast.GenericPropertySetExpression;
import org.eclipse.wb.internal.core.xml.model.broadcast.XmlObjectAddProperties;
import org.eclipse.wb.internal.core.xml.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.xml.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.rcp.RcpToolkitDescription;
import org.eclipse.wb.internal.swt.Activator;
import org.eclipse.wb.internal.swt.model.layout.absolute.IAbsoluteLayoutInfo;
import org.eclipse.wb.internal.xwt.model.layout.AbsoluteLayoutCreationSupport;
import org.eclipse.wb.internal.xwt.model.layout.LayoutClipboardCommand;
import org.eclipse.wb.internal.xwt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.xwt.model.widgets.ControlInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AbsoluteLayoutInfo
extends LayoutInfo
implements IAbsoluteLayoutInfo<ControlInfo> {
    public AbsoluteLayoutInfo(EditorContext context, CreationSupport creationSupport) throws Exception {
        super(context, new ComponentDescription(null), creationSupport);
        this.getDescription().setToolkit(RcpToolkitDescription.INSTANCE);
        this.getDescription().setIcon(Activator.getImage((String)"info/layout/absolute/layout.gif"));
        this.addSupport_autoSize();
        this.addSupport_propertyBounds();
        this.addSupport_contextMenu();
    }

    protected List<Property> getPropertyList() throws Exception {
        return Collections.emptyList();
    }

    private void addSupport_autoSize() {
        this.addBroadcastListener(new GenericPropertySetExpression(){

            public void invoke(GenericPropertyImpl property, String[] expression, Object[] value, boolean[] shouldSet) throws Exception {
                this.checkForAutoSize(property);
            }

            private void checkForAutoSize(GenericPropertyImpl property) throws Exception {
                GenericPropertyDescription propertyDescription;
                IPreferenceStore preferences = AbsoluteLayoutInfo.this.getDescription().getToolkit().getPreferences();
                if (preferences.getBoolean("absoluteLayout.autoSize.onTextImage") && AbsoluteLayoutInfo.this.isManagedObject(property.getObject()) && (propertyDescription = property.getDescription()) != null) {
                    boolean isTextProperty = propertyDescription.hasTrueTag("isText");
                    boolean isImageProperty = propertyDescription.hasTrueTag("isImage");
                    if (isTextProperty || isImageProperty) {
                        final ControlInfo control = AbsoluteLayoutInfo.this.getControl(property.getObject());
                        ExecutionUtils.runLater((ObjectInfo)control, (RunnableEx)new RunnableEx(){

                            public void run() throws Exception {
                                AbsoluteLayoutInfo.this.commandChangeBounds(control, (Point)null, control.getPreferredSize());
                            }
                        });
                    }
                }
            }
        });
    }

    private void addSupport_propertyBounds() {
        this.addBroadcastListener(new XmlObjectAddProperties(){

            public void invoke(XmlObjectInfo object, List<Property> properties) throws Exception {
                if (AbsoluteLayoutInfo.this.isManagedObject(object)) {
                    ControlInfo control = AbsoluteLayoutInfo.this.getControl(object);
                    properties.add(AbsoluteLayoutInfo.this.getBoundsProperty(control));
                }
            }
        });
    }

    private void addSupport_contextMenu() {
        this.addBroadcastListener(new ObjectEventListener(){

            public void addContextMenu(List<? extends ObjectInfo> objects, ObjectInfo object, IMenuManager manager) throws Exception {
                if (AbsoluteLayoutInfo.this.isManagedObject(object)) {
                    ControlInfo control = AbsoluteLayoutInfo.this.getControl(object);
                    AbsoluteLayoutInfo.this.contributeControlContextMenu(manager, control);
                }
            }
        });
    }

    private void contributeControlContextMenu(IMenuManager manager, final ControlInfo control) {
        List<ControlInfo> controls = this.getComposite().getChildrenControls();
        new OrderingSupport(controls, (IAbstractComponentInfo)control).contributeActions(manager);
        ObjectInfoAction action = new ObjectInfoAction((ObjectInfo)control, "Autosize control", DesignerPlugin.getImageDescriptor((String)"info/layout/absolute/fit_to_size.png")){

            protected void runEx() throws Exception {
                AbsoluteLayoutInfo.this.commandChangeBounds(control, (Point)null, control.getPreferredSize());
            }
        };
        manager.appendToGroup("org.eclipse.wb.popup.group.constraints", (IAction)action);
    }

    @Override
    public void onSet() throws Exception {
        for (ControlInfo control : this.getComposite().getChildrenControls()) {
            Rectangle bounds = control.getModelBounds();
            String boundsString = String.valueOf(bounds.x) + ", " + bounds.y + ", " + bounds.width + ", " + bounds.height;
            control.setAttribute("bounds", boundsString);
        }
    }

    @Override
    protected void deleteLayoutData(ControlInfo control) throws Exception {
        super.deleteLayoutData(control);
        control.removeAttribute("location");
        control.removeAttribute("size");
        control.removeAttribute("bounds");
    }

    public static AbsoluteLayoutInfo createExplicitModel(EditorContext context) throws Exception {
        AbsoluteLayoutCreationSupport creationSupport = new AbsoluteLayoutCreationSupport();
        return new AbsoluteLayoutInfo(context, creationSupport);
    }

    private Property getBoundsProperty(ControlInfo control) {
        Rectangle modelBounds;
        ComplexProperty boundsProperty = (ComplexProperty)control.getArbitraryValue((Object)this);
        if (boundsProperty == null) {
            boundsProperty = new ComplexProperty("Bounds", null);
            boundsProperty.setCategory(PropertyCategory.system((int)5));
            boundsProperty.setModified(true);
            control.putArbitraryValue((Object)this, boundsProperty);
            BoundsProperty<ControlInfo> xProperty = new BoundsProperty<ControlInfo>(control, "x"){

                public void setValue2(int value, Rectangle modelBounds) throws Exception {
                    AbsoluteLayoutInfo.this.commandChangeBounds((ControlInfo)this.m_component, new Point(value, modelBounds.y), (Dimension)null);
                }
            };
            BoundsProperty<ControlInfo> yProperty = new BoundsProperty<ControlInfo>(control, "y"){

                public void setValue2(int value, Rectangle modelBounds) throws Exception {
                    AbsoluteLayoutInfo.this.commandChangeBounds((ControlInfo)this.m_component, new Point(modelBounds.x, value), (Dimension)null);
                }
            };
            BoundsProperty<ControlInfo> widthProperty = new BoundsProperty<ControlInfo>(control, "width"){

                public void setValue2(int value, Rectangle modelBounds) throws Exception {
                    AbsoluteLayoutInfo.this.commandChangeBounds((ControlInfo)this.m_component, (Point)null, new Dimension(value, modelBounds.height));
                }
            };
            BoundsProperty<ControlInfo> heightProperty = new BoundsProperty<ControlInfo>(control, "height"){

                public void setValue2(int value, Rectangle modelBounds) throws Exception {
                    AbsoluteLayoutInfo.this.commandChangeBounds((ControlInfo)this.m_component, (Point)null, new Dimension(modelBounds.width, value));
                }
            };
            boundsProperty.setProperties(new Property[]{xProperty, yProperty, widthProperty, heightProperty});
        }
        if ((modelBounds = control.getModelBounds()) != null) {
            boundsProperty.setText("(" + modelBounds.x + ", " + modelBounds.y + ", " + modelBounds.width + ", " + modelBounds.height + ")");
        }
        return boundsProperty;
    }

    public void commandCreate(ControlInfo control, ControlInfo nextControl) throws Exception {
        this.command_CREATE(control, nextControl);
    }

    public void commandMove(ControlInfo control, ControlInfo nextControl) throws Exception {
        this.command_MOVE(control, nextControl);
    }

    public void commandChangeBounds(ControlInfo control, Point location, Dimension size) throws Exception {
        this.commandChangeBounds0(control, location, size);
        if (location != null && this.useCreationFlow()) {
            AbsoluteLayoutCreationFlowSupport.apply((IAbstractComponentInfo)this.getComposite(), this.getControls(), (IAbstractComponentInfo)control, (Point)location, (Dimension)size);
        }
    }

    private void commandChangeBounds0(ControlInfo control, Point location, Dimension size) throws Exception {
        Assert.isLegal((location != null || size != null ? 1 : 0) != 0, (String)"Either location or size may not be null.");
        if (location == null && AbsoluteLayoutInfo.hasAttribute(control, "location")) {
            location = control.getModelBounds().getLocation();
        }
        if (size == null && AbsoluteLayoutInfo.hasAttribute(control, "size")) {
            size = control.getModelBounds().getSize();
        }
        if (AbsoluteLayoutInfo.hasAttribute(control, "bounds")) {
            if (location != null) {
                AbsoluteLayoutInfo.setExpression(control, "bounds", 0, location.x);
                AbsoluteLayoutInfo.setExpression(control, "bounds", 1, location.y);
            }
            if (size != null) {
                AbsoluteLayoutInfo.setExpression(control, "bounds", 2, size.width);
                AbsoluteLayoutInfo.setExpression(control, "bounds", 3, size.height);
            }
            control.removeAttribute("location");
            control.removeAttribute("size");
            return;
        }
        DocumentElement element = control.getCreationSupport().getElement();
        if (location != null && size != null) {
            String attributeString = String.valueOf(location.x) + ", " + location.y + ", " + size.width + ", " + size.height;
            element.setAttribute("bounds", attributeString);
            control.removeAttribute("location");
            control.removeAttribute("size");
        } else if (location != null) {
            String attributeString = String.valueOf(location.x) + ", " + location.y;
            element.setAttribute("location", attributeString);
        } else if (size != null) {
            String attributeString = String.valueOf(size.width) + ", " + size.height;
            element.setAttribute("size", attributeString);
        }
    }

    private static boolean hasAttribute(ControlInfo control, String attribute) {
        DocumentElement element = control.getCreationSupport().getElement();
        return element.getAttribute(attribute) != null;
    }

    private static void setExpression(ControlInfo control, String attribute, int index, int value) {
        DocumentElement element = control.getCreationSupport().getElement();
        String attributeString = element.getAttribute(attribute);
        Object[] attributeParts = StringUtils.split((String)attributeString, (String)", ");
        attributeParts[index] = Integer.toString(value);
        element.setAttribute(attribute, StringUtils.join((Object[])attributeParts, (String)", "));
    }

    private boolean useCreationFlow() {
        return this.getToolkit().getPreferences().getBoolean("P_CREATION_FLOW");
    }

    private ToolkitDescription getToolkit() {
        return this.getDescription().getToolkit();
    }

    @Override
    protected void clipboardCopy_addControlCommands(ControlInfo control, List<ClipboardCommand> commands) throws Exception {
        final Rectangle bounds = control.getModelBounds();
        commands.add(new LayoutClipboardCommand<AbsoluteLayoutInfo>(control){
            private static final long serialVersionUID = 0L;

            @Override
            protected void add(AbsoluteLayoutInfo layout, ControlInfo control) throws Exception {
                layout.command_CREATE(control, null);
                layout.commandChangeBounds(control, bounds.getLocation(), bounds.getSize());
            }
        });
    }
}

