/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.gef;

import com.google.common.collect.Lists;
import com.jgoodies.forms.layout.CellConstraints;
import java.util.List;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.gef.policy.layout.generic.AbstractPopupFigure;
import org.eclipse.wb.core.gef.policy.layout.grid.AbstractGridSelectionEditPolicy;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.requests.KeyRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.policies.GraphicalEditPolicy;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swing.FormLayout.gef.FormGridHelper;
import org.eclipse.wb.internal.swing.FormLayout.model.CellConstraintsSupport;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormSelectionEditPolicy
extends AbstractGridSelectionEditPolicy {
    private final FormLayoutInfo m_layout;
    private final ComponentInfo m_component;
    private final FormGridHelper m_gridHelper = new FormGridHelper((GraphicalEditPolicy)this, false);

    public FormSelectionEditPolicy(FormLayoutInfo layout, ComponentInfo component) {
        super((IAbstractComponentInfo)component);
        this.m_layout = layout;
        this.m_component = component;
    }

    protected boolean isActiveLayout() {
        return this.m_component.getParent().getChildren().contains(this.m_layout);
    }

    protected IGridInfo getGridInfo() {
        return this.m_layout.getGridInfo();
    }

    protected List<Handle> createSelectionHandles() {
        List handlesList = Lists.newArrayList();
        handlesList.add(this.createMoveHandle());
        handlesList.add(this.createSpanHandle(1, 0.25));
        handlesList.add(this.createSpanHandle(8, 0.25));
        handlesList.add(this.createSpanHandle(16, 0.75));
        handlesList.add(this.createSpanHandle(4, 0.75));
        return handlesList;
    }

    protected void showPrimarySelection() {
        super.showPrimarySelection();
        this.m_gridHelper.showGridFeedback();
    }

    protected void hideSelection() {
        this.m_gridHelper.eraseGridFeedback();
        super.hideSelection();
    }

    protected Figure createAlignmentFigure(IAbstractComponentInfo component, boolean horizontal) {
        IEditPartViewer viewer = this.getHost().getViewer();
        final CellConstraintsSupport constraints = FormLayoutInfo.getConstraints((ComponentInfo)component);
        if (horizontal) {
            return new AbstractPopupFigure(viewer, 9, 5){

                protected Image getImage() {
                    return constraints.getSmallAlignmentImage(true);
                }

                protected void fillMenu(IMenuManager manager) {
                    constraints.fillHorizontalAlignmentMenu(manager);
                }
            };
        }
        return new AbstractPopupFigure(viewer, 5, 9){

            protected Image getImage() {
                return constraints.getSmallAlignmentImage(false);
            }

            protected void fillMenu(IMenuManager manager) {
                constraints.fillVerticalAlignmentMenu(manager);
            }
        };
    }

    protected Command createSpanCommand(final boolean horizontal, final Rectangle cells) {
        return new EditCommand((ObjectInfo)this.m_layout){

            protected void executeEdit() throws Exception {
                CellConstraintsSupport support = FormLayoutInfo.getConstraints(FormSelectionEditPolicy.this.m_component);
                support.setSpan(horizontal, cells.getTranslated(1, 1));
                support.write();
            }
        };
    }

    public void performRequest(Request request) {
        KeyRequest keyRequest;
        if (request instanceof KeyRequest && (keyRequest = (KeyRequest)request).isPressed()) {
            char c = keyRequest.getCharacter();
            if (c == 'd') {
                this.setAlignment(true, CellConstraints.DEFAULT);
            } else if (c == 'l') {
                this.setAlignment(true, CellConstraints.LEFT);
            } else if (c == 'f') {
                this.setAlignment(true, CellConstraints.FILL);
            } else if (c == 'c') {
                this.setAlignment(true, CellConstraints.CENTER);
            } else if (c == 'r') {
                this.setAlignment(true, CellConstraints.RIGHT);
            }
            if (c == 'D') {
                this.setAlignment(false, CellConstraints.DEFAULT);
            } else if (c == 't') {
                this.setAlignment(false, CellConstraints.TOP);
            } else if (c == 'F') {
                this.setAlignment(false, CellConstraints.FILL);
            } else if (c == 'm') {
                this.setAlignment(false, CellConstraints.CENTER);
            } else if (c == 'b') {
                this.setAlignment(false, CellConstraints.BOTTOM);
            }
        }
    }

    private void setAlignment(final boolean horizontal, final CellConstraints.Alignment alignment) {
        ExecutionUtils.run((ObjectInfo)this.m_layout, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                CellConstraintsSupport support = FormLayoutInfo.getConstraints(FormSelectionEditPolicy.this.m_component);
                if (horizontal) {
                    support.setAlignH(alignment);
                } else {
                    support.setAlignV(alignment);
                }
                support.write();
            }
        });
    }
}

