/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.property.accessor;

import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.description.AbstractDescription;

public abstract class ExpressionAccessor
extends AbstractDescription {
    protected final String m_attribute;
    public static final String NO_DEFAULT_VALUE_TAG = "noDefaultValue";

    public ExpressionAccessor(String attribute) {
        this.m_attribute = attribute;
    }

    public final String getAttribute() {
        return this.m_attribute;
    }

    public boolean isModified(XmlObjectInfo object) throws Exception {
        String propertyName;
        if (this.getExpression(object) != null) {
            return true;
        }
        DocumentElement element = this.getElement(object);
        return element.getChild(propertyName = String.valueOf(element.getTag()) + "." + this.m_attribute, true) != null;
    }

    public String getExpression(XmlObjectInfo object) {
        DocumentElement element = this.getElement(object);
        return element.getAttribute(this.m_attribute);
    }

    public void setExpression(XmlObjectInfo object, String expression) throws Exception {
        DocumentElement element = this.getElement(object);
        element.setAttribute(this.m_attribute, expression);
        ExecutionUtils.refresh((ObjectInfo)object);
    }

    protected DocumentElement getElement(XmlObjectInfo object) {
        return object.getElement();
    }

    public Object getValue(XmlObjectInfo object) throws Exception {
        String value;
        if (this.hasTrueTag("x-rawValue") && (value = object.getAttribute(this.m_attribute)) != null) {
            return value;
        }
        return object.getAttributeValue(this.m_attribute);
    }

    public Object getDefaultValue(XmlObjectInfo object) throws Exception {
        return Property.UNKNOWN_VALUE;
    }
}

