/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.discovery.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.wb.internal.discovery.core.WBDiscoveryCorePlugin;
import org.eclipse.wb.internal.discovery.core.WBToolkit;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WBToolkitRegistry {
    private static WBToolkitRegistry registry;
    private List<WBToolkit> toolkits = new ArrayList<WBToolkit>();
    private List<IRegistryChangeListener> listeners = new ArrayList<IRegistryChangeListener>();

    public static WBToolkitRegistry getRegistry() {
        if (registry == null) {
            registry = new WBToolkitRegistry();
        }
        return registry;
    }

    private WBToolkitRegistry() {
        this.initRegistry();
    }

    public WBToolkit getToolkit(String toolkitId) {
        for (WBToolkit toolkit : this.getToolkits()) {
            if (!toolkitId.equals(toolkit.getId())) continue;
            return toolkit;
        }
        return null;
    }

    public List<WBToolkit> getToolkits() {
        return Collections.unmodifiableList(this.toolkits);
    }

    public void addRegistryListener(IRegistryChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeRegistryListener(IRegistryChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected long getLastCachedModified() {
        File toolkitsFile = this.getCacheLocation().append("toolkits.xml").toFile();
        if (toolkitsFile.exists() && toolkitsFile.canRead()) {
            return toolkitsFile.lastModified();
        }
        return 0L;
    }

    protected void updateCacheFrom(URL toolkitsUrl) {
        IPath cacheDirectory = this.getCacheLocation();
        this.copy(toolkitsUrl, cacheDirectory);
        try {
            for (WBToolkit toolkit : this.parseToolkits(toolkitsUrl)) {
                URL iconURL = toolkit.getIconURL();
                if (iconURL == null) continue;
                this.copy(iconURL, cacheDirectory);
            }
        }
        catch (Throwable t) {
            WBDiscoveryCorePlugin.logError(t);
        }
        this.parseToolkitsFromCache();
    }

    private void copy(URL fileURL, IPath parentDirectory) {
        String fileName = fileURL.getPath();
        if (fileName.indexOf(47) != -1) {
            fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
        }
        IPath filePath = parentDirectory.append(fileName);
        try {
            URLConnection connection = fileURL.openConnection();
            File outFile = filePath.toFile();
            this.copy(connection.getInputStream(), new FileOutputStream(outFile));
            long lastModified = connection.getHeaderFieldDate("Last-Modified", 0L);
            outFile.setLastModified(lastModified);
        }
        catch (IOException ioe) {
            WBDiscoveryCorePlugin.logError(ioe);
        }
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        int count = in.read(buffer);
        while (count != -1) {
            out.write(buffer, 0, count);
            count = in.read(buffer);
        }
        in.close();
        out.close();
    }

    private void initRegistry() {
        if (!this.cacheExists()) {
            URL toolkitsUrl = WBDiscoveryCorePlugin.getPlugin().getBundle().getEntry("resources/toolkits.xml");
            this.updateCacheFrom(toolkitsUrl);
        } else {
            this.parseToolkitsFromCache();
        }
    }

    private void parseToolkitsFromCache() {
        try {
            URL toolkitsFileURL = this.getCacheLocation().append("toolkits.xml").toFile().toURL();
            try {
                this.toolkits = this.parseToolkits(toolkitsFileURL);
            }
            catch (Throwable t) {
                WBDiscoveryCorePlugin.logError(t);
            }
            Collections.sort(this.toolkits, new Comparator<WBToolkit>(){

                @Override
                public int compare(WBToolkit toolkit1, WBToolkit toolkit2) {
                    return toolkit1.getName().compareToIgnoreCase(toolkit2.getName());
                }
            });
            for (IRegistryChangeListener listener : this.listeners) {
                listener.handleRegistryChange();
            }
        }
        catch (MalformedURLException exception) {
            WBDiscoveryCorePlugin.logError(exception);
        }
    }

    private boolean cacheExists() {
        File toolkitsFile = this.getCacheLocation().append("toolkits.xml").toFile();
        return toolkitsFile.exists();
    }

    private List<WBToolkit> parseToolkits(URL toolkitsData) throws IOException, Throwable {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setIgnoringComments(true);
        dbFactory.setIgnoringElementContentWhitespace(true);
        ArrayList<WBToolkit> results = new ArrayList<WBToolkit>();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(toolkitsData.openStream());
        doc.getDocumentElement().normalize();
        NodeList nodeList = doc.getElementsByTagName("toolkit");
        int s = 0;
        while (s < nodeList.getLength()) {
            Node node = nodeList.item(s);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                WBToolkit entry = new WBToolkit();
                entry.setId(this.getAttributeText(element, "id"));
                entry.setName(this.getAttributeText(element, "name"));
                entry.setTitle(this.getAttributeText(element, "title"));
                entry.setDescription(this.getNodeText(element, "description"));
                entry.setLicenseDescription(this.getAttributeText(element, "licenseDescription"));
                entry.setIconPath(toolkitsData, this.getAttributeText(element, "icon"));
                this.parseUpdateSiteInfo(element.getElementsByTagName("updateSite"), entry);
                entry.setProviderName(this.getAttributeText(element, "providerName"));
                entry.setMoreInfoURL(this.getAttributeText(element, "moreInfoURL"));
                String os = this.getAttributeText(element, "os");
                if (os != null) {
                    entry.setOsList(os.split(","));
                }
                if (entry.supportsCurrentOS() && entry.getUpdateSite() != null) {
                    results.add(entry);
                }
            }
            ++s;
        }
        return results;
    }

    private IPath getCacheLocation() {
        return WBDiscoveryCorePlugin.getPlugin().getStateLocation();
    }

    private void parseUpdateSiteInfo(NodeList nodes, WBToolkit entry) {
        int i = 0;
        while (i < nodes.getLength()) {
            Element element;
            Node node = nodes.item(i);
            if (node.getNodeType() == 1 && this.isInCurrentVersionRange(this.getAttributeText(element = (Element)node, "version"))) {
                entry.setUpdateSite(this.getAttributeText(element, "url"));
                entry.setAuxiliaryUpdateSite(this.getAttributeText(element, "auxurl"));
                NodeList features = element.getElementsByTagName("feature");
                int j = 0;
                while (j < features.getLength()) {
                    Node featureNode = features.item(j);
                    if (featureNode.getNodeType() == 1) {
                        Element featureElement = (Element)featureNode;
                        String featureId = this.getAttributeText(featureElement, "id");
                        boolean optional = "true".equals(this.getAttributeText(featureElement, "optional"));
                        entry.addFeature(featureId, optional);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private boolean isInCurrentVersionRange(String versionText) {
        if (versionText == null || versionText.length() == 0) {
            return true;
        }
        Bundle bundle = Platform.getBundle((String)"org.eclipse.core.runtime");
        Version currentVersion = bundle.getVersion();
        VersionRange range = new VersionRange(versionText);
        return range.isIncluded(currentVersion);
    }

    private String getAttributeText(Element element, String attributeName) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    private String getNodeText(Element parent, String nodeName) {
        NodeList list = parent.getElementsByTagName(nodeName);
        if (list != null && list.getLength() > 0) {
            return list.item(0).getTextContent();
        }
        return null;
    }

    public static interface IRegistryChangeListener {
        public void handleRegistryChange();
    }
}

