/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.examples.cdm.dept.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.ve.examples.cdm.dept.Company;
import org.eclipse.ve.examples.cdm.dept.Department;
import org.eclipse.ve.examples.cdm.dept.Employee;
import org.eclipse.ve.examples.cdm.dept.property.PropertySupport;
import org.eclipse.ve.examples.cdm.dept.property.UniqueDepartmentName;
import org.eclipse.ve.examples.cdm.dept.ui.AddDepartmentsCommand;
import org.eclipse.ve.examples.cdm.dept.ui.CompanyAnnotationLinkagePolicy;
import org.eclipse.ve.examples.cdm.dept.ui.RemoveDepartmentsCommand;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.core.AnnotationLinkagePolicy;
import org.eclipse.ve.internal.cde.core.AnnotationPolicy;
import org.eclipse.ve.internal.cde.core.ContainerPolicy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.cdm.DiagramData;
import org.eclipse.ve.internal.propertysheet.command.RestoreDefaultPropertyValueCommand;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public class CompanyContainerPolicy
extends ContainerPolicy {
    public CompanyContainerPolicy(EditDomain domain) {
        super(domain);
    }

    public Command getAddCommand(List children, Object position) {
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            Object child = itr.next();
            if (child instanceof Department) continue;
            return UnexecutableCommand.INSTANCE;
        }
        return new AddDepartmentsCommand((Company)this.container, children, (Department)position);
    }

    public Command getCreateCommand(Object child, Object position) {
        if (!(child instanceof Department)) {
            return UnexecutableCommand.INSTANCE;
        }
        Company parent = (Company)this.container;
        Department dept = (Department)child;
        ArrayList<Object> children = new ArrayList<Object>(1);
        children.add(child);
        CompoundCommand cc = new CompoundCommand();
        cc.append((Command)new UniqueDepartmentName(parent, dept));
        cc.append((Command)new AddDepartmentsCommand(parent, children, (Department)position));
        return AnnotationPolicy.getCreateRequestCommand((List)AnnotationPolicy.getAllAnnotations(new ArrayList(), (Object)child, (AnnotationLinkagePolicy)this.domain.getAnnotationLinkagePolicy()), (Command)cc, (EditDomain)this.domain);
    }

    public Command getDeleteDependentCommand(Object child) {
        if (!(child instanceof Department)) {
            return UnexecutableCommand.INSTANCE;
        }
        List annotations = AnnotationPolicy.getAllAnnotations(new ArrayList(), (Object)child, (AnnotationLinkagePolicy)this.domain.getAnnotationLinkagePolicy());
        CompoundCommand cmd = new CompoundCommand();
        Company parent = (Company)this.container;
        List<Object> list = Collections.singletonList(child);
        cmd.append((Command)new RemoveDepartmentsCommand(parent, list));
        if (((Department)child).getManager() != null) {
            RestoreDefaultPropertyValueCommand reset = new RestoreDefaultPropertyValueCommand();
            reset.setTarget(PropertySupport.getPropertySource(child));
            reset.setPropertyId((Object)"manager");
            cmd.append((Command)reset);
        }
        Iterator itr = ((Department)child).getEmployees().iterator();
        while (itr.hasNext()) {
            Employee emp = (Employee)itr.next();
            if (emp.getManages() == null) continue;
            RestoreDefaultPropertyValueCommand reset = new RestoreDefaultPropertyValueCommand();
            reset.setTarget(PropertySupport.getPropertySource(emp.getManages()));
            reset.setPropertyId((Object)"manager");
            cmd.append((Command)reset);
            Annotation mgrConn = this.domain.getAnnotationLinkagePolicy().getAnnotation((Object)new CompanyAnnotationLinkagePolicy.ManagedConnection(emp.getManages()));
            if (mgrConn == null) continue;
            annotations.add(mgrConn);
        }
        Annotation mgrConn = this.domain.getAnnotationLinkagePolicy().getAnnotation((Object)new CompanyAnnotationLinkagePolicy.ManagedConnection((Department)child));
        if (mgrConn != null) {
            annotations.add(mgrConn);
        }
        return AnnotationPolicy.getDeleteDependentCommand((List)annotations, (Command)cmd.unwrap(), (DiagramData)this.domain.getDiagramData());
    }

    public Command getMoveChildrenCommand(List children, Object position) {
        CommandBuilder cBld = new CommandBuilder("");
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            Object child = itr.next();
            if (child instanceof Department) continue;
            return UnexecutableCommand.INSTANCE;
        }
        if (children.contains(position)) {
            return UnexecutableCommand.INSTANCE;
        }
        Company parent = (Company)this.container;
        cBld.append((Command)new RemoveDepartmentsCommand(parent, children));
        cBld.append((Command)new AddDepartmentsCommand(parent, children, (Department)position));
        return cBld.getCommand();
    }

    protected Command getOrphanTheChildrenCommand(List children) {
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            Object child = itr.next();
            if (child instanceof Department) continue;
            return UnexecutableCommand.INSTANCE;
        }
        return new RemoveDepartmentsCommand((Company)this.container, children);
    }
}

