/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.examples.cdm.dept;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ve.examples.cdm.dept.Department;
import org.eclipse.ve.examples.cdm.dept.Employee;

public class Company
implements Serializable {
    private static final long serialVersionUID = -5394792597004813925L;
    protected String name;
    protected List departments = new ArrayList(1);
    protected transient PropertyChangeSupport propChange;
    public static final String COMPANY_NAME = "name";
    public static final String DEPARTMENTS = "departments";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChangeEvent(COMPANY_NAME, old, name);
    }

    public List getDepartments() {
        return Collections.unmodifiableList(this.departments);
    }

    public void addDepartment(Department dept) {
        this.departments.add(dept);
        dept.company = this;
        this.firePropertyChangeEvent(DEPARTMENTS, null, dept);
    }

    public void addDepartment(Department dept, int pos) {
        this.departments.add(pos, dept);
        dept.company = this;
        this.firePropertyChangeEvent(DEPARTMENTS, null, dept);
    }

    public void removeDepartment(Department dept) {
        this.departments.remove(dept);
        dept.company = null;
        this.firePropertyChangeEvent(DEPARTMENTS, dept, null);
    }

    public Iterator getEmployeesIterator() {
        return new Iterator(){
            Iterator deptItr;
            Iterator empItr;
            Employee next;
            {
                this.deptItr = Company.this.departments.iterator();
                this.empItr = null;
                this.next = null;
                this.setNext();
            }

            protected void setNext() {
                if (this.empItr == null) {
                    if (this.deptItr.hasNext()) {
                        Department dept = (Department)this.deptItr.next();
                        this.empItr = dept.getEmployees().iterator();
                        if (dept.getManager() != null && dept.getManager().getDepartment() == null) {
                            this.next = dept.getManager();
                        } else {
                            this.setNext();
                        }
                    } else {
                        this.next = null;
                    }
                } else if (this.empItr.hasNext()) {
                    this.next = (Employee)this.empItr.next();
                } else {
                    this.empItr = null;
                    this.setNext();
                }
            }

            public boolean hasNext() {
                return this.next != null;
            }

            public Object next() {
                Employee n = this.next;
                this.setNext();
                return n;
            }

            public void remove() {
            }
        };
    }

    public Employee getEmployee(String name) {
        Iterator itr = this.getEmployeesIterator();
        while (itr.hasNext()) {
            Employee e = (Employee)itr.next();
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propChange == null) {
            this.propChange = new PropertyChangeSupport(this);
        }
        this.propChange.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propChange == null) {
            this.propChange = new PropertyChangeSupport(this);
        }
        this.propChange.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.propChange == null) {
            this.propChange = new PropertyChangeSupport(this);
        }
        this.propChange.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.propChange == null) {
            this.propChange = new PropertyChangeSupport(this);
        }
        this.propChange.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (this.propChange != null) {
            this.propChange.firePropertyChange(propertyName, oldValue, newValue);
        }
    }
}

