/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

#include <Carbon.h>
#include <stdio.h>

#include "org_eclipse_ve_internal_swt_targetvm_macosx_ImageCapture.h"

//#define DEBUG

JNIEXPORT jint JNICALL Java_org_eclipse_ve_internal_swt_targetvm_macosx_ImageCapture_captureImage
  (JNIEnv * env, jobject this, jint controlHandle, jint shellHandle)
{	
	#ifdef DEBUG
		printf("Entering native image capture call\n");
	#endif

	// The image handle of the resulting image
	CGImageRef imageHandle;
		
	HIViewRef controlRef = (HIViewRef)controlHandle;
	WindowRef windowRef = (WindowRef)shellHandle;
	
	if (!IsValidWindowPtr(windowRef))
	{
		windowRef = NULL;
	}
			
	// Check to see if the controlHandle is a valid view ref
	if (HIViewIsValid(controlRef))
	{
			
		// Bounds rectangle of resulting image
		HIRect boundsRect;
		
		// Pointer to persist the current front process
		ProcessSerialNumber originalFrontProcess;
		
		// Pointer to persist the current running process (the SWT remote VM)
		ProcessSerialNumber swtVMProcess;
	
		// Grab the current front process (The current foreground application in OS X)
		GetFrontProcess(&originalFrontProcess);
		
		// Grab the process id of the SWT remote VM
		GetCurrentProcess(&swtVMProcess);

		// Set the SWT VM process as the front process		
		SetFrontProcess(&swtVMProcess);
		
		// Show the window and select it
		if (windowRef != NULL)
		{
			#ifdef DEBUG
				printf("Window reference %d is valid.\n", (int)shellHandle);
			#endif

			// Select the window			
			SelectWindow(windowRef);
		}
		
		// Create an image capture of the SWT VM
		HIViewCreateOffscreenImage(controlRef, 0, &boundsRect, &imageHandle);
		
		#ifdef DEBUG
			printf("Image width: %f height: %f\n", boundsRect.size.width, boundsRect.size.height);
		#endif
	
		// Restore the old front process
		SetFrontProcess(&originalFrontProcess);
	}

	#ifdef DEBUG
		printf("Exiting native image capture call\n");
		fflush( stdout );
    #endif
	
	// Return the handle of the created image to Java
  	return (jint)imageHandle;
}