/*******************************************************************************
 * Copyright (c) 2001, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ve.internal.java.codegen.util;
/*
 *  $RCSfile: BlockTemplate.java,v $
 *  $Revision: 1.3 $  $Date: 2005/08/24 23:30:47 $ 
 */


public class BlockTemplate {

public static final String LBRACE =    "{" ; //$NON-NLS-1$
public static final String RBRACE =    "}" ; //$NON-NLS-1$


	
	int                   fIndent=5 ;	
	int                   fexpIndet=5 ;
	ExpressionTemplate[]  fexpressions = null ;

public BlockTemplate(ExpressionTemplate[] exp, int indent) {
	fexpressions = exp;
	fIndent = indent ;
}

public void setExpressions (ExpressionTemplate[] exp) {
	fexpressions = exp ;
}	
public void setExpression(ExpressionTemplate exp) {
	fexpressions = new ExpressionTemplate[] { exp } ;
}
public void setIndent(int i) { fIndent = i; } ; 
	

protected void punchLine(StringBuffer sb,Object content) {
	for (int i=0; i<fIndent; i++)
	  sb.append(ExpressionTemplate.SPACE) ;
	sb.append(content.toString()) ;
	sb.append(System.getProperty("line.separator")) ; //$NON-NLS-1$
}	
	
/**
 *  This assumes that Statement was generated by this template.
 */
public String toString() {
	
	if (fexpressions == null) return null ;
	StringBuffer sb = new StringBuffer() ;
	punchLine(sb,LBRACE) ;
	for (int i=0; i<fexpressions.length; i++) {
		fexpressions[i].setIndent(fexpIndet) ;
		punchLine(sb,fexpressions[i]) ;
	}
	punchLine(sb,RBRACE) ;  
	return sb.toString() ;    
}		




}
