/*******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
#include <Carbon.h>
#include <stdio.h>

#include "org_eclipse_ve_internal_java_remotevm_macosx_ProcessManager.h"

JNIEXPORT jint JNICALL Java_org_eclipse_ve_internal_java_remotevm_macosx_ProcessManager_GetCurrentProcess
  (JNIEnv * env, jclass this, jintArray arg0) 
{
	jint *lparg0=NULL;
	jint rc = 0;
	if (arg0) if ((lparg0 = (*env)->GetIntArrayElements(env, arg0, NULL)) == NULL) goto fail;
	rc = (jint)GetCurrentProcess((ProcessSerialNumber *)lparg0);
fail:
	if (arg0 && lparg0) (*env)->ReleaseIntArrayElements(env, arg0, lparg0, 0);
	return rc;
}

JNIEXPORT jint JNICALL Java_org_eclipse_ve_internal_java_remotevm_macosx_ProcessManager_GetFrontProcess
  (JNIEnv * env, jclass this, jintArray arg0) 
{
	jint *lparg0=NULL;
	jint rc = 0;
	if (arg0) if ((lparg0 = (*env)->GetIntArrayElements(env, arg0, NULL)) == NULL) goto fail;
	rc = (jint)GetFrontProcess((ProcessSerialNumber *)lparg0);
fail:
	if (arg0 && lparg0) (*env)->ReleaseIntArrayElements(env, arg0, lparg0, 0);
	return rc;
}

JNIEXPORT jint JNICALL Java_org_eclipse_ve_internal_java_remotevm_macosx_ProcessManager_SetFrontProcess
  (JNIEnv * env, jclass this, jintArray arg0) 
{
	jint *lparg0=NULL;
	jint rc = 0;
	if (arg0) if ((lparg0 = (*env)->GetIntArrayElements(env, arg0, NULL)) == NULL) goto fail;
	rc = (jint)SetFrontProcess((const ProcessSerialNumber *)lparg0);
fail:
	if (arg0 && lparg0) (*env)->ReleaseIntArrayElements(env, arg0, lparg0, 0);
	return rc;
}  