/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.remote.CommandErrorException;
import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.common.remote.TransmitableArray;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.remote.IREMBeanProxy;
import org.eclipse.jem.internal.proxy.remote.IREMConnection;
import org.eclipse.jem.internal.proxy.remote.IREMMethodProxy;
import org.eclipse.jem.internal.proxy.remote.REMAccessibleObjectProxy;
import org.eclipse.jem.internal.proxy.remote.REMMethodProxy;
import org.eclipse.jem.internal.proxy.remote.REMMethodProxyFactory;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyConstants;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanProxyFactory;

final class REMMethodProxy
extends REMAccessibleObjectProxy
implements IREMMethodProxy {
    private IBeanTypeProxy fDeclaringType;
    private String fMethodName;
    private IBeanTypeProxy[] fParameterTypes;
    private IBeanTypeProxy fReturnType;

    REMMethodProxy(REMProxyFactoryRegistry aRegistry, Integer anID) {
        super(aRegistry, anID);
    }

    public IBeanTypeProxy getClassType() {
        if (this.fDeclaringType == null) {
            this.fDeclaringType = (IBeanTypeProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getMethodDeclaringClassMessage().invokeCatchThrowableExceptions(this);
        }
        return this.fDeclaringType;
    }

    public String getName() {
        if (this.fMethodName == null) {
            IStringBeanProxy proxy = (IStringBeanProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getMethodMethodNameMessage().invokeCatchThrowableExceptions(this);
            this.fMethodName = proxy != null ? proxy.stringValue() : "";
        }
        return this.fMethodName;
    }

    public synchronized IBeanTypeProxy[] getParameterTypes() {
        if (this.fParameterTypes == null) {
            IArrayBeanProxy parmTypes = (IArrayBeanProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getMethodParameterTypesMessage().invokeCatchThrowableExceptions(this);
            if (parmTypes == null) {
                this.fParameterTypes = new IBeanTypeProxy[0];
            } else {
                int len = parmTypes.getLength();
                this.fParameterTypes = new IBeanTypeProxy[len];
                int i = 0;
                while (i < len) {
                    try {
                        this.fParameterTypes[i] = (IBeanTypeProxy)parmTypes.get(i);
                    }
                    catch (ThrowableProxy throwableProxy) {}
                    ++i;
                }
                this.fFactory.releaseProxy(parmTypes);
            }
        }
        return this.fParameterTypes;
    }

    public IBeanTypeProxy getReturnType() {
        if (this.fReturnType == null) {
            this.fReturnType = (IBeanTypeProxy)REMStandardBeanProxyConstants.getConstants(this.fFactory).getMethodReturnTypeMessage().invokeCatchThrowableExceptions(this);
        }
        return this.fReturnType;
    }

    public IBeanProxy invoke(IBeanProxy subject) throws ThrowableProxy {
        return this.invoke(subject, (IBeanProxy[])null);
    }

    public IBeanProxy invoke(IBeanProxy subject, IBeanProxy[] parms) throws ThrowableProxy {
        return this.invokeWithParms(subject, parms);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IBeanProxy invokeWithParms(IBeanProxy subject, Object[] parms) throws ThrowableProxy {
        IREMConnection connect = this.fFactory.getFreeConnection();
        REMStandardBeanProxyFactory proxyFactory = (REMStandardBeanProxyFactory)this.fFactory.getBeanProxyFactory();
        proxyFactory.startTransaction();
        try {
            Commands.ValueObject subjectValue = new Commands.ValueObject();
            if (subject != null) {
                ((IREMBeanProxy)subject).renderBean(subjectValue);
            }
            Commands.ValueObject parmsValue = new Commands.ValueObject();
            class Retriever
            implements Commands.ValueRetrieve {
                int index;
                Object[] array;
                Commands.ValueObject worker;
                IStandardBeanTypeProxyFactory typeFactory;
                final /* synthetic */ REMMethodProxy this$0;

                public Retriever(REMMethodProxy rEMMethodProxy, Object[] anArray) {
                    this.this$0 = rEMMethodProxy;
                    this.index = 0;
                    this.worker = new Commands.ValueObject();
                    this.typeFactory = rEMMethodProxy.fFactory.getBeanTypeProxyFactory();
                    this.array = anArray;
                }

                public void reset() {
                    this.index = 0;
                }

                public Commands.ValueObject nextValue() {
                    Object parm;
                    if ((parm = this.array[this.index++]) != null) {
                        if (parm instanceof IREMBeanProxy) {
                            ((IREMBeanProxy)parm).renderBean(this.worker);
                        } else if (parm instanceof TransmitableArray) {
                            this.worker.setArrayIDS(new Retriever(this.this$0, ((TransmitableArray)parm).array), ((TransmitableArray)parm).array.length, ((TransmitableArray)parm).componentTypeID);
                        } else {
                            IREMBeanProxy type = (IREMBeanProxy)((Object)this.typeFactory.getBeanTypeProxy(parm.getClass().getName()));
                            if (type == null) {
                                throw new IllegalArgumentException();
                            }
                            int classID = type.getID();
                            this.worker.setAsObject(parm, classID);
                        }
                    } else {
                        this.worker.set();
                    }
                    return this.worker;
                }
            }
            Retriever retriever = null;
            if (parms != null) {
                retriever = new Retriever(this, parms);
                parmsValue.setArrayIDS(retriever, parms.length, 23);
            }
            Commands.ValueObject returnValue = new Commands.ValueObject();
            try {
                this.invoke(connect, proxyFactory, subjectValue, parmsValue, returnValue);
                IBeanProxy iBeanProxy = proxyFactory.getBeanProxy(returnValue);
                Object var11_13 = null;
                proxyFactory.stopTransaction();
                if (connect == null) return iBeanProxy;
                this.fFactory.returnConnection(connect);
                return iBeanProxy;
            }
            catch (CommandException e) {
                if (e.isRecoverable()) {
                    ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
                    IBeanProxy iBeanProxy = null;
                    Object var11_16 = null;
                    proxyFactory.stopTransaction();
                    if (connect == null) return iBeanProxy;
                    this.fFactory.returnConnection(connect);
                    return iBeanProxy;
                }
                this.fFactory.closeConnection(connect);
                connect = null;
                connect = this.fFactory.getFreeConnection();
                try {
                    if (retriever != null) {
                        retriever.reset();
                    }
                    this.invoke(connect, proxyFactory, subjectValue, parmsValue, returnValue);
                    IBeanProxy iBeanProxy = proxyFactory.getBeanProxy(returnValue);
                    Object var11_14 = null;
                    proxyFactory.stopTransaction();
                    if (connect == null) return iBeanProxy;
                    this.fFactory.returnConnection(connect);
                    return iBeanProxy;
                }
                catch (CommandException eAgain) {
                    this.fFactory.closeConnection(connect);
                    connect = null;
                    ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)eAgain));
                    IBeanProxy iBeanProxy = null;
                    Object var11_15 = null;
                    proxyFactory.stopTransaction();
                    if (connect == null) return iBeanProxy;
                    this.fFactory.returnConnection(connect);
                    return iBeanProxy;
                }
            }
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            proxyFactory.stopTransaction();
            if (connect == null) throw throwable;
            this.fFactory.returnConnection(connect);
            throw throwable;
        }
    }

    private void invoke(IREMConnection connect, REMStandardBeanProxyFactory proxyFactory, Commands.ValueObject subjectValue, Commands.ValueObject parmsValue, Commands.ValueObject returnValue) throws ThrowableProxy, CommandException {
        try {
            connect.invokeMethod(this.getID(), subjectValue, parmsValue, returnValue);
        }
        catch (CommandErrorException e) {
            proxyFactory.processErrorReturn(e);
        }
    }

    public IBeanProxy invoke(IBeanProxy subject, IBeanProxy parm) throws ThrowableProxy {
        return this.invoke(subject, new IBeanProxy[]{parm});
    }

    public IBeanProxy invokeCatchThrowableExceptions(IBeanProxy subject) {
        try {
            return this.invoke(subject);
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            this.fFactory.releaseProxy(e);
            return null;
        }
    }

    public IBeanProxy invokeCatchThrowableExceptions(IBeanProxy subject, IBeanProxy[] parms) {
        try {
            return this.invoke(subject, parms);
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            this.fFactory.releaseProxy(e);
            return null;
        }
    }

    public IBeanProxy invokeCatchThrowableExceptions(IBeanProxy subject, IBeanProxy parm) {
        try {
            return this.invoke(subject, parm);
        }
        catch (ThrowableProxy e) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)e));
            this.fFactory.releaseProxy(e);
            return null;
        }
    }

    public IBeanTypeProxy getTypeProxy() {
        return ((REMMethodProxyFactory)this.fFactory.getMethodProxyFactory()).methodType;
    }

    public void release() {
        this.fDeclaringType = null;
        this.fParameterTypes = null;
        this.fReturnType = null;
        super.release();
    }
}

