/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.ide;

import java.lang.reflect.Array;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IArrayBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.ide.IDEBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEObjectBeanProxy;
import org.eclipse.jem.internal.proxy.ide.IDEPrimitiveBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.ide.IDEStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IIDEBeanProxy;

public final class IDEArrayBeanProxy
extends IDEObjectBeanProxy
implements IArrayBeanProxy {
    private IDEStandardBeanTypeProxyFactory fBeanTypeProxyFactory;

    IDEArrayBeanProxy(IDEProxyFactoryRegistry aRegistry, Object array, IBeanTypeProxy aType) {
        super(aRegistry, array, aType);
        this.fBeanTypeProxyFactory = (IDEStandardBeanTypeProxyFactory)aRegistry.getBeanTypeProxyFactory();
    }

    public IBeanProxy get(int index) throws ThrowableProxy {
        IBeanTypeProxy compType = ((IArrayBeanTypeProxy)this.getTypeProxy()).getComponentType();
        if (!compType.isPrimitive()) {
            Object result = Array.get(this.fBean, index);
            if (result == null) {
                return null;
            }
            return ((IDEBeanTypeProxy)this.fBeanTypeProxyFactory.getBeanTypeProxy(result.getClass())).newBeanProxy(result);
        }
        int id = ((IDEPrimitiveBeanTypeProxy)compType).getPrimitiveType();
        switch (id) {
            case 2: {
                return this.fBeanTypeProxyFactory.byteType.createByteBeanProxy(Array.getByte(this.fBean, index));
            }
            case 1: {
                return this.fBeanTypeProxyFactory.booleanType.createBooleanBeanProxy(Array.getBoolean(this.fBean, index));
            }
            case 3: {
                return this.fBeanTypeProxyFactory.charType.createCharBeanProxy(Array.getChar(this.fBean, index));
            }
            case 4: {
                return this.fBeanTypeProxyFactory.doubleType.createDoubleBeanProxy(Array.getDouble(this.fBean, index));
            }
            case 5: {
                return this.fBeanTypeProxyFactory.floatType.createFloatBeanProxy(Array.getFloat(this.fBean, index));
            }
            case 6: {
                return this.fBeanTypeProxyFactory.intType.createIntegerBeanProxy(Array.getInt(this.fBean, index));
            }
            case 7: {
                return this.fBeanTypeProxyFactory.longType.createLongBeanProxy(Array.getLong(this.fBean, index));
            }
            case 8: {
                return this.fBeanTypeProxyFactory.shortType.createShortBeanProxy(Array.getShort(this.fBean, index));
            }
        }
        return null;
    }

    public IBeanProxy get(int[] indexes) throws ThrowableProxy {
        IBeanTypeProxy finalCompType;
        if (indexes.length == 1) {
            return this.get(indexes[0]);
        }
        int dims = ((IArrayBeanTypeProxy)this.getTypeProxy()).getDimensions();
        if (dims < indexes.length) {
            throw new IllegalArgumentException();
        }
        Object array = this.fBean;
        int lastArrayDim = indexes.length - 1;
        int i = 0;
        while (i < lastArrayDim) {
            array = Array.get(array, indexes[i]);
            ++i;
        }
        int index = indexes[lastArrayDim];
        if (dims == indexes.length && (finalCompType = ((IArrayBeanTypeProxy)this.getTypeProxy()).getFinalComponentType()).isPrimitive()) {
            int id = ((IDEPrimitiveBeanTypeProxy)finalCompType).getPrimitiveType();
            switch (id) {
                case 2: {
                    return this.fBeanTypeProxyFactory.byteType.createByteBeanProxy(Array.getByte(array, index));
                }
                case 1: {
                    return this.fBeanTypeProxyFactory.booleanType.createBooleanBeanProxy(Array.getBoolean(array, index));
                }
                case 3: {
                    return this.fBeanTypeProxyFactory.charType.createCharBeanProxy(Array.getChar(array, index));
                }
                case 4: {
                    return this.fBeanTypeProxyFactory.doubleType.createDoubleBeanProxy(Array.getDouble(array, index));
                }
                case 5: {
                    return this.fBeanTypeProxyFactory.floatType.createFloatBeanProxy(Array.getFloat(array, index));
                }
                case 6: {
                    return this.fBeanTypeProxyFactory.intType.createIntegerBeanProxy(Array.getInt(array, index));
                }
                case 7: {
                    return this.fBeanTypeProxyFactory.longType.createLongBeanProxy(Array.getLong(array, index));
                }
                case 8: {
                    return this.fBeanTypeProxyFactory.shortType.createShortBeanProxy(Array.getShort(array, index));
                }
            }
            return null;
        }
        Object result = Array.get(array, index);
        if (result == null) {
            return null;
        }
        return ((IDEBeanTypeProxy)this.fBeanTypeProxyFactory.getBeanTypeProxy(result.getClass())).newBeanProxy(result);
    }

    public void set(IBeanProxy valueProxy, int index) throws ThrowableProxy {
        Object value = ((IIDEBeanProxy)valueProxy).getBean();
        Class<?> valueClass = value.getClass();
        if (!valueClass.isPrimitive()) {
            Array.set(this.fBean, index, value);
        } else if (valueClass == Byte.TYPE) {
            Array.setByte(this.fBean, index, (Byte)value);
        } else if (valueClass == Boolean.TYPE) {
            Array.setBoolean(this.fBean, index, (Boolean)value);
        } else if (valueClass == Character.TYPE) {
            Array.setChar(this.fBean, index, ((Character)value).charValue());
        } else if (valueClass == Double.TYPE) {
            Array.setDouble(this.fBean, index, (Double)value);
        } else if (valueClass == Float.TYPE) {
            Array.setFloat(this.fBean, index, ((Float)value).floatValue());
        } else if (valueClass == Integer.TYPE) {
            Array.setInt(this.fBean, index, (Integer)value);
        } else if (valueClass == Long.TYPE) {
            Array.setLong(this.fBean, index, (Long)value);
        } else if (valueClass == Short.TYPE) {
            Array.setShort(this.fBean, index, (Short)value);
        }
    }

    public void set(IBeanProxy valueProxy, int[] indexes) throws ThrowableProxy {
        Object subArray = this.fBean;
        int upTo = indexes.length - 1;
        int i = 0;
        while (i < upTo) {
            subArray = Array.get(subArray, indexes[i]);
            ++i;
        }
        int index = indexes[upTo];
        Object value = ((IIDEBeanProxy)valueProxy).getBean();
        Class<?> valueClass = value.getClass();
        if (!valueClass.isPrimitive()) {
            Array.set(subArray, index, value);
        } else if (valueClass == Byte.TYPE) {
            Array.setByte(subArray, index, (Byte)value);
        } else if (valueClass == Boolean.TYPE) {
            Array.setBoolean(subArray, index, (Boolean)value);
        } else if (valueClass == Character.TYPE) {
            Array.setChar(subArray, index, ((Character)value).charValue());
        } else if (valueClass == Double.TYPE) {
            Array.setDouble(subArray, index, (Double)value);
        } else if (valueClass == Float.TYPE) {
            Array.setFloat(subArray, index, ((Float)value).floatValue());
        } else if (valueClass == Integer.TYPE) {
            Array.setInt(subArray, index, (Integer)value);
        } else if (valueClass == Long.TYPE) {
            Array.setLong(subArray, index, (Long)value);
        } else if (valueClass == Short.TYPE) {
            Array.setShort(subArray, index, (Short)value);
        }
    }

    public int getLength() {
        return Array.getLength(this.fBean);
    }

    public IBeanProxy getCatchThrowableException(int index) {
        try {
            return this.get(index);
        }
        catch (ThrowableProxy exc) {
            ProxyPlugin.getPlugin().getLogger().log((Object)new Status(2, ProxyPlugin.getPlugin().getBundle().getSymbolicName(), 0, "", (Throwable)exc));
            return null;
        }
    }

    public IBeanProxy[] getSnapshot() throws ThrowableProxy {
        IBeanTypeProxy compType = ((IArrayBeanTypeProxy)this.getTypeProxy()).getComponentType();
        int id = compType.isPrimitive() ? ((IDEPrimitiveBeanTypeProxy)compType).getPrimitiveType() : -1;
        IBeanProxy[] result = new IBeanProxy[Array.getLength(this.fBean)];
        int i = 0;
        while (i < result.length) {
            if (id == -1) {
                Object val = Array.get(this.fBean, i);
                if (val != null) {
                    result[i] = ((IDEBeanTypeProxy)this.fBeanTypeProxyFactory.getBeanTypeProxy(val.getClass())).newBeanProxy(val);
                }
            } else {
                switch (id) {
                    case 2: {
                        result[i] = this.fBeanTypeProxyFactory.byteType.createByteBeanProxy(Array.getByte(this.fBean, i));
                        break;
                    }
                    case 1: {
                        result[i] = this.fBeanTypeProxyFactory.booleanType.createBooleanBeanProxy(Array.getBoolean(this.fBean, i));
                        break;
                    }
                    case 3: {
                        result[i] = this.fBeanTypeProxyFactory.charType.createCharBeanProxy(Array.getChar(this.fBean, i));
                        break;
                    }
                    case 4: {
                        result[i] = this.fBeanTypeProxyFactory.doubleType.createDoubleBeanProxy(Array.getDouble(this.fBean, i));
                        break;
                    }
                    case 5: {
                        result[i] = this.fBeanTypeProxyFactory.floatType.createFloatBeanProxy(Array.getFloat(this.fBean, i));
                        break;
                    }
                    case 6: {
                        result[i] = this.fBeanTypeProxyFactory.intType.createIntegerBeanProxy(Array.getInt(this.fBean, i));
                        break;
                    }
                    case 7: {
                        result[i] = this.fBeanTypeProxyFactory.longType.createLongBeanProxy(Array.getLong(this.fBean, i));
                        break;
                    }
                    case 8: {
                        result[i] = this.fBeanTypeProxyFactory.shortType.createShortBeanProxy(Array.getShort(this.fBean, i));
                        break;
                    }
                }
            }
            ++i;
        }
        return result;
    }
}

