/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jem.internal.proxy.common.AmbiguousMethodException;
import org.eclipse.jem.internal.proxy.common.Messages;

public class MethodHelper {
    public static final Class NULL_TYPE;
    static final ArrayList sPrimitivesOrder;
    static final int sCharPos;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jem.internal.proxy.common.MethodHelper$NULL_CLASS");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        NULL_TYPE = clazz;
        sPrimitivesOrder = new ArrayList(6);
        sPrimitivesOrder.add(Byte.TYPE);
        sPrimitivesOrder.add(Short.TYPE);
        sPrimitivesOrder.add(Integer.TYPE);
        sPrimitivesOrder.add(Long.TYPE);
        sPrimitivesOrder.add(Float.TYPE);
        sPrimitivesOrder.add(Double.TYPE);
        sCharPos = sPrimitivesOrder.indexOf(Short.TYPE);
    }

    public static boolean isAssignableFrom(Class type1, Class type2) {
        if (type1 == type2) {
            return true;
        }
        if (type1.isPrimitive()) {
            if (type2.isPrimitive()) {
                int type2Pos;
                if (type1 == Boolean.TYPE || type2 == Boolean.TYPE) {
                    return false;
                }
                int type1Pos = type1 != Character.TYPE ? sPrimitivesOrder.indexOf(type1) : sCharPos;
                int n = type2Pos = type2 != Character.TYPE ? sPrimitivesOrder.indexOf(type2) : sCharPos;
                return type1Pos > type2Pos;
            }
            return false;
        }
        if (type2 == NULL_TYPE) {
            return true;
        }
        return type1.isAssignableFrom(type2);
    }

    public static boolean isAssignableFrom(Class[] types1, Class[] types2) {
        if (types1.length != types2.length) {
            return false;
        }
        int i = 0;
        while (i < types1.length) {
            if (!MethodHelper.isAssignableFrom(types1[i], types2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static int findMostCompatible(List methods, List parms, String ambiguousName) throws AmbiguousMethodException {
        Class[][] parmsCopy = (Class[][])parms.toArray((T[])new Class[parms.size()][]);
        int size = parmsCopy.length;
        int i = 0;
        while (i < size) {
            block3: {
                Class<?> dclClassi = methods != null ? ((Method)methods.get(i)).getDeclaringClass() : null;
                Class[] parmsi = parmsCopy[i];
                int j = 0;
                while (j < size) {
                    Class[] parmsj;
                    if (i == j || (dclClassi == null || MethodHelper.isAssignableFrom(((Method)methods.get(j)).getDeclaringClass(), dclClassi)) && MethodHelper.isAssignableFrom(parmsj = parmsCopy[j], parmsi)) {
                        ++j;
                        continue;
                    }
                    break block3;
                }
                return i;
            }
            ++i;
        }
        throw new AmbiguousMethodException(ambiguousName);
    }

    /*
     * Unable to fully structure code
     */
    public static Method findCompatibleMethod(Class receiver, String methodName, Class[] arguments) throws NoSuchMethodException, AmbiguousMethodException {
        block11: {
            try {
                return receiver.getMethod(methodName, arguments);
            }
            catch (NoSuchMethodException exc) {
                if (arguments == null) break block11;
                parmsList = new ArrayList<Object[]>();
                mthdsList = new ArrayList<Method>();
                cls = receiver;
                ** while (cls != null)
            }
lbl-1000:
            // 1 sources

            {
                mthds = cls.getDeclaredMethods();
                i = 0;
                while (i < mthds.length) {
                    mthd = mthds[i];
                    if (mthd.getName().equals(methodName) && (Modifier.isPublic(modifiers = mthd.getModifiers()) || Modifier.isProtected(modifiers))) {
                        parms = mthd.getParameterTypes();
                        if (Arrays.equals(arguments, parms)) {
                            return MethodHelper.makeMethodAccessable(mthd);
                        }
                        if (MethodHelper.isAssignableFrom((Class[])parms, arguments)) {
                            size = parmsList.size();
                            j = 0;
                            while (j < size) {
                                if (Arrays.equals(parms, (Object[])parmsList.get(j))) {
                                    // empty if block
                                }
                                ++j;
                            }
                            parmsList.add(parms);
                            mthdsList.add(mthd);
                        }
                    }
                    ++i;
                }
                cls = cls.getSuperclass();
                continue;
            }
lbl33:
            // 1 sources

            if (parmsList.size() == 0) {
                throw MethodHelper.throwFixedNoSuchMethod(exc, receiver, methodName, arguments);
            }
            if (parmsList.size() == 1) {
                return MethodHelper.makeMethodAccessable((Method)mthdsList.get(0));
            }
            mostCompatible = MethodHelper.findMostCompatible(mthdsList, parmsList, methodName);
            return MethodHelper.makeMethodAccessable((Method)mthdsList.get(mostCompatible));
        }
        throw MethodHelper.throwFixedNoSuchMethod(exc, receiver, methodName, arguments);
    }

    private static Method makeMethodAccessable(Method m) {
        m.setAccessible(true);
        return m;
    }

    private static NoSuchMethodException throwFixedNoSuchMethod(NoSuchMethodException e, Class declareClass, String methodName, Class[] argClasses) {
        StringBuffer s = new StringBuffer();
        s.append(declareClass.getName());
        s.append('.');
        s.append(methodName);
        s.append('(');
        if (argClasses != null) {
            int i = 0;
            while (i < argClasses.length) {
                if (i > 0) {
                    s.append(',');
                }
                s.append(argClasses[i].getName());
                ++i;
            }
        }
        s.append(')');
        NoSuchMethodException ne = new NoSuchMethodException(s.toString());
        ne.setStackTrace(e.getStackTrace());
        return ne;
    }

    /*
     * Unable to fully structure code
     */
    public static Constructor findCompatibleConstructor(Class receiver, Class[] arguments) throws NoSuchMethodException, AmbiguousMethodException, IllegalAccessException {
        block7: {
            if (receiver.getDeclaringClass() != null && !Modifier.isStatic(receiver.getModifiers())) {
                throw new IllegalAccessException(MessageFormat.format(Messages.getString("MethodHelper.NONSTATICINNERCLASS_WARNING"), new Object[]{receiver.getName()}));
            }
            try {
                ctor = receiver.getDeclaredConstructor(arguments);
                ctor.setAccessible(true);
                return ctor;
            }
            catch (NoSuchMethodException exc) {
                if (arguments == null) break block7;
                ctors = receiver.getDeclaredConstructors();
                parmsList = new ArrayList<Class[]>(ctors.length);
                ctorsList = new ArrayList<Constructor>(ctors.length);
                i = 0;
                ** while (i < ctors.length)
            }
lbl-1000:
            // 1 sources

            {
                ctor = ctors[i];
                parms = ctor.getParameterTypes();
                if (MethodHelper.isAssignableFrom(parms, arguments)) {
                    parmsList.add(parms);
                    ctorsList.add(ctor);
                }
                ++i;
                continue;
            }
lbl23:
            // 1 sources

            if (parmsList.size() == 0) {
                throw exc;
            }
            if (parmsList.size() == 1) {
                ctor = (Constructor)ctorsList.get(0);
                ctor.setAccessible(true);
                return ctor;
            }
            mostCompatible = MethodHelper.findMostCompatible(null, parmsList, receiver.getName());
            ctor = (Constructor)ctorsList.get(mostCompatible);
            ctor.setAccessible(true);
            return ctor;
        }
        throw exc;
    }

    private static class NULL_CLASS {
        NULL_CLASS() {
        }
    }
}

