/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.internal.beaninfo.adapters.BeaninfoNature;
import org.eclipse.jem.internal.beaninfo.core.BeaninfoEntry;
import org.eclipse.jem.internal.beaninfo.core.ConfigurationElementReader;
import org.eclipse.jem.internal.beaninfo.core.IBeanInfoContributor;
import org.eclipse.jem.internal.proxy.core.ContainerPathContributionMapping;
import org.eclipse.jem.internal.proxy.core.ContributorExtensionPointInfo;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionInfo;
import org.eclipse.jem.internal.proxy.core.ProxyLaunchSupport;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.util.logger.proxyrender.EclipseLogger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BeaninfoPlugin
extends Plugin {
    public static final String PI_BEANINFO_PLUGINID = "org.eclipse.jem.beaninfo";
    public static final String PI_BEANINFO_OVERRIDES = "overrides";
    private static BeaninfoPlugin BEANINFO_PLUGIN = null;
    public static final String ROOT = "..ROOT..";
    public static final String ROOT_SCHEMA = "X";
    public static final String ROOT_OPAQUE = "ROOT";
    public static final String OVERRIDE_EXTENSION = "override";
    private Map openNatures;
    private ContainerPathContributionMapping beaninfoEntryContributionsMapping;
    private ContainerPathContributionMapping contributorContributionsMapping;
    private Map pluginToBeaninfoEntryContributions;
    private Map pluginToContributors;
    private IPath[] ocFragments;
    private OverrideContribution[][] ocContainerIds;
    private OverrideContribution[][] ocPluginIds;
    private static final OverrideContribution[] EMPTY_OC = new OverrideContribution[0];
    public static final String PI_BEANINFO_CONTRIBUTION_EXTENSION_POINT = "org.eclipse.jem.beaninfo.registrations";
    public static final String PI_REGISTRATION = "registration";
    public static final String PI_BEANINFO = "beaninfo";
    public static final String PI_OVERRIDE = "override";
    public static final String PI_CONTRIBUTOR = "contributor";
    public static final String PI_PACKAGE = "package";
    public static final String PI_PATH = "path";
    private static final String[] NO_PATHS = new String[0];
    private Logger logger;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public BeaninfoPlugin() {
        BEANINFO_PLUGIN = this;
    }

    public static BeaninfoPlugin getPlugin() {
        return BEANINFO_PLUGIN;
    }

    public synchronized BeaninfoEntry[] getContainerIdBeanInfos(String containerID, String[] containerPaths) {
        if (this.beaninfoEntryContributionsMapping == null) {
            this.processBeanInfoContributionExtensionPoint();
        }
        return (BeaninfoEntry[])this.beaninfoEntryContributionsMapping.getContributors(containerID, containerPaths);
    }

    public synchronized BeaninfoEntry[] getPluginBeanInfos(String pluginid) {
        if (this.pluginToBeaninfoEntryContributions == null) {
            this.processBeanInfoContributionExtensionPoint();
        }
        return (BeaninfoEntry[])this.pluginToBeaninfoEntryContributions.get(pluginid);
    }

    public synchronized IConfigurationElement[] getPluginContributors(String pluginid) {
        if (this.pluginToContributors == null) {
            this.processBeanInfoContributionExtensionPoint();
        }
        return (IConfigurationElement[])this.pluginToContributors.get(pluginid);
    }

    public synchronized IConfigurationElement[] getContainerIdContributors(String containerID, String[] containerPaths) {
        if (this.contributorContributionsMapping == null) {
            this.processBeanInfoContributionExtensionPoint();
        }
        return (IConfigurationElement[])this.contributorContributionsMapping.getContributors(containerID, containerPaths);
    }

    protected synchronized void processBeanInfoContributionExtensionPoint() {
        int i;
        Map.Entry entry;
        ContributorExtensionPointInfo info = ProxyPlugin.processContributionExtensionPoint((String)PI_BEANINFO_CONTRIBUTION_EXTENSION_POINT);
        ConfigurationElementReader reader = new ConfigurationElementReader();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jem.internal.beaninfo.core.BeaninfoEntry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.beaninfoEntryContributionsMapping = new ContainerPathContributionMapping((Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.runtime.IConfigurationElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.contributorContributionsMapping = new ContainerPathContributionMapping((Class)clazz2);
        HashMap fragmentsToIds = new HashMap();
        Iterator iter = info.containerPathContributions.containerIdToContributions.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            String containerid = (String)entry.getKey();
            ContainerPathContributionMapping.ContainerContributionEntry[] contribElements = (ContainerPathContributionMapping.ContainerContributionEntry[])entry.getValue();
            i = 0;
            while (i < contribElements.length) {
                ContainerPathContributionMapping.ContainerContributionEntry contribElement = contribElements[i];
                IConfigurationElement element = (IConfigurationElement)contribElement.getContribution();
                if (PI_REGISTRATION.equals(element.getName())) {
                    IConfigurationElement[] children = element.getChildren();
                    int j = 0;
                    while (j < children.length) {
                        IConfigurationElement child = children[j];
                        if (PI_BEANINFO.equals(child.getName())) {
                            BeaninfoEntry be = BeaninfoEntry.readEntry(reader, child, null);
                            if (be != null) {
                                this.beaninfoEntryContributionsMapping.addContribution(containerid, contribElement.getContainerPathPattern(), (Object)be);
                            }
                        } else if ("override".equals(child.getName())) {
                            this.addOverrideEntry(fragmentsToIds, true, containerid, contribElement.getContainerPathPattern(), child);
                        }
                        ++j;
                    }
                } else if (PI_CONTRIBUTOR.equals(element.getName())) {
                    this.contributorContributionsMapping.addContribution(containerid, contribElement.getContainerPathPattern(), (Object)element);
                }
                ++i;
            }
        }
        this.beaninfoEntryContributionsMapping.finalizeMapping();
        this.contributorContributionsMapping.finalizeMapping();
        this.pluginToBeaninfoEntryContributions = new HashMap(info.pluginToContributions.size());
        iter = info.pluginToContributions.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            String pluginId = (String)entry.getKey();
            IConfigurationElement[] configElements = (IConfigurationElement[])entry.getValue();
            i = 0;
            while (i < configElements.length) {
                IConfigurationElement element = configElements[i];
                if (PI_REGISTRATION.equals(element.getName())) {
                    IConfigurationElement[] children = element.getChildren();
                    int j = 0;
                    while (j < children.length) {
                        IConfigurationElement child = children[j];
                        if (PI_BEANINFO.equals(child.getName())) {
                            BeaninfoEntry be = BeaninfoEntry.readEntry(reader, child, null);
                            if (be != null) {
                                this.addEntry(this.pluginToBeaninfoEntryContributions, pluginId, be);
                            }
                        } else if ("override".equals(child.getName())) {
                            this.addOverrideEntry(fragmentsToIds, false, pluginId, null, child);
                        }
                        ++j;
                    }
                } else if (PI_CONTRIBUTOR.equals(element.getName())) {
                    if (this.pluginToContributors == null) {
                        this.pluginToContributors = new HashMap(5);
                    }
                    this.addEntry(this.pluginToContributors, pluginId, element);
                }
                ++i;
            }
        }
        iter = this.pluginToBeaninfoEntryContributions.entrySet().iterator();
        while (iter.hasNext()) {
            entry = iter.next();
            entry.setValue(((List)entry.getValue()).toArray(new BeaninfoEntry[((List)entry.getValue()).size()]));
        }
        if (this.pluginToContributors == null) {
            this.pluginToContributors = Collections.EMPTY_MAP;
        } else {
            iter = this.pluginToContributors.entrySet().iterator();
            while (iter.hasNext()) {
                entry = iter.next();
                entry.setValue((BeaninfoEntry[])((List)entry.getValue()).toArray(new IConfigurationElement[((List)entry.getValue()).size()]));
            }
        }
        this.ocFragments = new IPath[fragmentsToIds.size()];
        this.ocContainerIds = new OverrideContribution[this.ocFragments.length][];
        this.ocPluginIds = new OverrideContribution[this.ocFragments.length][];
        iter = fragmentsToIds.entrySet().iterator();
        int fragIndex = 0;
        while (iter.hasNext()) {
            Map.Entry mapEntry = iter.next();
            this.ocFragments[fragIndex] = (IPath)mapEntry.getKey();
            Map[] mapValue = (Map[])mapEntry.getValue();
            if (mapValue[0] == null) {
                this.ocContainerIds[fragIndex] = EMPTY_OC;
            } else {
                Map containers = mapValue[0];
                ArrayList<OverrideContribution> ocContributions = new ArrayList<OverrideContribution>();
                Iterator ocIterator = containers.entrySet().iterator();
                while (ocIterator.hasNext()) {
                    Map.Entry containerEntry = ocIterator.next();
                    String containerID = (String)containerEntry.getKey();
                    Iterator patternIterator = ((Map)containerEntry.getValue()).entrySet().iterator();
                    while (patternIterator.hasNext()) {
                        Map.Entry patternEntry = patternIterator.next();
                        OverrideContribution oc = new OverrideContribution();
                        oc.id = containerID;
                        oc.pattern = (Pattern)patternEntry.getKey();
                        List[] ocLists = (List[])patternEntry.getValue();
                        oc.pluginIds = ocLists[0].toArray(new String[ocLists[0].size()]);
                        oc.paths = ocLists[1].toArray(new String[ocLists[1].size()]);
                        ocContributions.add(oc);
                    }
                }
                this.ocContainerIds[fragIndex] = ocContributions.toArray(new OverrideContribution[ocContributions.size()]);
            }
            if (mapValue[1] == null) {
                this.ocPluginIds[fragIndex] = EMPTY_OC;
            } else {
                Map plugins = mapValue[1];
                this.ocPluginIds[fragIndex] = new OverrideContribution[plugins.size()];
                OverrideContribution[] ocContribution = this.ocPluginIds[fragIndex];
                Iterator ocIterator = plugins.entrySet().iterator();
                int ocIndex = 0;
                while (ocIterator.hasNext()) {
                    Map.Entry pluginEntry = ocIterator.next();
                    OverrideContribution oc = ocContribution[ocIndex] = new OverrideContribution();
                    oc.id = (String)pluginEntry.getKey();
                    List[] ocLists = (List[])pluginEntry.getValue();
                    oc.pluginIds = ocLists[0].toArray(new String[ocLists[0].size()]);
                    oc.paths = ocLists[1].toArray(new String[ocLists[1].size()]);
                    ++ocIndex;
                }
            }
            ++fragIndex;
        }
    }

    private void addEntry(Map map, Object key, Object entry) {
        ArrayList<Object> mapEntry = (ArrayList<Object>)map.get(key);
        if (mapEntry == null) {
            mapEntry = new ArrayList<Object>(1);
            map.put(key, mapEntry);
        }
        mapEntry.add(entry);
    }

    private void addOverrideEntry(Map map, boolean container, Object id, Pattern pattern, IConfigurationElement entry) {
        List[] idEntry;
        String packageName = entry.getAttributeAsIs(PI_PACKAGE);
        String plugin = null;
        String pathString = entry.getAttributeAsIs(PI_PATH);
        Path fragment = null;
        if (packageName != null && packageName.length() > 0 && pathString != null && pathString.length() > 0) {
            fragment = new Path(packageName.replace('.', '/'));
            if (pathString.charAt(pathString.length() - 1) != '/') {
                pathString = String.valueOf(pathString) + '/';
            }
            if (pathString.charAt(0) != '/') {
                plugin = entry.getDeclaringExtension().getContributor().getName();
            } else if (pathString.length() > 4) {
                int pend = pathString.indexOf(47, 1);
                if (pend == -1 || pend >= pathString.length() - 1) {
                    return;
                }
                plugin = pathString.substring(1, pend);
                pathString = pathString.substring(pend + 1);
            } else {
                return;
            }
        }
        if (pathString.length() < 2) {
            return;
        }
        Map[] mapEntry = (Map[])map.get(fragment);
        if (mapEntry == null) {
            mapEntry = new HashMap[2];
            map.put(fragment, mapEntry);
        }
        if (container) {
            HashMap<Pattern, List[]> patternMap;
            if (mapEntry[0] == null) {
                mapEntry[0] = new HashMap(2);
            }
            if ((patternMap = (HashMap<Pattern, List[]>)mapEntry[0].get(id)) == null) {
                patternMap = new HashMap<Pattern, List[]>();
                mapEntry[0].put(id, patternMap);
            }
            if ((idEntry = (List[])patternMap.get(pattern)) == null) {
                idEntry = new List[]{new ArrayList(1), new ArrayList(1)};
                patternMap.put(pattern, idEntry);
            }
        } else {
            if (mapEntry[1] == null) {
                mapEntry[1] = new HashMap(2);
            }
            if ((idEntry = (List[])mapEntry[1].get(id)) == null) {
                idEntry = new List[]{new ArrayList(1), new ArrayList(1)};
                mapEntry[1].put(id, idEntry);
            }
        }
        idEntry[0].add(plugin);
        idEntry[1].add(pathString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getOverridePaths(IProject project, String packageName) {
        Path packagePath = new Path(String.valueOf(packageName.replace('.', '/')) + '/');
        ArrayList<String> overridePaths = new ArrayList<String>();
        try {
            IConfigurationContributionInfo info = (IConfigurationContributionInfo)project.getSessionProperty(BeaninfoNature.CONFIG_INFO_SESSION_KEY);
            if (info == null) {
                info = ProxyLaunchSupport.createDefaultConfigurationContributionInfo((IJavaProject)JavaCore.create((IProject)project));
                BeaninfoNature.computeBeanInfoConfigInfo(info);
            }
            BeaninfoPlugin beaninfoPlugin = this;
            synchronized (beaninfoPlugin) {
                if (this.ocFragments == null) {
                    this.processBeanInfoContributionExtensionPoint();
                }
            }
            HashMap<Pattern, Boolean> testedPatterns = new HashMap<Pattern, Boolean>();
            int fragmentIndex = 0;
            while (fragmentIndex < this.ocFragments.length) {
                if (this.ocFragments[fragmentIndex].isPrefixOf((IPath)packagePath)) {
                    String leftOver = null;
                    OverrideContribution[] cntrContributions = this.ocContainerIds[fragmentIndex];
                    int ocindex = 0;
                    while (ocindex < cntrContributions.length) {
                        OverrideContribution contribution = cntrContributions[ocindex];
                        Boolean tested = (Boolean)testedPatterns.get(contribution.pattern);
                        if (tested == null) {
                            tested = Boolean.FALSE;
                            IConfigurationContributionInfo.ContainerPaths containerPaths = (IConfigurationContributionInfo.ContainerPaths)info.getContainerIds().get(contribution.id);
                            if (containerPaths != null) {
                                String[] visible = containerPaths.getVisibleContainerPaths();
                                int i = 0;
                                while (i < visible.length) {
                                    if (contribution.pattern.matcher(visible[i]).matches()) {
                                        tested = Boolean.TRUE;
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            testedPatterns.put(contribution.pattern, tested);
                        }
                        if (tested.booleanValue()) {
                            int cindex = 0;
                            while (cindex < contribution.pluginIds.length) {
                                Bundle bundle = Platform.getBundle((String)contribution.pluginIds[cindex]);
                                if (bundle != null) {
                                    if (leftOver == null) {
                                        leftOver = this.getLeftOver(this.ocFragments[fragmentIndex], (IPath)packagePath);
                                    }
                                    overridePaths.add("platform:/plugin/" + bundle.getSymbolicName() + '/' + contribution.paths[cindex] + leftOver);
                                }
                                ++cindex;
                            }
                        }
                        ++ocindex;
                    }
                    OverrideContribution[] pluginContributions = this.ocPluginIds[fragmentIndex];
                    int ocindex2 = 0;
                    while (ocindex2 < pluginContributions.length) {
                        OverrideContribution contribution = pluginContributions[ocindex2];
                        Boolean visible = (Boolean)info.getPluginIds().get(contribution.id);
                        if (visible != null && visible.booleanValue()) {
                            int cindex = 0;
                            while (cindex < contribution.pluginIds.length) {
                                Bundle bundle = Platform.getBundle((String)contribution.pluginIds[cindex]);
                                if (bundle != null) {
                                    if (leftOver == null) {
                                        leftOver = this.getLeftOver(this.ocFragments[fragmentIndex], (IPath)packagePath);
                                    }
                                    overridePaths.add("platform:/plugin/" + bundle.getSymbolicName() + '/' + contribution.paths[cindex] + leftOver);
                                }
                                ++cindex;
                            }
                        }
                        ++ocindex2;
                    }
                }
                ++fragmentIndex;
            }
        }
        catch (CoreException e) {
            this.getLogger().log((Throwable)e, Level.INFO);
        }
        return overridePaths.isEmpty() ? NO_PATHS : overridePaths.toArray(new String[overridePaths.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyOverrides(IProject project, String packageName, String className, JavaClass javaClass, ResourceSet rset, final IOverrideRunnable runnable) {
        Path packagePath = new Path(String.valueOf(packageName.replace('.', '/')) + '/');
        try {
            IConfigurationContributionInfo info = (IConfigurationContributionInfo)project.getSessionProperty(BeaninfoNature.CONFIG_INFO_SESSION_KEY);
            if (info == null) {
                info = ProxyLaunchSupport.createDefaultConfigurationContributionInfo((IJavaProject)JavaCore.create((IProject)project));
                BeaninfoNature.computeBeanInfoConfigInfo(info);
            }
            final IBeanInfoContributor[] explicitContributors = (IBeanInfoContributor[])project.getSessionProperty(BeaninfoNature.BEANINFO_CONTRIBUTORS_SESSION_KEY);
            BeaninfoPlugin beaninfoPlugin = this;
            synchronized (beaninfoPlugin) {
                if (this.ocFragments == null) {
                    this.processBeanInfoContributionExtensionPoint();
                }
            }
            final HashSet usedPaths = new HashSet(10);
            IContributorOverrideRunnable contribRunnable = new IContributorOverrideRunnable(){

                public void run(String overridePath) {
                    if (!usedPaths.contains(overridePath)) {
                        usedPaths.add(overridePath);
                        runnable.run(overridePath);
                    }
                }

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(Resource overrideRes) {
                    if (usedPaths.contains(overrideRes.getURI())) return;
                    usedPaths.add(overrideRes.getURI());
                    try {
                        runnable.run(overrideRes);
                    }
                    catch (Throwable throwable) {
                        Object var2_3 = null;
                        overrideRes.getResourceSet().getResources().remove((Object)overrideRes);
                        throw throwable;
                    }
                    {
                        Object var2_4 = null;
                    }
                    overrideRes.getResourceSet().getResources().remove((Object)overrideRes);
                }

                public boolean pathContributed(String path) {
                    return usedPaths.contains(path);
                }

                public boolean resourceContributed(URI resourceURI) {
                    return usedPaths.contains(resourceURI);
                }
            };
            Iterator iter = info.getContainers().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry mapEntry = iter.next();
                final IClasspathContainer container = (IClasspathContainer)mapEntry.getKey();
                if (!(container instanceof IBeanInfoContributor) || !((Boolean)mapEntry.getValue()).booleanValue()) continue;
                SafeRunner.run((ISafeRunnable)new ISafeRunnable((IPath)packagePath, className, javaClass, rset, contribRunnable){
                    private final /* synthetic */ IPath val$packagePath;
                    private final /* synthetic */ String val$className;
                    private final /* synthetic */ JavaClass val$javaClass;
                    private final /* synthetic */ ResourceSet val$rset;
                    private final /* synthetic */ IContributorOverrideRunnable val$contribRunnable;
                    {
                        this.val$packagePath = iPath;
                        this.val$className = string;
                        this.val$javaClass = javaClass;
                        this.val$rset = resourceSet;
                        this.val$contribRunnable = iContributorOverrideRunnable;
                    }

                    public void handleException(Throwable exception) {
                    }

                    public void run() throws Exception {
                        ((IBeanInfoContributor)container).runOverrides(this.val$packagePath, this.val$className, this.val$javaClass, this.val$rset, this.val$contribRunnable);
                    }
                });
            }
            int i = 0;
            while (i < explicitContributors.length) {
                final int ii = i++;
                SafeRunner.run((ISafeRunnable)new ISafeRunnable((IPath)packagePath, className, javaClass, rset, contribRunnable){
                    private final /* synthetic */ IPath val$packagePath;
                    private final /* synthetic */ String val$className;
                    private final /* synthetic */ JavaClass val$javaClass;
                    private final /* synthetic */ ResourceSet val$rset;
                    private final /* synthetic */ IContributorOverrideRunnable val$contribRunnable;
                    {
                        this.val$packagePath = iPath;
                        this.val$className = string;
                        this.val$javaClass = javaClass;
                        this.val$rset = resourceSet;
                        this.val$contribRunnable = iContributorOverrideRunnable;
                    }

                    public void handleException(Throwable exception) {
                    }

                    public void run() throws Exception {
                        explicitContributors[ii].runOverrides(this.val$packagePath, this.val$className, this.val$javaClass, this.val$rset, this.val$contribRunnable);
                    }
                });
            }
        }
        catch (CoreException e) {
            this.getLogger().log((Throwable)e, Level.INFO);
        }
    }

    private String getLeftOver(IPath fragment, IPath packagePath) {
        return packagePath.removeFirstSegments(fragment.segmentCount()).toString();
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = EclipseLogger.getEclipseLogger((Plugin)this);
        }
        return this.logger;
    }

    public void addBeanInfoNature(BeaninfoNature nature) {
        if (this.openNatures == null) {
            this.openNatures = new HashMap();
        }
        this.openNatures.put(nature.getProject(), nature);
    }

    public void removeBeanInfoNature(BeaninfoNature nature) {
        if (this.openNatures != null) {
            this.openNatures.remove(nature.getProject());
        }
    }

    BeaninfoNature getNature(IProject project) {
        return (BeaninfoNature)this.openNatures.get(project);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.openNatures != null && !this.openNatures.isEmpty()) {
            Iterator natureItr = this.openNatures.values().iterator();
            while (natureItr.hasNext()) {
                BeaninfoNature nature = (BeaninfoNature)natureItr.next();
                nature.shutdown();
            }
        }
        super.stop(context);
    }

    private static class OverrideContribution {
        public String id;
        public Pattern pattern;
        public String[] pluginIds;
        public String[] paths;

        OverrideContribution() {
        }
    }

    public static interface IOverrideRunnable {
        public void run(String var1);

        public void run(Resource var1);
    }

    public static interface IContributorOverrideRunnable
    extends IOverrideRunnable {
        public boolean pathContributed(String var1);

        public boolean resourceContributed(URI var1);
    }
}

