/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.propertysheet.command;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.EventObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ve.internal.propertysheet.AbstractPropertySheetEntry;
import org.eclipse.ve.internal.propertysheet.IDescriptorPropertySheetEntry;
import org.eclipse.ve.internal.propertysheet.ISourcedPropertyDescriptor;
import org.eclipse.ve.internal.propertysheet.PropertysheetMessages;
import org.eclipse.ve.internal.propertysheet.command.ForwardUndoCompoundCommand;
import org.eclipse.ve.internal.propertysheet.command.ICommandPropertyDescriptor;
import org.eclipse.ve.internal.propertysheet.command.RestoreDefaultPropertyValueCommand;
import org.eclipse.ve.internal.propertysheet.command.SetPropertyValueCommand;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public class CommandStackPropertySheetEntry
extends AbstractPropertySheetEntry {
    protected final MessageFormat sApplyFormat = new MessageFormat(PropertysheetMessages.apply_value);
    protected final MessageFormat sResetFormat = new MessageFormat(PropertysheetMessages.reset_value);
    private CommandStackListener fStackListener = null;
    protected CommandStack fStack;

    public CommandStackPropertySheetEntry(CommandStack stack, CommandStackPropertySheetEntry parent, IPropertySourceProvider provider) {
        super(parent, provider);
        this.fStack = stack;
        if (parent == null) {
            this.fStackListener = new CommandStackListener(){

                public void commandStackChanged(EventObject e) {
                    CommandStackPropertySheetEntry.this.refreshFromRoot();
                }
            };
            this.fStack.addCommandStackListener(this.fStackListener);
        }
    }

    public void dispose() {
        if (this.fStackListener != null) {
            this.fStack.removeCommandStackListener(this.fStackListener);
        }
        super.dispose();
    }

    protected IDescriptorPropertySheetEntry createPropertySheetEntry(IPropertySourceProvider provider) {
        return new CommandStackPropertySheetEntry(this.fStack, this, provider);
    }

    protected boolean isPropertySet() {
        if (this.parent != null) {
            IPropertySource[] propSources = this.parent.getPropertySources();
            if (propSources.length == 0) {
                return true;
            }
            boolean isSet = false;
            isSet = this.fDescriptors[0] instanceof ISourcedPropertyDescriptor ? ((ISourcedPropertyDescriptor)this.fDescriptors[0]).isSet(propSources[0]) : propSources[0].isPropertySet(this.fDescriptors[0].getId());
            return isSet;
        }
        return true;
    }

    protected void primApplyValues() {
        ForwardUndoCompoundCommand fwdcmd = new ForwardUndoCompoundCommand(this.sApplyFormat.format(new Object[]{this.fDescriptors[0].getDisplayName()}));
        this.applyTo(fwdcmd);
        this.fStack.execute(fwdcmd.unwrap());
    }

    public void applyTo(ForwardUndoCompoundCommand fwdcmd) {
        CompoundCommand cmd = new CompoundCommand();
        IPropertySource[] propSources = this.parent.getPropertySources();
        String applyString = this.sApplyFormat.format(new Object[]{this.fDescriptors[0].getDisplayName()});
        int i = 0;
        while (i < propSources.length) {
            if (this.fDescriptors[i] instanceof ICommandPropertyDescriptor) {
                ICommandPropertyDescriptor d = (ICommandPropertyDescriptor)this.fDescriptors[i];
                cmd.append(d.setValue(propSources[i], this.getEditValue(i)));
            } else {
                cmd.append(this.createSetPropertyCommand(propSources[i], applyString, this.fDescriptors[i].getId(), this.getEditValue(i)));
            }
            ++i;
        }
        fwdcmd.append(cmd.unwrap());
        ((CommandStackPropertySheetEntry)this.parent).childChanged(fwdcmd);
    }

    protected Command createSetPropertyCommand(IPropertySource propertySource, String applyString, Object descriptorID, Object value) {
        SetPropertyValueCommand setCommand = new SetPropertyValueCommand(applyString);
        setCommand.setTarget(propertySource);
        setCommand.setPropertyId(descriptorID);
        setCommand.setPropertyValue(value);
        return setCommand;
    }

    public void childChanged(ForwardUndoCompoundCommand fwdcmd) {
        if (this.parent != null) {
            this.applyTo(fwdcmd);
        }
    }

    protected void primFillValues(Object newEditValue, Object[] valuesArray) {
        Arrays.fill(valuesArray, newEditValue);
    }

    protected Object[] primGetValues() {
        IPropertySource[] propSources = this.parent.getPropertySources();
        Object[] newValues = new Object[propSources.length];
        int i = 0;
        while (i < propSources.length) {
            if (this.fDescriptors[i] instanceof ISourcedPropertyDescriptor) {
                ISourcedPropertyDescriptor d = (ISourcedPropertyDescriptor)this.fDescriptors[i];
                newValues[i] = d.getValue(propSources[i]);
            } else {
                Object id = this.fDescriptors[i].getId();
                newValues[i] = propSources[i].getPropertyValue(id);
            }
            ++i;
        }
        return newValues;
    }

    protected boolean primResetPropertyValues() {
        CompoundCommand cmd = new CompoundCommand();
        IPropertySource[] propSources = this.parent.getPropertySources();
        String resetString = this.sResetFormat.format(new Object[]{this.fDescriptors[0].getDisplayName()});
        boolean changed = false;
        int i = 0;
        while (i < propSources.length) {
            Object id = this.fDescriptors[i].getId();
            boolean isSet = false;
            if (this.fDescriptors[i] instanceof ISourcedPropertyDescriptor) {
                if (((ISourcedPropertyDescriptor)this.fDescriptors[i]).isPropertyResettable(propSources[i])) {
                    isSet = ((ISourcedPropertyDescriptor)this.fDescriptors[i]).isSet(propSources[i]);
                }
            } else if (!(propSources[i] instanceof IPropertySource2) || ((IPropertySource2)propSources[i]).isPropertyResettable(id)) {
                isSet = propSources[i].isPropertySet(id);
            }
            if (isSet) {
                changed = true;
                if (this.fDescriptors[i] instanceof ICommandPropertyDescriptor) {
                    ICommandPropertyDescriptor d = (ICommandPropertyDescriptor)this.fDescriptors[i];
                    cmd.append(d.resetValue(propSources[i]));
                } else {
                    cmd.append(this.createRestorePropertyCommand(propSources[i], resetString, this.fDescriptors[i].getId()));
                }
            }
            ++i;
        }
        if (changed) {
            ForwardUndoCompoundCommand fwdcmd = new ForwardUndoCompoundCommand(resetString);
            fwdcmd.append(cmd.unwrap());
            ((CommandStackPropertySheetEntry)this.parent).childChanged(fwdcmd);
            this.fStack.execute(fwdcmd.unwrap());
        }
        return changed;
    }

    protected Command createRestorePropertyCommand(IPropertySource propertySource, String resetString, Object descriptorID) {
        RestoreDefaultPropertyValueCommand rsetCommand = new RestoreDefaultPropertyValueCommand(resetString);
        rsetCommand.setTarget(propertySource);
        rsetCommand.setPropertyId(descriptorID);
        return rsetCommand;
    }
}

