/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.propertysheet;

import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ve.internal.propertysheet.EToolsPropertySheetAction;
import org.eclipse.ve.internal.propertysheet.EToolsPropertySheetPage;
import org.eclipse.ve.internal.propertysheet.IDescriptorPropertySheetEntry;
import org.eclipse.ve.internal.propertysheet.PropertysheetMessages;

public class ShowReadOnlyAction
extends EToolsPropertySheetAction {
    public ShowReadOnlyAction(EToolsPropertySheetPage page) {
        super(page);
        this.setText(PropertysheetMessages.show_read_only_label);
        this.setChecked(false);
    }

    public void run() {
        IPropertySheetEntry root = this.getRootEntry();
        if (root instanceof IDescriptorPropertySheetEntry) {
            this.propertySheet.deactivateCellEditor();
            IDescriptorPropertySheetEntry rootEntry = (IDescriptorPropertySheetEntry)root;
            rootEntry.setShowReadOnly(this.isChecked());
            rootEntry.refreshFromRoot();
        }
    }

    public void setChecked(boolean value) {
        super.setChecked(value);
        this.valueChanged(value);
    }

    private void valueChanged(boolean on) {
        this.setToolTipText(on ? PropertysheetMessages.show_read_only_hide_tooltip : PropertysheetMessages.show_read_only_show_tooltip);
    }
}

