/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.palette;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class InitialState
extends AbstractEnumerator {
    public static final int OPEN = 0;
    public static final int CLOSED = 1;
    public static final int PINNED_OPEN = 2;
    public static final InitialState OPEN_LITERAL = new InitialState(0, "Open", "Open");
    public static final InitialState CLOSED_LITERAL = new InitialState(1, "Closed", "Closed");
    public static final InitialState PINNED_OPEN_LITERAL = new InitialState(2, "PinnedOpen", "PinnedOpen");
    private static final InitialState[] VALUES_ARRAY = new InitialState[]{OPEN_LITERAL, CLOSED_LITERAL, PINNED_OPEN_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static InitialState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InitialState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InitialState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            InitialState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static InitialState get(int value) {
        switch (value) {
            case 0: {
                return OPEN_LITERAL;
            }
            case 1: {
                return CLOSED_LITERAL;
            }
            case 2: {
                return PINNED_OPEN_LITERAL;
            }
        }
        return null;
    }

    private InitialState(int value, String name, String literal) {
        super(value, name, literal);
    }
}

