/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.emf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.core.AnnotationPolicy;
import org.eclipse.ve.internal.cde.core.CDEUtilities;
import org.eclipse.ve.internal.cde.core.ContainerPolicy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.IContainmentHandler;
import org.eclipse.ve.internal.cde.core.IModelAdapterFactory;

public abstract class AbstractEMFContainerPolicy
extends ContainerPolicy {
    public static final int ADD_REQ = 0;
    public static final int CREATE_REQ = 1;
    public static final int MOVE_REQ = 2;
    public static final int DELETE_REQ = 3;
    public static final int ORPHAN_REQ = 4;
    protected EStructuralFeature containmentSF;
    private IModelAdapterFactory modelAdapterFactory;
    private boolean retrievedModelAdapterFactory;
    static /* synthetic */ Class class$0;

    public AbstractEMFContainerPolicy(EditDomain domain) {
        this(null, domain);
    }

    public AbstractEMFContainerPolicy(EStructuralFeature feature, EditDomain domain) {
        super(domain);
        this.setContainerFeature(feature);
    }

    protected void setContainerFeature(EStructuralFeature containmentSF) {
        this.containmentSF = containmentSF;
    }

    protected EStructuralFeature getContainmentSF(Object child, Object positionBeforeChild, int requestType) {
        return this.containmentSF;
    }

    protected EStructuralFeature getContainmentSF(List children, Object positionBeforeChild, int requestType) {
        return this.containmentSF;
    }

    protected boolean isValidChild(Object child, EStructuralFeature containmentSF) {
        return containmentSF.getEType().isInstance(child);
    }

    protected CommandBuilder createCommandBuilder(boolean regCmd) {
        return new CommandBuilder(regCmd);
    }

    protected final IModelAdapterFactory getModelAdapterFactory() {
        if (!this.retrievedModelAdapterFactory) {
            this.modelAdapterFactory = CDEUtilities.getModelAdapterFactory(this.domain);
            this.retrievedModelAdapterFactory = true;
        }
        return this.modelAdapterFactory;
    }

    public int getPolicyRequestType(Object requestConstantsRequestType) {
        if ("add children".equals(requestConstantsRequestType)) {
            return 0;
        }
        if ("create child".equals(requestConstantsRequestType)) {
            return 1;
        }
        if ("orphan children".equals(requestConstantsRequestType)) {
            return 4;
        }
        if ("delete dependant".equals(requestConstantsRequestType)) {
            return 3;
        }
        if ("move children".equals(requestConstantsRequestType)) {
            return 2;
        }
        return -1;
    }

    public Object getTrueChild(Object child, int reqType, CommandBuilder preCmds, CommandBuilder postCmds) throws IContainmentHandler.StopRequestException {
        IModelAdapterFactory fact = this.getModelAdapterFactory();
        if (fact != null) {
            IContainmentHandler handler;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ve.internal.cde.core.IContainmentHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((handler = (IContainmentHandler)fact.getAdapter(child, clazz)) != null) {
                switch (reqType) {
                    case 0: {
                        child = handler.contributeToDropRequest(this.container, child, preCmds, postCmds, false, this.getEditDomain());
                        break;
                    }
                    case 1: {
                        child = handler.contributeToDropRequest(this.container, child, preCmds, postCmds, true, this.getEditDomain());
                        break;
                    }
                    case 4: {
                        child = handler.contributeToRemoveRequest(this.container, child, preCmds, postCmds, true, this.getEditDomain());
                        break;
                    }
                    case 3: {
                        child = handler.contributeToRemoveRequest(this.container, child, preCmds, postCmds, false, this.getEditDomain());
                    }
                }
            }
        }
        return child;
    }

    public void getTrueChildren(CorelatedResult corelatedResult, int reqType, CommandBuilder preCmds, CommandBuilder postCmds) throws IContainmentHandler.StopRequestException {
        ListIterator corelatedItr = null;
        boolean changedChildrenList = false;
        ListIterator<Object> childrenItr = corelatedResult.getChildren().listIterator();
        while (childrenItr.hasNext()) {
            Object newChild;
            Object child = childrenItr.next();
            if (corelatedItr != null) {
                corelatedItr.next();
            }
            if ((newChild = this.getTrueChild(child, reqType, preCmds, postCmds)) == child) continue;
            if (!changedChildrenList) {
                ArrayList newChildren = new ArrayList(corelatedResult.getChildren());
                corelatedResult.setChildren(newChildren);
                childrenItr = newChildren.listIterator(childrenItr.previousIndex());
                childrenItr.next();
                changedChildrenList = true;
            }
            if (newChild == null) {
                if (corelatedResult.getCorelatedList() != null) {
                    if (corelatedItr == null) {
                        ArrayList newCo = new ArrayList(corelatedResult.getCorelatedList());
                        corelatedResult.setCorelatedList(newCo);
                        corelatedItr = newCo.listIterator(childrenItr.previousIndex());
                        corelatedItr.next();
                    }
                    corelatedItr.remove();
                }
                childrenItr.remove();
                continue;
            }
            childrenItr.set(newChild);
        }
    }

    public final ContainerPolicy.Result getCreateCommand(List children, Object positionBeforeChild) {
        CorelatedResult result = new CorelatedResult(children);
        CommandBuilder preCmds = this.createCommandBuilder(true);
        CommandBuilder postCmds = this.createCommandBuilder(true);
        int origSize = children.size();
        try {
            this.getTrueChildren(result, 1, preCmds, postCmds);
        }
        catch (IContainmentHandler.StopRequestException stopRequestException) {
            preCmds.markDead();
        }
        if (preCmds.isDead() || postCmds.isDead()) {
            result.setCommand((Command)UnexecutableCommand.INSTANCE);
            return result;
        }
        if (!result.getChildren().isEmpty() || origSize == 0) {
            this.getCreateCommand(result.getChildren(), positionBeforeChild, preCmds);
        }
        preCmds.append(postCmds.getCommand());
        if (preCmds.isEmpty() || preCmds.isDead()) {
            result.setCommand((Command)UnexecutableCommand.INSTANCE);
        } else {
            result.setCommand(preCmds.getCommand());
        }
        return result;
    }

    protected void getCreateCommand(List children, Object positionBeforeChild, CommandBuilder cbldr) {
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            this.getCreateCommand(itr.next(), positionBeforeChild, cbldr);
        }
    }

    protected void getCreateCommand(Object child, Object positionBeforeChild, CommandBuilder cbldr) {
        EStructuralFeature containmentSF = this.getContainmentSF(child, positionBeforeChild, 1);
        if (containmentSF == null) {
            cbldr.markDead();
        } else {
            cbldr.append(this.getCreateCommand(child, positionBeforeChild, containmentSF));
        }
    }

    protected void getMultipleCreateCommand(List children, Object positionBeforeChild, CommandBuilder cbldr) {
        EStructuralFeature containmentSF = this.getContainmentSF(children, positionBeforeChild, 1);
        if (containmentSF == null) {
            cbldr.markDead();
        } else {
            Iterator itr = children.iterator();
            while (itr.hasNext()) {
                Object child = itr.next();
                if (this.isValidChild(child, containmentSF)) continue;
                cbldr.markDead();
                return;
            }
            cbldr.append(this.primCreateCommand(children, positionBeforeChild, containmentSF));
        }
    }

    protected Command getCreateCommand(Object child, Object positionBeforeChild, EStructuralFeature containmentSF) {
        if (!this.isValidChild(child, containmentSF)) {
            return UnexecutableCommand.INSTANCE;
        }
        return this.primCreateCommand(child, positionBeforeChild, containmentSF);
    }

    protected Command primCreateCommand(Object child, Object positionBeforeChild, EStructuralFeature containmentSF) {
        if (!containmentSF.isMany() && ((EObject)this.container).eIsSet(containmentSF)) {
            return UnexecutableCommand.INSTANCE;
        }
        CommandBuilder cBld = this.createCommandBuilder(true);
        cBld.applyAttributeSetting((EObject)this.container, containmentSF, child, positionBeforeChild);
        List annotations = AnnotationPolicy.getAllAnnotations(new ArrayList(), child, this.domain.getAnnotationLinkagePolicy());
        return AnnotationPolicy.getCreateRequestCommand(annotations, cBld.getCommand(), this.domain);
    }

    protected Command primCreateCommand(List children, Object positionBeforeChild, EStructuralFeature containmentSF) {
        if (!containmentSF.isMany() && ((EObject)this.container).eIsSet(containmentSF)) {
            return UnexecutableCommand.INSTANCE;
        }
        CommandBuilder cBld = this.createCommandBuilder(true);
        cBld.applyAttributeSettings((EObject)this.container, containmentSF, children, positionBeforeChild);
        List annotations = AnnotationPolicy.getAllAnnotations(new ArrayList(), children, this.domain.getAnnotationLinkagePolicy());
        return AnnotationPolicy.getCreateRequestCommand(annotations, cBld.getCommand(), this.domain);
    }

    public final ContainerPolicy.Result getAddCommand(List children, Object positionBeforeChild) {
        CorelatedResult result = new CorelatedResult(children);
        CommandBuilder preCmds = this.createCommandBuilder(true);
        CommandBuilder postCmds = this.createCommandBuilder(true);
        int origSize = children.size();
        try {
            this.getTrueChildren(result, 0, preCmds, postCmds);
        }
        catch (IContainmentHandler.StopRequestException stopRequestException) {
            preCmds.markDead();
        }
        if (preCmds.isDead() || postCmds.isDead()) {
            result.setCommand((Command)UnexecutableCommand.INSTANCE);
            return result;
        }
        if (!result.getChildren().isEmpty() || origSize == 0) {
            this.getAddCommand(result.getChildren(), positionBeforeChild, preCmds);
        }
        preCmds.append(postCmds.getCommand());
        if (preCmds.isEmpty() || preCmds.isDead()) {
            result.setCommand((Command)UnexecutableCommand.INSTANCE);
        } else {
            result.setCommand(preCmds.getCommand());
        }
        return result;
    }

    protected void getAddCommand(List children, Object positionBeforeChild, CommandBuilder cbldr) {
        EStructuralFeature containmentSF = this.getContainmentSF(children, positionBeforeChild, 0);
        if (containmentSF == null) {
            cbldr.markDead();
        }
        cbldr.append(this.getAddCommand(children, positionBeforeChild, containmentSF));
    }

    protected Command getAddCommand(List children, Object positionBeforeChild, EStructuralFeature containmentSF) {
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            Object child = itr.next();
            if (this.isValidChild(child, containmentSF)) continue;
            return UnexecutableCommand.INSTANCE;
        }
        return this.primAddCommand(children, positionBeforeChild, containmentSF);
    }

    protected Command primAddCommand(List children, Object positionBeforeChild, EStructuralFeature containmentSF) {
        if (!containmentSF.isMany() && (((EObject)this.container).eIsSet(containmentSF) || children.size() > 1)) {
            return UnexecutableCommand.INSTANCE;
        }
        CommandBuilder cbldr = this.createCommandBuilder(true);
        cbldr.applyAttributeSettings((EObject)this.container, containmentSF, children, positionBeforeChild);
        return cbldr.getCommand();
    }

    public final ContainerPolicy.Result getDeleteDependentCommand(List children) {
        CorelatedResult result = new CorelatedResult(children);
        CommandBuilder preCmds = this.createCommandBuilder(true);
        CommandBuilder postCmds = this.createCommandBuilder(true);
        int origSize = children.size();
        try {
            this.getTrueChildren(result, 3, preCmds, postCmds);
        }
        catch (IContainmentHandler.StopRequestException stopRequestException) {
            preCmds.markDead();
        }
        if (preCmds.isDead() || postCmds.isDead()) {
            result.setCommand((Command)UnexecutableCommand.INSTANCE);
            return result;
        }
        if (!result.getChildren().isEmpty() || origSize == 0) {
            this.getDeleteDependentCommand(result.getChildren(), preCmds);
        }
        preCmds.append(postCmds.getCommand());
        if (preCmds.isEmpty() || preCmds.isDead()) {
            result.setCommand((Command)UnexecutableCommand.INSTANCE);
        } else {
            result.setCommand(preCmds.getCommand());
        }
        return result;
    }

    protected void getDeleteDependentCommand(List children, CommandBuilder cbldr) {
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            this.getDeleteDependentCommand(itr.next(), cbldr);
        }
    }

    protected void getDeleteDependentCommand(Object child, CommandBuilder cbldr) {
        EStructuralFeature containmentSF = this.getContainmentSF(child, null, 3);
        if (containmentSF == null) {
            cbldr.markDead();
        } else {
            cbldr.append(this.getDeleteDependentCommand(child, containmentSF));
        }
    }

    public Command getMoveChildrenCommand(List children, Object positionBeforeChild) {
        EStructuralFeature containmentSF = this.getContainmentSF(children, positionBeforeChild, 2);
        if (containmentSF == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return this.getMoveChildrenCommand(children, positionBeforeChild, containmentSF);
    }

    protected void getOrphanTheChildrenCommand(List children, CommandBuilder cbldr) {
        EStructuralFeature containmentSF = this.getContainmentSF(children, null, 4);
        if (containmentSF == null) {
            cbldr.markDead();
        } else {
            cbldr.append(this.getOrphanChildrenCommand(children, containmentSF));
        }
    }

    protected Command getDeleteDependentCommand(Object child, EStructuralFeature containmentSF) {
        CommandBuilder cBld = this.createCommandBuilder(true);
        cBld.cancelAttributeSetting((EObject)this.container, containmentSF, child);
        if (containmentSF instanceof EReference && ((EReference)containmentSF).isContainment()) {
            List annotations = AnnotationPolicy.getAllAnnotations(new ArrayList(), child, this.domain.getAnnotationLinkagePolicy());
            return AnnotationPolicy.getDeleteDependentCommand(annotations, cBld.getCommand(), this.domain.getDiagramData());
        }
        return cBld.getCommand();
    }

    protected final ContainerPolicy.Result getOrphanTheChildrenCommand(List children) {
        CorelatedResult result = new CorelatedResult(children);
        CommandBuilder preCmds = this.createCommandBuilder(true);
        CommandBuilder postCmds = this.createCommandBuilder(true);
        int origSize = children.size();
        try {
            this.getTrueChildren(result, 4, preCmds, postCmds);
        }
        catch (IContainmentHandler.StopRequestException stopRequestException) {
            preCmds.markDead();
        }
        if (preCmds.isDead() || postCmds.isDead()) {
            result.setCommand((Command)UnexecutableCommand.INSTANCE);
            return result;
        }
        if (!result.getChildren().isEmpty() || origSize == 0) {
            this.getOrphanTheChildrenCommand(result.getChildren(), preCmds);
        }
        preCmds.append(postCmds.getCommand());
        if (preCmds.isEmpty() || preCmds.isDead()) {
            result.setCommand((Command)UnexecutableCommand.INSTANCE);
        } else {
            result.setCommand(preCmds.getCommand());
        }
        return result;
    }

    protected Command getOrphanChildrenCommand(List children, EStructuralFeature containmentSF) {
        CommandBuilder cBld = this.createCommandBuilder(true);
        cBld.cancelAttributeSettings((EObject)this.container, containmentSF, children);
        return cBld.getCommand();
    }

    protected Command getMoveChildrenCommand(List children, Object positionBeforeChild, EStructuralFeature containmentSF) {
        CommandBuilder cBld = this.createCommandBuilder(true);
        if (children.contains(positionBeforeChild)) {
            return UnexecutableCommand.INSTANCE;
        }
        cBld.cancelAttributeSettings((EObject)this.container, containmentSF, new ArrayList(children));
        cBld.applyAttributeSettings((EObject)this.container, containmentSF, children, positionBeforeChild);
        return cBld.getCommand();
    }

    public static class CorelatedResult
    extends ContainerPolicy.Result {
        protected List corelatedList;

        public CorelatedResult(List children, List corelatedList) {
            super(children);
            this.corelatedList = corelatedList;
        }

        public CorelatedResult(List children) {
            super(children);
        }

        public final List getCorelatedList() {
            return this.corelatedList;
        }

        public void setCorelatedList(List corelatedList) {
            this.corelatedList = corelatedList;
        }
    }
}

