/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.ve.internal.cde.core.AlignmentChildCommandRequest;
import org.eclipse.ve.internal.cde.core.AlignmentCommandRequest;
import org.eclipse.ve.internal.cde.core.ChildRequest;
import org.eclipse.ve.internal.cde.core.DistributeChildCommandRequest;
import org.eclipse.ve.internal.cde.core.DistributeCommandRequest;

public class PrimaryDragRoleEditPolicy
implements EditPolicy,
IAdaptable {
    protected EditPart host;
    protected EditPolicy dragRolePolicy;
    protected boolean allowAlignment;

    public Object getAdapter(Class adapter) {
        if (this.dragRolePolicy instanceof IAdaptable) {
            return ((IAdaptable)this.dragRolePolicy).getAdapter(adapter);
        }
        return null;
    }

    public PrimaryDragRoleEditPolicy(EditPolicy dragRolePolicy, boolean allowAlignment) {
        this.dragRolePolicy = dragRolePolicy;
        this.allowAlignment = allowAlignment;
    }

    public void activate() {
        this.dragRolePolicy.activate();
    }

    public void deactivate() {
        this.dragRolePolicy.deactivate();
    }

    public void eraseSourceFeedback(Request request) {
        this.dragRolePolicy.eraseSourceFeedback(request);
    }

    public void eraseTargetFeedback(Request request) {
        this.dragRolePolicy.eraseTargetFeedback(request);
    }

    public Command getCommand(Request request) {
        if (this.allowAlignment && "cde align".equals(request.getType())) {
            return this.getAlignmentCommand(request);
        }
        if (this.allowAlignment && "distribute".equals(request.getType())) {
            return this.getDistributeCommand(request);
        }
        if (this.allowAlignment && "restore preferred".equals(request.getType())) {
            return this.getRestorePreferredSizeCommand(request);
        }
        return this.dragRolePolicy.getCommand(request);
    }

    protected Command getAlignmentCommand(Request request) {
        AlignmentCommandRequest alignReq = (AlignmentCommandRequest)request;
        AlignmentChildCommandRequest req = new AlignmentChildCommandRequest(this.host, alignReq);
        return this.host.getParent().getCommand((Request)req);
    }

    protected Command getDistributeCommand(Request request) {
        DistributeCommandRequest distReq = (DistributeCommandRequest)request;
        DistributeChildCommandRequest req = new DistributeChildCommandRequest(this.host, distReq);
        return this.host.getParent().getCommand((Request)req);
    }

    protected Command getRestorePreferredSizeCommand(Request request) {
        ChildRequest req = new ChildRequest("restore preferred child", this.host);
        return this.host.getParent().getCommand((Request)req);
    }

    public EditPart getTargetEditPart(Request request) {
        return this.dragRolePolicy.getTargetEditPart(request);
    }

    public void setHost(EditPart editpart) {
        this.host = editpart;
        this.dragRolePolicy.setHost(editpart);
    }

    public void showSourceFeedback(Request request) {
        this.dragRolePolicy.showSourceFeedback(request);
    }

    public void showTargetFeedback(Request request) {
        this.dragRolePolicy.showTargetFeedback(request);
    }

    public boolean understandsRequest(Request request) {
        return this.dragRolePolicy.understandsRequest(request);
    }

    public EditPart getHost() {
        return this.host;
    }
}

