/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ve.internal.cde.core.GridController;

public class GridPropertiesDialog
extends Dialog {
    protected GridController gridController;
    protected Text fGridWidthText;
    protected Text fGridHeightText;
    protected Text fGridMarginText;
    protected Text fMessageLine;
    protected GridCanvas fCanvas;
    protected Button fOKButton;
    protected int fGridWidth;
    protected int fGridHeight;
    protected int fGridMargin;

    public GridPropertiesDialog(Shell parentShell, GridController gridController) {
        super(parentShell);
        this.gridController = gridController;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Grid properties");
        shell.setImage(shell.getDisplay().getSystemImage(4));
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button b = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.fOKButton = b;
            this.validateInput();
        }
        return b;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        dialogArea.setLayout((Layout)layout);
        Composite controlGroup = new Composite(dialogArea, 0);
        GridLayout controlGroupLayout = new GridLayout();
        controlGroupLayout.numColumns = 2;
        controlGroup.setLayout((Layout)controlGroupLayout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        controlGroup.setLayoutData((Object)data);
        Composite fieldsGroup = new Composite(controlGroup, 0);
        GridLayout fieldsGroupLayout = new GridLayout();
        fieldsGroupLayout.numColumns = 3;
        fieldsGroup.setLayout((Layout)fieldsGroupLayout);
        data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        fieldsGroup.setLayoutData((Object)data);
        Label widthLabel = new Label(fieldsGroup, 0);
        widthLabel.setText("Width");
        data = new GridData();
        data.widthHint = 40;
        widthLabel.setLayoutData((Object)data);
        final Scale widthScale = new Scale(fieldsGroup, 256);
        widthScale.setMaximum(60);
        widthScale.setIncrement(1);
        widthScale.setPageIncrement(10);
        data = new GridData();
        data.widthHint = 100;
        widthScale.setLayoutData((Object)data);
        widthScale.setSelection(this.gridController.getGridWidth());
        widthScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridPropertiesDialog.this.fGridWidthText.setText(String.valueOf(widthScale.getSelection()));
            }
        });
        this.fGridWidthText = new Text(fieldsGroup, 2052);
        this.fGridWidthText.setText(String.valueOf(this.gridController.getGridWidth()));
        this.fGridWidthText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent anEvent) {
                GridPropertiesDialog.this.validateInput();
            }
        });
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.widthHint = 40;
        this.fGridWidthText.setLayoutData((Object)data);
        Label heightLabel = new Label(fieldsGroup, 0);
        heightLabel.setText("Height");
        data = new GridData();
        data.widthHint = 40;
        heightLabel.setLayoutData((Object)data);
        final Scale heightScale = new Scale(fieldsGroup, 256);
        heightScale.setMaximum(60);
        heightScale.setIncrement(1);
        heightScale.setPageIncrement(10);
        data = new GridData();
        data.widthHint = 100;
        heightScale.setLayoutData((Object)data);
        heightScale.setSelection(this.gridController.getGridHeight());
        heightScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridPropertiesDialog.this.fGridHeightText.setText(String.valueOf(heightScale.getSelection()));
            }
        });
        this.fGridHeightText = new Text(fieldsGroup, 2052);
        this.fGridHeightText.setText(String.valueOf(this.gridController.getGridHeight()));
        this.fGridHeightText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent anEvent) {
                GridPropertiesDialog.this.validateInput();
            }
        });
        data = new GridData();
        data.horizontalAlignment = 3;
        data.widthHint = 40;
        this.fGridHeightText.setLayoutData((Object)data);
        Label marginLabel = new Label(fieldsGroup, 0);
        marginLabel.setText("Margin");
        data = new GridData();
        data.widthHint = 40;
        marginLabel.setLayoutData((Object)data);
        final Scale marginScale = new Scale(fieldsGroup, 256);
        marginScale.setMaximum(30);
        marginScale.setIncrement(1);
        marginScale.setPageIncrement(5);
        data = new GridData();
        data.widthHint = 100;
        marginScale.setLayoutData((Object)data);
        marginScale.setSelection(this.gridController.getGridMargin());
        marginScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GridPropertiesDialog.this.fGridMarginText.setText(String.valueOf(marginScale.getSelection()));
            }
        });
        this.fGridMarginText = new Text(fieldsGroup, 2052);
        this.fGridMarginText.setText(String.valueOf(this.gridController.getGridMargin()));
        this.fGridMarginText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent anEvent) {
                GridPropertiesDialog.this.validateInput();
            }
        });
        data = new GridData();
        data.horizontalAlignment = 3;
        data.widthHint = 40;
        this.fGridMarginText.setLayoutData((Object)data);
        this.fCanvas = new GridCanvas(controlGroup, 2048);
        data = new GridData();
        data.heightHint = 155;
        data.widthHint = 155;
        this.fCanvas.setLayoutData(data);
        Label sep2 = new Label(dialogArea, 258);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        sep2.setLayoutData((Object)data);
        this.fMessageLine = new Text(dialogArea, 8);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.fMessageLine.setLayoutData((Object)data);
        this.fMessageLine.setText("");
        return dialogArea;
    }

    protected void okPressed() {
        this.gridController.setGridWidth(this.fGridWidth);
        this.gridController.setGridHeight(this.fGridHeight);
        this.gridController.setGridMargin(this.fGridMargin);
        super.okPressed();
    }

    protected void validateInput() {
        this.fGridHeightText.setBackground(null);
        this.fGridWidthText.setBackground(null);
        this.fGridMarginText.setBackground(null);
        this.fMessageLine.setText("");
        try {
            this.fGridHeight = Integer.parseInt(this.fGridHeightText.getText());
            if (this.fGridHeight <= 1) {
                this.fGridHeightText.setBackground(ColorConstants.red);
                this.fMessageLine.setText("Height must be larger than one");
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.fGridHeightText.setBackground(ColorConstants.red);
            this.fMessageLine.setText("Height must be an integer");
        }
        try {
            this.fGridWidth = Integer.parseInt(this.fGridWidthText.getText());
            if (this.fGridWidth <= 1) {
                this.fGridWidthText.setBackground(ColorConstants.red);
                this.fMessageLine.setText("Width must be larger than one");
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.fGridWidthText.setBackground(ColorConstants.red);
            this.fMessageLine.setText("Width must be an integer");
        }
        try {
            this.fGridMargin = Integer.parseInt(this.fGridMarginText.getText());
            if (this.fGridMargin < 0) {
                this.fGridMarginText.setBackground(ColorConstants.red);
                this.fMessageLine.setText("Margin must be positive");
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.fGridMarginText.setBackground(ColorConstants.red);
            this.fMessageLine.setText("Margin must be an integer");
        }
        if (this.fMessageLine.getText() == null || this.fMessageLine.getText().equals("")) {
            this.fCanvas.redraw();
            this.fOKButton.setEnabled(true);
        } else {
            this.fOKButton.setEnabled(false);
        }
    }

    class GridCanvas
    extends Canvas {
        public GridCanvas(Composite aParent, int style) {
            super(aParent, style);
            this.addPaintListener(new PaintListener(this){
                final /* synthetic */ GridCanvas this$1;
                {
                    this.this$1 = gridCanvas;
                }

                public void paintControl(PaintEvent anEvent) {
                    GC gc = anEvent.gc;
                    gc.setForeground(ColorConstants.black);
                    gc.setBackground(ColorConstants.white);
                    gc.fillRectangle(this.this$1.getClientArea());
                    int maxX = this.this$1.getClientArea().x + this.this$1.getClientArea().width - GridCanvas.access$0((GridCanvas)this.this$1).fGridMargin;
                    int maxY = this.this$1.getClientArea().y + this.this$1.getClientArea().height - GridCanvas.access$0((GridCanvas)this.this$1).fGridMargin;
                    int x = GridCanvas.access$0((GridCanvas)this.this$1).fGridMargin;
                    while (x <= maxX) {
                        int y = GridCanvas.access$0((GridCanvas)this.this$1).fGridMargin;
                        while (y <= maxY) {
                            anEvent.gc.drawLine(x, y, x, y);
                            y += GridCanvas.access$0((GridCanvas)this.this$1).fGridHeight;
                        }
                        x += GridCanvas.access$0((GridCanvas)this.this$1).fGridWidth;
                    }
                }
            });
        }

        static /* synthetic */ GridPropertiesDialog access$0(GridCanvas gridCanvas) {
            return gridCanvas.GridPropertiesDialog.this;
        }
    }
}

