/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.Collections;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.ve.internal.cde.core.ContainerPolicy;

public class FlowLayoutEditPolicy
extends org.eclipse.gef.editpolicies.FlowLayoutEditPolicy {
    protected ContainerPolicy containerPolicy;
    private IFigure targetFeedback;
    private Boolean horizontal;

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new NonResizableEditPolicy();
    }

    protected void setHorizontal(Boolean horizontal) {
        this.horizontal = horizontal;
    }

    protected boolean isHorizontal() {
        return this.horizontal != null ? this.horizontal.booleanValue() : super.isHorizontal();
    }

    public FlowLayoutEditPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
    }

    public FlowLayoutEditPolicy(ContainerPolicy containerPolicy, Boolean horizontal) {
        this(containerPolicy);
        this.setHorizontal(horizontal);
    }

    public void activate() {
        super.activate();
        this.containerPolicy.setContainer(this.getHost().getModel());
    }

    public void deactivate() {
        super.deactivate();
        this.containerPolicy.setContainer(null);
    }

    protected Command createAddCommand(EditPart childEP, EditPart beforeEP) {
        return this.containerPolicy.getAddCommand(childEP.getModel(), beforeEP != null ? beforeEP.getModel() : null).getCommand();
    }

    protected Command getDeleteDependantCommand(Request aRequest) {
        Command cmd = this.containerPolicy.getCommand(aRequest);
        return cmd != null ? cmd : UnexecutableCommand.INSTANCE;
    }

    protected Command createMoveChildCommand(EditPart childEP, EditPart beforeEP) {
        return this.containerPolicy.getMoveChildrenCommand(Collections.singletonList(childEP.getModel()), beforeEP != null ? beforeEP.getModel() : null);
    }

    protected Command getOrphanChildrenCommand(Request req) {
        return this.containerPolicy.getCommand(req);
    }

    protected Command getCreateCommand(CreateRequest req) {
        EditPart before = this.getInsertionReference((Request)req);
        return this.containerPolicy.getCreateCommand(req.getNewObject(), before != null ? before.getModel() : null).getCommand();
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        super.eraseLayoutTargetFeedback(request);
        if (this.targetFeedback != null) {
            this.removeFeedback(this.targetFeedback);
            this.targetFeedback = null;
        }
    }

    protected IFigure getLayoutTargetFeedback(Request request) {
        if (this.targetFeedback == null) {
            RectangleFigure rf = new RectangleFigure();
            this.targetFeedback = rf;
            rf.setFill(false);
            Rectangle rect = new Rectangle(this.getHostFigure().getBounds());
            rf.setBounds(rect.shrink(4, 4));
            this.addFeedback(this.targetFeedback);
        }
        return this.targetFeedback;
    }

    protected void showLayoutTargetFeedback(Request request) {
        super.showLayoutTargetFeedback(request);
        this.getLayoutTargetFeedback(request);
    }
}

