/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Tool;
import org.eclipse.gef.TreeEditPart;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.PaletteListener;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ve.internal.cde.core.AnnotationLinkagePolicy;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.core.DirectSelectionInput;
import org.eclipse.ve.internal.cde.core.EditPartContributorFactory;
import org.eclipse.ve.internal.cde.core.GraphicalEditPartContributor;
import org.eclipse.ve.internal.cde.core.ICDEDisposable;
import org.eclipse.ve.internal.cde.core.TreeEditPartContributor;
import org.eclipse.ve.internal.cde.rules.IRuleRegistry;
import org.eclipse.ve.internal.cdm.Diagram;
import org.eclipse.ve.internal.cdm.DiagramData;
import org.eclipse.ve.internal.propertysheet.INeedData;

public class EditDomain
extends DefaultEditDomain {
    public static final String DIAGRAM_KEY = "org.eclipse.ve.internal.cde.core.diagramkey";
    protected List viewers = new ArrayList(2);
    protected List toolListeners;
    public ToolInfo toolInfo;
    private Map imageCache;
    private PaletteListener paletteListener = new PaletteListener(){

        public void activeToolChanged(PaletteViewer palette, ToolEntry tool) {
            if (tool instanceof CreationToolEntry) {
                CreationToolEntry creationTool = (CreationToolEntry)tool;
                EditDomain.this.toolInfo = new ToolInfo(MessageFormat.format(CDEMessages.ActionContributor_Status_Creating_label_, creationTool.getLabel()), EditDomain.this.getImage(creationTool.getSmallIcon()));
            } else {
                EditDomain.this.toolInfo = null;
            }
            if (EditDomain.this.toolListeners != null) {
                Iterator iter = EditDomain.this.toolListeners.iterator();
                while (iter.hasNext()) {
                    ((ToolChangedListener)iter.next()).toolChanged();
                }
            }
        }
    };
    protected HashMap genericData;
    protected HashMap viewerData;
    protected AnnotationLinkagePolicy linkageHelper;
    protected DiagramData diagramData;
    protected HashMap annotationDescriptors;
    protected Class defaultAddAnnotationsCommand;
    private IRuleRegistry ruleRegistry;
    private IConfigurationElement[] configElements;
    private EditPartContributorFactory[] contributorFactories;
    private static EditPartContributorFactory INVALID_FACTORY = new EditPartContributorFactory(){

        public GraphicalEditPartContributor getGraphicalEditPartContributor(GraphicalEditPart graphicalEditPart) {
            return null;
        }

        public TreeEditPartContributor getTreeEditPartContributor(TreeEditPart treeEditPart) {
            return null;
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static EditDomain getEditDomain(EditPart ep) {
        return (EditDomain)ep.getRoot().getViewer().getEditDomain();
    }

    private Image getImage(ImageDescriptor imageDescriptor) {
        Image existingImage;
        if (this.imageCache == null) {
            this.imageCache = new HashMap(20);
        }
        if ((existingImage = (Image)this.imageCache.get(imageDescriptor)) == null) {
            existingImage = imageDescriptor.createImage();
            this.imageCache.put(imageDescriptor, existingImage);
        }
        return existingImage;
    }

    public void setPaletteViewer(PaletteViewer paletteViewer) {
        PaletteViewer oldPaletteViewer = this.getPaletteViewer();
        if (oldPaletteViewer == paletteViewer) {
            return;
        }
        if (oldPaletteViewer != null) {
            oldPaletteViewer.removePaletteListener(this.paletteListener);
        }
        super.setPaletteViewer(paletteViewer);
        if (paletteViewer != null) {
            paletteViewer.addPaletteListener(this.paletteListener);
        }
    }

    public void setActiveTool(Tool tool) {
        super.setActiveTool(tool);
    }

    public void addToolChangedListener(ToolChangedListener aToolChangedListener) {
        if (this.toolListeners == null) {
            this.toolListeners = new ArrayList(2);
        }
        this.toolListeners.add(aToolChangedListener);
    }

    public void removeToolChangedListener(ToolChangedListener aToolChangedListener) {
        if (this.toolListeners != null) {
            this.toolListeners.remove(aToolChangedListener);
        }
    }

    public Diagram getDiagram(EditPartViewer viewer) {
        return (Diagram)this.getViewerData(viewer, DIAGRAM_KEY);
    }

    protected void finalize() {
        this.dispose();
    }

    public Collection getViewers() {
        return Collections.unmodifiableCollection(this.viewers);
    }

    public void dispose() {
        if (this.getAnnotationLinkagePolicy() != null) {
            this.getAnnotationLinkagePolicy().dispose();
            this.linkageHelper = null;
        }
        if (this.genericData != null) {
            this.disposeCollection(this.genericData.values());
        }
        if (this.viewerData != null) {
            Iterator itr = this.viewerData.values().iterator();
            while (itr.hasNext()) {
                this.disposeCollection(((HashMap)itr.next()).values());
            }
        }
        if (this.imageCache != null) {
            Iterator images = this.imageCache.values().iterator();
            while (images.hasNext()) {
                ((Image)images.next()).dispose();
            }
        }
    }

    protected void disposeCollection(Collection c) {
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            Object next = itr.next();
            if (!(next instanceof ICDEDisposable)) continue;
            ((ICDEDisposable)next).dispose();
        }
    }

    public EditDomain(IEditorPart editorPart) {
        super(editorPart);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ve.internal.cde.commands.AddAnnotationsCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.defaultAddAnnotationsCommand = clazz;
    }

    public AnnotationLinkagePolicy getAnnotationLinkagePolicy() {
        return this.linkageHelper;
    }

    public void setAnnotationLinkagePolicy(AnnotationLinkagePolicy helper) {
        if (this.linkageHelper != null) {
            throw new IllegalStateException();
        }
        this.linkageHelper = helper;
    }

    public DiagramData getDiagramData() {
        return this.diagramData;
    }

    public void setDiagramData(DiagramData dd) {
        if (this.linkageHelper == null) {
            throw new IllegalStateException();
        }
        if (this.viewerData != null) {
            Iterator itr = this.viewerData.values().iterator();
            while (itr.hasNext()) {
                HashMap value = (HashMap)itr.next();
                value.remove(DIAGRAM_KEY);
            }
        }
        this.diagramData = dd;
        if (this.diagramData != null) {
            this.linkageHelper.initializeLinkages(this.diagramData);
        }
    }

    public IPropertyDescriptor getKeyedPropertyDescriptor(Object key) {
        return this.annotationDescriptors != null ? (IPropertyDescriptor)this.annotationDescriptors.get(key) : null;
    }

    public void registerKeyedPropertyDescriptor(String key, IPropertyDescriptor descriptor) {
        if (this.annotationDescriptors == null) {
            this.annotationDescriptors = new HashMap(5);
        }
        if (descriptor instanceof INeedData) {
            ((INeedData)descriptor).setData((Object)this);
        }
        this.annotationDescriptors.put(key, descriptor);
    }

    public void unregisterKeyedPropertyDescriptor(String key) {
        if (this.annotationDescriptors != null) {
            this.annotationDescriptors.remove(key);
        }
    }

    public void addViewer(EditPartViewer viewer) {
        super.addViewer(viewer);
        this.viewers.add(viewer);
    }

    public void removeViewer(EditPartViewer viewer) {
        Map m;
        super.removeViewer(viewer);
        this.viewers.remove(viewer);
        if (this.viewerData != null && (m = (Map)this.viewerData.remove(viewer)) != null) {
            this.disposeCollection(m.values());
        }
    }

    public Object getData(Object key) {
        if (this.genericData != null) {
            return this.genericData.get(key);
        }
        return null;
    }

    public void setData(Object key, Object data) {
        if (this.genericData == null) {
            this.genericData = new HashMap(3);
        }
        this.genericData.put(key, data);
    }

    public Object removeData(Object key) {
        if (this.genericData != null) {
            return this.genericData.remove(key);
        }
        return null;
    }

    public Object getViewerData(EditPartViewer viewer, Object key) {
        HashMap data;
        if (this.viewerData != null && (data = (HashMap)this.viewerData.get(viewer)) != null) {
            return data.get(key);
        }
        return null;
    }

    public void setViewerData(EditPartViewer viewer, Object key, Object data) {
        HashMap<Object, Object> vdata;
        if (this.viewerData == null) {
            this.viewerData = new HashMap(3);
        }
        if ((vdata = (HashMap<Object, Object>)this.viewerData.get(viewer)) == null) {
            vdata = new HashMap<Object, Object>(3);
            this.viewerData.put(viewer, vdata);
        }
        vdata.put(key, data);
    }

    public Object removeViewerData(EditPartViewer viewer, Object key) {
        HashMap vdata;
        if (this.viewerData != null && (vdata = (HashMap)this.viewerData.get(viewer)) != null) {
            return vdata.remove(key);
        }
        return null;
    }

    public void setDefaultAddAnnotationsCommandClass(Class defaultAdd) throws NoSuchMethodException, ClassCastException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ve.internal.cde.commands.AddAnnotationsCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(defaultAdd)) {
            throw new ClassCastException(defaultAdd.toString());
        }
        defaultAdd.getConstructor(new Class[0]);
        this.defaultAddAnnotationsCommand = defaultAdd;
    }

    public Class getDefaultAddAnnotationsCommandClass() {
        return this.defaultAddAnnotationsCommand;
    }

    public PaletteRoot getPaletteRoot() {
        return this.getPaletteViewer().getPaletteRoot();
    }

    public void setRuleRegistry(IRuleRegistry ruleRegistry) {
        this.ruleRegistry = ruleRegistry;
    }

    public IRuleRegistry getRuleRegistry() {
        return this.ruleRegistry;
    }

    public void selectModel(Object model) {
        if (this.getEditorPart() instanceof DirectSelectionInput) {
            ((DirectSelectionInput)this.getEditorPart()).modelSelected(model);
        }
    }

    public List getContributors(IAdaptable anAdaptable) {
        Class<?> clazz;
        if (this.configElements == null) {
            IExtensionPoint extp = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ve.cde.editpartcontributor");
            ArrayList<IConfigurationElement> configElementsList = new ArrayList<IConfigurationElement>();
            if (extp != null) {
                IExtension[] extensions = extp.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] configurationElements = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < configurationElements.length) {
                        if ("contributor".equals(configurationElements[j].getName())) {
                            configElementsList.add(configurationElements[j]);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            this.configElements = configElementsList.toArray(new IConfigurationElement[configElementsList.size()]);
            this.contributorFactories = new EditPartContributorFactory[this.configElements.length];
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.IActionFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IActionFilter actionFilter = (IActionFilter)anAdaptable.getAdapter((Class)clazz);
        ArrayList<EditPartContributorFactory> result = new ArrayList<EditPartContributorFactory>(1);
        int i = 0;
        while (i < this.configElements.length) {
            block16: {
                IConfigurationElement configElement = this.configElements[i];
                IConfigurationElement[] filters = configElement.getChildren("filter");
                int j = 0;
                while (j < filters.length) {
                    String value;
                    String name = filters[j].getAttribute("name");
                    if (actionFilter.testAttribute((Object)anAdaptable, name, value = filters[j].getAttribute("value"))) {
                        ++j;
                        continue;
                    }
                    break block16;
                }
                EditPartContributorFactory editPartContributorFactory = this.contributorFactories[i];
                if (editPartContributorFactory == null) {
                    try {
                        editPartContributorFactory = this.contributorFactories[i] = (EditPartContributorFactory)configElement.createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        CDEPlugin.getPlugin().getLogger().log((Throwable)e, Level.WARNING);
                        this.contributorFactories[i] = INVALID_FACTORY;
                    }
                }
                if (editPartContributorFactory != null) {
                    result.add(editPartContributorFactory);
                }
            }
            ++i;
        }
        return result;
    }

    public static interface ToolChangedListener {
        public void toolChanged();
    }

    public static class ToolInfo {
        public Image image;
        public String msg;

        public ToolInfo(String aMsg, Image anImage) {
            this.msg = aMsg;
            this.image = anImage;
        }
    }
}

