/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.SharedCursors;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.ve.internal.cde.core.AnnotationLinkagePolicy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.IModelAdapterFactory;
import org.eclipse.ve.internal.cde.core.ModelChangeController;
import org.eclipse.ve.internal.cdm.Annotation;

public class CDEUtilities {
    public static boolean isUnset(Notification msg) {
        if (msg.getFeature() instanceof EStructuralFeature) {
            EStructuralFeature sf = (EStructuralFeature)msg.getFeature();
            return !sf.isUnsettable() && msg.isReset();
        }
        return false;
    }

    public static Map.Entry putEMapEntry(EMap map, Map.Entry entry) {
        int oldEntryIndex = map.indexOfKey(entry.getKey());
        if (oldEntryIndex != -1) {
            return (Map.Entry)map.set(oldEntryIndex, (Object)entry);
        }
        map.add((Object)entry);
        return null;
    }

    public static IModelAdapterFactory getModelAdapterFactory(EditDomain domain) {
        return (IModelAdapterFactory)domain.getData("com.ibm.etools.ide.modelfactorykey");
    }

    public static IModelAdapterFactory getModelAdapterFactory(EditPart editpart) {
        return CDEUtilities.getModelAdapterFactory(EditDomain.getEditDomain(editpart));
    }

    public static void setModelAdapterFactory(EditDomain domain, IModelAdapterFactory factory) {
        domain.setData("com.ibm.etools.ide.modelfactorykey", factory);
    }

    public static String lowCaseFirstCharacter(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (!(!Character.isUpperCase(name.charAt(0)) || name.length() >= 3 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(2)))) {
            char[] a = name.toCharArray();
            a[0] = Character.toLowerCase(a[0]);
            return new String(a);
        }
        return name;
    }

    public static void displayExec(EditPart ep, Object once, Runnable runnable) {
        if (ep.isActive()) {
            ((ModelChangeController)EditDomain.getEditDomain(ep).getData("org.eclipse.ve.internal.cde.core.ModelChangeController")).execAtEndOfTransaction(runnable, ModelChangeController.createHashKey(ep, once));
        }
    }

    public static void displayExec(EditPart ep, Runnable runnable) {
        if (ep.isActive()) {
            ((ModelChangeController)EditDomain.getEditDomain(ep).getData("org.eclipse.ve.internal.cde.core.ModelChangeController")).execAtEndOfTransaction(runnable);
        }
    }

    public static Cursor calculateCursor(EditDomain domain) {
        ModelChangeController mc = (ModelChangeController)domain.getData("org.eclipse.ve.internal.cde.core.ModelChangeController");
        if (mc != null) {
            int holdState = mc.getHoldState();
            switch (holdState) {
                case 0: {
                    return null;
                }
                case 1: {
                    return SharedCursors.WAIT;
                }
            }
            return SharedCursors.NO;
        }
        return null;
    }

    public static int getHoldState(EditDomain domain) {
        ModelChangeController mc = (ModelChangeController)domain.getData("org.eclipse.ve.internal.cde.core.ModelChangeController");
        if (mc != null) {
            return mc.getHoldState();
        }
        return 0;
    }

    public static EditPartNamePath getEditPartNamePath(EditPart ep, EditDomain domain) {
        if (!ep.isActive()) {
            throw new IllegalArgumentException("editpart must be active.");
        }
        AnnotationLinkagePolicy policy = domain.getAnnotationLinkagePolicy();
        ArrayList<String> path = new ArrayList<String>();
        EditPart top = ep.getRoot().getContents();
        while (ep != null && ep != top) {
            String name;
            Annotation a = policy.getAnnotation(ep.getModel());
            if (a != null && (name = (String)a.getKeyedValues().get((Object)"org.eclipse.ve.internal.cde.core.nameincomposition")) != null && name.length() > 0) {
                path.add(name);
            } else {
                EditPart parent = ep.getParent();
                if (parent == null) {
                    return null;
                }
                path.add(String.valueOf('{') + String.valueOf(parent.getChildren().indexOf(ep)) + '}');
            }
            ep = ep.getParent();
        }
        if (ep == null || path.isEmpty()) {
            return null;
        }
        EditPartNamePath result = new EditPartNamePath();
        result.namePath = new String[path.size()];
        int pi = 0;
        int i = path.size() - 1;
        while (i >= 0) {
            result.namePath[pi++] = (String)path.get(i);
            --i;
        }
        return result;
    }

    public static EditPart findEditpartFromNamePath(EditPartNamePath path, EditPartViewer viewer, EditDomain domain) {
        EditPart ep = viewer.getContents();
        if (path == null) {
            return ep;
        }
        AnnotationLinkagePolicy policy = domain.getAnnotationLinkagePolicy();
        String[] namePath = path.namePath;
        int i = 0;
        while (i < namePath.length) {
            block8: {
                block9: {
                    List children = ep.getChildren();
                    String name = namePath[i];
                    if (name.charAt(0) != '{' || name.charAt(name.length() - 1) != '}') {
                        int j = 0;
                        while (j < children.size()) {
                            String childName;
                            EditPart child = (EditPart)children.get(j);
                            Annotation a = policy.getAnnotation(child.getModel());
                            if (a != null && name.equals(childName = (String)a.getKeyedValues().get((Object)"org.eclipse.ve.internal.cde.core.nameincomposition"))) {
                                ep = child;
                                break block8;
                            }
                            ++j;
                        }
                    } else {
                        String indexString = name.substring(1, name.length() - 1);
                        try {
                            int index = Integer.parseInt(indexString);
                            if (index >= children.size()) break block9;
                            ep = (EditPart)children.get(index);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
                return null;
            }
            ++i;
        }
        return ep;
    }

    public static EAnnotation findDecorator(EModelElement model, Class annotationType) {
        EList as = model.getEAnnotations();
        int s = as.size();
        int i = 0;
        while (i < s) {
            Object next = as.get(i);
            if (annotationType.isInstance(next)) {
                return (EAnnotation)next;
            }
            ++i;
        }
        return null;
    }

    public static String stripNewLineTabs(String in, char replaceNewline, char replaceTab) {
        int tab;
        boolean doNL = replaceNewline != '\u0000';
        boolean doTab = replaceTab != '\u0000';
        int nl = doNL ? in.indexOf(10) : -1;
        int n = tab = doTab ? in.indexOf(9) : -1;
        if (nl != -1 || tab != -1) {
            char[] inchar = in.toCharArray();
            int length = inchar.length;
            int ndx = nl != -1 ? (tab != -1 ? Math.min(nl, tab) : nl) : tab;
            while (ndx < inchar.length) {
                if (doNL && inchar[ndx] == '\n') {
                    if (ndx > 0 && inchar[ndx - 1] == '\r') {
                        inchar[ndx - 1] = replaceNewline;
                        System.arraycopy(inchar, ndx + 1, inchar, ndx, inchar.length - ndx - 1);
                        --length;
                    } else {
                        inchar[ndx] = replaceNewline;
                    }
                }
                if (doTab && inchar[ndx] == '\t') {
                    inchar[ndx] = replaceTab;
                }
                ++ndx;
            }
            return new String(inchar, 0, length);
        }
        return in;
    }

    public static class ESettingsEList
    extends EContentsEList {
        protected boolean shared;

        public ESettingsEList(EObject eObject, boolean shared) {
            this(eObject, (EStructuralFeature[])((BasicEList)eObject.eClass().getEAllStructuralFeatures()).data(), shared);
        }

        public ESettingsEList(EObject eObject, EStructuralFeature[] eStructuralFeatures, boolean shared) {
            super(eObject, eStructuralFeatures);
            this.shared = shared;
        }

        protected boolean isIncluded(EStructuralFeature eStructuralFeature) {
            return !this.shared ? eStructuralFeature instanceof EAttribute || ((EReference)eStructuralFeature).isContainment() : true;
        }

        protected ListIterator newListIterator() {
            return this.resolve() ? new ResolvingFeatureIteratorImpl(this.eObject, this.eStructuralFeatures, this.shared) : new FeatureIteratorImpl(this.eObject, this.eStructuralFeatures, this.shared);
        }

        public List basicList() {
            return new ESettingsEList(this, this.eObject, this.eStructuralFeatures, this.shared){
                final /* synthetic */ ESettingsEList this$1;
                {
                    this.this$1 = eSettingsEList;
                }

                protected boolean resolve() {
                    return false;
                }
            };
        }

        public ListIterator basicListIterator() {
            if (this.eStructuralFeatures == null) {
                return FeatureIteratorImpl.EMPTY_ITERATOR;
            }
            return new FeatureIteratorImpl(this.eObject, this.eStructuralFeatures, this.shared);
        }

        public Iterator basicIterator() {
            return this.basicListIterator();
        }

        public ListIterator basicListIterator(int index) {
            if (this.eStructuralFeatures == null) {
                if (index < 0 || index > 1) {
                    throw new IndexOutOfBoundsException("index=" + index + ", size=0");
                }
                return FeatureIteratorImpl.EMPTY_ITERATOR;
            }
            ListIterator result = this.basicListIterator();
            int i = 0;
            while (i < index) {
                result.next();
                ++i;
            }
            return result;
        }

        public class FeatureIteratorImpl
        extends EContentsEList.FeatureIteratorImpl {
            protected boolean shared;

            public FeatureIteratorImpl(EObject eObject, EStructuralFeature[] eStructuralFeatures, boolean shared) {
                super(eObject, eStructuralFeatures);
                this.shared = shared;
            }

            protected boolean isIncluded(EStructuralFeature eStructuralFeature) {
                return ESettingsEList.this.isIncluded(eStructuralFeature);
            }
        }

        public class ResolvingFeatureIteratorImpl
        extends FeatureIteratorImpl {
            public ResolvingFeatureIteratorImpl(EObject eObject, EStructuralFeature[] eStructuralFeatures, boolean shared) {
                super(eObject, eStructuralFeatures, shared);
            }

            protected boolean resolve() {
                return true;
            }
        }
    }

    public static class EditPartNamePath {
        public String[] namePath;
    }
}

