/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.TreeEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.properties.PropertySourceAdapter;
import org.eclipse.ve.internal.propertysheet.INeedData;
import org.eclipse.ve.internal.propertysheet.ISourced;

public abstract class CDETreeDirectEditManager {
    private EditPartViewer viewer;
    private Tree parentTree;
    private TreeEditor editor;
    private CellEditor cellEditor;
    private Object oldValue;
    private TreeEditPart currentEditPart = null;
    private IPropertyDescriptor currentProperty = null;
    private EditPartListener currentEditPartListener = null;
    private ICellEditorListener cellEditorListener = new ICellEditorListener(){

        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
        }

        public void cancelEditor() {
            CDETreeDirectEditManager.this.hideDirectEdit();
        }

        public void applyEditorValue() {
            CDETreeDirectEditManager.this.saveChange();
        }
    };
    static /* synthetic */ Class class$0;

    public CDETreeDirectEditManager(EditPartViewer v) {
        this.viewer = v;
        if (this.viewer.getControl() instanceof Tree) {
            this.parentTree = (Tree)this.viewer.getControl();
            this.parentTree.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (CDETreeDirectEditManager.this.cellEditor != null) {
                        CDETreeDirectEditManager.this.hideDirectEdit();
                    }
                }
            });
            this.currentEditPartListener = new EditPartListener.Stub(){

                public void partDeactivated(EditPart editPart) {
                    CDETreeDirectEditManager.this.hideDirectEdit();
                }
            };
        }
    }

    private CellEditor getCellEditor() {
        if (this.cellEditor == null) {
            this.cellEditor = this.currentProperty.createPropertyEditor((Composite)this.parentTree);
            this.cellEditor.getControl().setBackground(this.parentTree.getDisplay().getSystemColor(19));
            this.cellEditor.addListener(this.cellEditorListener);
            if (this.cellEditor instanceof INeedData) {
                ((INeedData)this.cellEditor).setData((Object)EditDomain.getEditDomain((EditPart)this.currentEditPart));
            }
            if (this.cellEditor instanceof ISourced) {
                ISourced iSourced = (ISourced)this.cellEditor;
                Object[] objectArray = new Object[]{this.currentEditPart.getModel()};
                IPropertySource[] iPropertySourceArray = new IPropertySource[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                iPropertySourceArray[0] = (IPropertySource)this.currentEditPart.getAdapter((Class)clazz);
                iSourced.setSources(objectArray, iPropertySourceArray, new IPropertyDescriptor[]{this.currentProperty});
            }
        }
        return this.cellEditor;
    }

    private TreeEditor getEditor() {
        if (this.editor == null) {
            this.editor = new TreeEditor(this.parentTree);
            this.editor.horizontalAlignment = 16384;
            this.editor.grabHorizontal = true;
            this.editor.minimumWidth = 50;
        }
        return this.editor;
    }

    public void performDirectEdit(TreeEditPart treeEP, IPropertyDescriptor property) {
        if (this.currentEditPart != null || this.currentProperty != null) {
            return;
        }
        this.currentEditPart = treeEP;
        this.currentProperty = property;
        this.currentEditPart.addEditPartListener(this.currentEditPartListener);
        this.showDirectEdit();
    }

    private void showDirectEdit() {
        this.oldValue = this.getDirectEditValue();
        CellEditor ce = this.getCellEditor();
        ce.setValue(this.oldValue);
        this.getEditor().setEditor(ce.getControl(), (TreeItem)this.currentEditPart.getWidget());
        ce.setFocus();
    }

    private void saveChange() {
        Object newValue = this.getCellEditor().getValue();
        if (!newValue.equals(this.oldValue) && this.currentEditPart != null && this.currentProperty != null) {
            EditDomain domain = EditDomain.getEditDomain((EditPart)this.currentEditPart);
            domain.getCommandStack().execute(this.getDirectEditCommand(newValue, (EditPart)this.currentEditPart, this.currentProperty));
        }
        this.oldValue = null;
        this.hideDirectEdit();
    }

    protected abstract Command getDirectEditCommand(Object var1, EditPart var2, IPropertyDescriptor var3);

    private void hideDirectEdit() {
        this.getEditor().setEditor(null);
        this.getCellEditor().deactivate();
        this.cellEditor.removeListener(this.cellEditorListener);
        this.getCellEditor().dispose();
        this.cellEditor = null;
        if (this.currentEditPartListener != null && this.currentEditPart != null) {
            this.currentEditPart.removeEditPartListener(this.currentEditPartListener);
        }
        this.currentEditPart = null;
        this.currentProperty = null;
        this.oldValue = null;
    }

    private Object getDirectEditValue() {
        if (this.currentEditPart != null && this.currentProperty != null) {
            return this.getPropertyValue((EditPart)this.currentEditPart, this.currentProperty);
        }
        return null;
    }

    protected Object getPropertyValue(EditPart ep, IPropertyDescriptor property) {
        IPropertySource ps;
        Object value = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.properties.IPropertySource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (PropertySourceAdapter.isPropertySet(ps = (IPropertySource)ep.getAdapter((Class)clazz), property) && (value = PropertySourceAdapter.getPropertyValue(ps, property)) != null && value instanceof IPropertySource) {
            value = ((IPropertySource)value).getEditableValue();
        }
        return value;
    }
}

