/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.TreeEditPart;
import org.eclipse.gef.ui.actions.ToggleGridAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.CustomizeLayoutPage;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.GridController;

public class AlignmentXYGridPropertiesPage
extends CustomizeLayoutPage {
    protected EditPart fEditPart;
    protected GridController gridController;
    protected Text fGridWidthText;
    protected Text fGridHeightText;
    protected Text fGridMarginText;
    protected Text fMessageLine;
    protected Button fWidthHeightSyncCheckBox;
    protected Scale fGridWidthScale;
    protected Scale fGridHeightScale;
    protected Scale fGridMarginScale;
    protected Button fSnapToGridCheckBox;
    protected int fGridWidth;
    protected int fGridHeight;
    protected int fGridMargin;
    protected boolean fWidthHeightSync = true;
    protected boolean fSnapToGrid = false;
    private boolean initializing = false;
    private PropertyChangeListener fPropertyChangeListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public Control getControl(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        dialogArea.setLayout((Layout)layout);
        Composite fieldsGroup = new Composite(dialogArea, 0);
        GridLayout fieldsGroupLayout = new GridLayout();
        fieldsGroupLayout.numColumns = 3;
        fieldsGroup.setLayout((Layout)fieldsGroupLayout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        fieldsGroup.setLayoutData((Object)data);
        this.fSnapToGridCheckBox = new Button(fieldsGroup, 32);
        this.fSnapToGridCheckBox.setText(CDEMessages.AlignmentXYGridPropertiesPage_Snap_To_Grid);
        data = new GridData();
        data.horizontalSpan = 3;
        this.fSnapToGridCheckBox.setLayoutData((Object)data);
        this.fSnapToGridCheckBox.setSelection(this.fSnapToGrid);
        this.fSnapToGridCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!AlignmentXYGridPropertiesPage.this.initializing && AlignmentXYGridPropertiesPage.this.fSnapToGridCheckBox.getSelection() != AlignmentXYGridPropertiesPage.this.fSnapToGrid) {
                    AlignmentXYGridPropertiesPage.this.fSnapToGrid = AlignmentXYGridPropertiesPage.this.fSnapToGridCheckBox.getSelection();
                    ToggleGridAction snapToGridAction = new ToggleGridAction((GraphicalViewer)AlignmentXYGridPropertiesPage.this.fEditPart.getRoot().getViewer());
                    snapToGridAction.run();
                }
            }
        });
        this.fSnapToGridCheckBox.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AlignmentXYGridPropertiesPage.this.fPropertyChangeListener != null) {
                    AlignmentXYGridPropertiesPage.this.fEditPart.getRoot().getViewer().removePropertyChangeListener(AlignmentXYGridPropertiesPage.this.fPropertyChangeListener);
                }
            }
        });
        this.fWidthHeightSyncCheckBox = new Button(fieldsGroup, 32);
        this.fWidthHeightSyncCheckBox.setText(CDEMessages.AlignmentXYGridPropertiesPage_Keep_Width_Height_Same);
        data = new GridData();
        data.horizontalSpan = 3;
        this.fWidthHeightSyncCheckBox.setLayoutData((Object)data);
        this.fWidthHeightSyncCheckBox.setSelection(this.fWidthHeightSync);
        this.fWidthHeightSyncCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlignmentXYGridPropertiesPage.this.fWidthHeightSync = AlignmentXYGridPropertiesPage.this.fWidthHeightSyncCheckBox.getSelection();
                if (AlignmentXYGridPropertiesPage.this.fWidthHeightSync) {
                    AlignmentXYGridPropertiesPage.this.fGridHeightScale.setSelection(AlignmentXYGridPropertiesPage.this.fGridWidthScale.getSelection());
                    AlignmentXYGridPropertiesPage.this.fGridHeightText.setText(AlignmentXYGridPropertiesPage.this.fGridWidthText.getText());
                }
            }
        });
        Label widthLabel = new Label(fieldsGroup, 0);
        widthLabel.setText(CDEMessages.AlignmentXYGridPropertiesPage_width);
        this.fGridWidthScale = new Scale(fieldsGroup, 256);
        this.fGridWidthScale.setMaximum(60);
        this.fGridWidthScale.setMinimum(2);
        this.fGridWidthScale.setIncrement(1);
        this.fGridWidthScale.setPageIncrement(10);
        data = new GridData();
        data.widthHint = 120;
        this.fGridWidthScale.setLayoutData((Object)data);
        this.fGridWidthScale.setSelection(this.gridController.getGridWidth());
        this.fGridWidthScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlignmentXYGridPropertiesPage.this.fGridWidthText.setText(String.valueOf(AlignmentXYGridPropertiesPage.this.fGridWidthScale.getSelection()));
            }
        });
        this.fGridWidthText = new Text(fieldsGroup, 2052);
        this.fGridWidthText.setText(String.valueOf(this.gridController.getGridWidth()));
        this.fGridWidthText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent anEvent) {
                if (!AlignmentXYGridPropertiesPage.this.initializing && AlignmentXYGridPropertiesPage.this.isInputValid() && AlignmentXYGridPropertiesPage.this.fGridWidth != AlignmentXYGridPropertiesPage.this.gridController.getGridWidth()) {
                    AlignmentXYGridPropertiesPage.this.gridController.setGridWidth(AlignmentXYGridPropertiesPage.this.fGridWidth);
                    if (AlignmentXYGridPropertiesPage.this.fWidthHeightSync && AlignmentXYGridPropertiesPage.this.fGridHeight != AlignmentXYGridPropertiesPage.this.fGridWidth) {
                        AlignmentXYGridPropertiesPage.this.fGridHeightScale.setSelection(AlignmentXYGridPropertiesPage.this.fGridWidthScale.getSelection());
                        AlignmentXYGridPropertiesPage.this.fGridHeightText.setText(AlignmentXYGridPropertiesPage.this.fGridWidthText.getText());
                    }
                }
            }
        });
        data = new GridData();
        data.widthHint = 40;
        data.horizontalAlignment = 3;
        this.fGridWidthText.setLayoutData((Object)data);
        Label heightLabel = new Label(fieldsGroup, 0);
        heightLabel.setText(CDEMessages.AlignmentXYGridPropertiesPage_height);
        this.fGridHeightScale = new Scale(fieldsGroup, 256);
        this.fGridHeightScale.setMaximum(60);
        this.fGridHeightScale.setMinimum(2);
        this.fGridHeightScale.setIncrement(1);
        this.fGridHeightScale.setPageIncrement(10);
        data = new GridData();
        data.widthHint = 120;
        this.fGridHeightScale.setLayoutData((Object)data);
        this.fGridHeightScale.setSelection(this.gridController.getGridHeight());
        this.fGridHeightScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlignmentXYGridPropertiesPage.this.fGridHeightText.setText(String.valueOf(AlignmentXYGridPropertiesPage.this.fGridHeightScale.getSelection()));
            }
        });
        this.fGridHeightText = new Text(fieldsGroup, 2052);
        this.fGridHeightText.setText(String.valueOf(this.gridController.getGridHeight()));
        this.fGridHeightText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent anEvent) {
                if (!AlignmentXYGridPropertiesPage.this.initializing && AlignmentXYGridPropertiesPage.this.isInputValid() && AlignmentXYGridPropertiesPage.this.fGridHeight != AlignmentXYGridPropertiesPage.this.gridController.getGridHeight()) {
                    AlignmentXYGridPropertiesPage.this.gridController.setGridHeight(AlignmentXYGridPropertiesPage.this.fGridHeight);
                    if (AlignmentXYGridPropertiesPage.this.fWidthHeightSync && AlignmentXYGridPropertiesPage.this.fGridHeight != AlignmentXYGridPropertiesPage.this.fGridWidth) {
                        AlignmentXYGridPropertiesPage.this.fGridWidthScale.setSelection(AlignmentXYGridPropertiesPage.this.fGridHeightScale.getSelection());
                        AlignmentXYGridPropertiesPage.this.fGridWidthText.setText(AlignmentXYGridPropertiesPage.this.fGridHeightText.getText());
                    }
                }
            }
        });
        data = new GridData();
        data.widthHint = 40;
        data.horizontalAlignment = 3;
        this.fGridHeightText.setLayoutData((Object)data);
        Label marginLabel = new Label(fieldsGroup, 0);
        marginLabel.setText(CDEMessages.AlignmentXYGridPropertiesPage_margin);
        this.fGridMarginScale = new Scale(fieldsGroup, 256);
        this.fGridMarginScale.setMaximum(30);
        this.fGridMarginScale.setIncrement(1);
        this.fGridMarginScale.setPageIncrement(5);
        data = new GridData();
        data.widthHint = 120;
        this.fGridMarginScale.setLayoutData((Object)data);
        this.fGridMarginScale.setSelection(this.gridController.getGridMargin());
        this.fGridMarginScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlignmentXYGridPropertiesPage.this.fGridMarginText.setText(String.valueOf(AlignmentXYGridPropertiesPage.this.fGridMarginScale.getSelection()));
            }
        });
        this.fGridMarginText = new Text(fieldsGroup, 2052);
        this.fGridMarginText.setText(String.valueOf(this.gridController.getGridMargin()));
        this.fGridMarginText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent anEvent) {
                if (!AlignmentXYGridPropertiesPage.this.initializing && AlignmentXYGridPropertiesPage.this.isInputValid() && AlignmentXYGridPropertiesPage.this.fGridMargin != AlignmentXYGridPropertiesPage.this.gridController.getGridMargin()) {
                    AlignmentXYGridPropertiesPage.this.gridController.setGridMargin(AlignmentXYGridPropertiesPage.this.fGridMargin);
                }
            }
        });
        data = new GridData();
        data.widthHint = 40;
        data.horizontalAlignment = 3;
        this.fGridMarginText.setLayoutData((Object)data);
        this.fMessageLine = new Text(dialogArea, 8);
        data = new GridData();
        data.horizontalAlignment = 4;
        this.fMessageLine.setLayoutData((Object)data);
        this.fMessageLine.setText("");
        return dialogArea;
    }

    protected String getLabelForSelection(ISelection newSelection) {
        if (newSelection instanceof IStructuredSelection && ((IStructuredSelection)newSelection).size() == 1) {
            return CDEMessages.AlignmentXYGridPropertiesPage_title;
        }
        return null;
    }

    protected void handleEditorPartChanged(IEditorPart oldEditorPart) {
    }

    protected void handleSelectionProviderInitialization(ISelectionProvider selectionProvider) {
    }

    protected boolean handleSelectionChanged(ISelection oldSelection) {
        ISelection newSelection = this.getSelection();
        if (newSelection != null && newSelection instanceof IStructuredSelection && !((IStructuredSelection)newSelection).isEmpty()) {
            EditPart firstParent;
            List editparts = ((IStructuredSelection)newSelection).toList();
            boolean enableAll = true;
            if (editparts.size() == 1 && editparts.get(0) instanceof EditPart && this.isValidTarget(firstParent = (EditPart)editparts.get(0))) {
                this.fEditPart = firstParent;
                if (this.fPropertyChangeListener != null) {
                    this.fEditPart.getRoot().getViewer().removePropertyChangeListener(this.fPropertyChangeListener);
                }
                this.gridController = this.getGridController();
                if (this.gridController != null) {
                    this.initializeValues();
                    return true;
                }
            }
            if (editparts.get(0) instanceof EditPart && ((EditPart)editparts.get(0)).getParent() != null && this.isValidTarget(firstParent = ((EditPart)editparts.get(0)).getParent())) {
                EditPart ep = (EditPart)editparts.get(0);
                int i = 1;
                while (i < editparts.size()) {
                    if (editparts.get(i) instanceof EditPart) {
                        ep = (EditPart)editparts.get(i);
                        if (ep.getParent() == null || ep.getParent() != firstParent) {
                            enableAll = false;
                            break;
                        }
                    } else {
                        enableAll = false;
                        break;
                    }
                    ++i;
                }
                if (enableAll) {
                    this.fEditPart = firstParent;
                    if (this.fPropertyChangeListener != null) {
                        this.fEditPart.getRoot().getViewer().removePropertyChangeListener(this.fPropertyChangeListener);
                    }
                    this.gridController = this.getGridController();
                    if (this.gridController != null) {
                        this.initializeValues();
                        return true;
                    }
                }
            }
        }
        this.fEditPart = null;
        this.gridController = null;
        this.fPropertyChangeListener = null;
        return false;
    }

    private GridController getGridController() {
        if (this.fEditPart instanceof TreeEditPart) {
            EditPart ep;
            EditPartViewer viewer;
            EditDomain ed = EditDomain.getEditDomain(this.fEditPart);
            IEditorPart iEditorPart = ed.getEditorPart();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gef.EditPartViewer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((viewer = (EditPartViewer)iEditorPart.getAdapter((Class)clazz)) != null && (ep = (EditPart)viewer.getEditPartRegistry().get(this.fEditPart.getModel())) != null) {
                this.fEditPart = ep;
            }
        }
        return GridController.getGridController(this.fEditPart);
    }

    protected void refresh() {
        if (this.fEditPart != null) {
            this.initializeValues();
        }
    }

    private void initializeValues() {
        this.initializing = true;
        this.gridController = GridController.getGridController(this.fEditPart);
        if (this.gridController != null) {
            this.fGridHeight = this.gridController.getGridHeight();
            this.fGridWidth = this.gridController.getGridWidth();
            this.fGridMargin = this.gridController.getGridMargin();
            if (this.fGridHeightScale != null) {
                this.fGridHeightScale.setSelection(this.fGridHeight);
            }
            if (this.fGridHeightText != null) {
                this.fGridHeightText.setText(String.valueOf(this.fGridHeight));
            }
            if (this.fGridWidthScale != null) {
                this.fGridWidthScale.setSelection(this.fGridWidth);
            }
            if (this.fGridWidthText != null) {
                this.fGridWidthText.setText(String.valueOf(this.fGridWidth));
            }
            if (this.fGridMarginScale != null) {
                this.fGridMarginScale.setSelection(this.fGridMargin);
            }
            if (this.fGridMarginText != null) {
                this.fGridMarginText.setText(String.valueOf(this.fGridMargin));
            }
            this.initializeSnapToGrid();
            this.initializing = false;
        }
    }

    private void initializeSnapToGrid() {
        EditPartViewer primaryViewer = this.fEditPart.getRoot().getViewer();
        Object snapToGrid = primaryViewer.getProperty("SnapToGrid.isEnabled");
        if (snapToGrid != null) {
            this.fSnapToGrid = (Boolean)snapToGrid;
        }
        this.fPropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("SnapToGrid.isEnabled")) {
                    AlignmentXYGridPropertiesPage.this.fSnapToGrid = (Boolean)evt.getNewValue();
                    AlignmentXYGridPropertiesPage.this.fSnapToGridCheckBox.setSelection(AlignmentXYGridPropertiesPage.this.fSnapToGrid);
                }
            }
        };
        primaryViewer.addPropertyChangeListener(this.fPropertyChangeListener);
        if (this.fSnapToGridCheckBox != null) {
            this.fSnapToGridCheckBox.setSelection(this.fSnapToGrid);
        }
    }

    public boolean isValidParent(EditPart parent) {
        IActionFilter af;
        Class<?> clazz;
        if (parent instanceof TreeEditPart) {
            EditPart ep;
            EditPartViewer viewer;
            EditDomain ed = EditDomain.getEditDomain(parent);
            IEditorPart iEditorPart = ed.getEditorPart();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.gef.EditPartViewer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((viewer = (EditPartViewer)iEditorPart.getAdapter((Class)clazz2)) != null && (ep = (EditPart)viewer.getEditPartRegistry().get(parent.getModel())) != null) {
                parent = ep;
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.IActionFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (af = (IActionFilter)parent.getAdapter((Class)clazz)) != null && af.testAttribute((Object)parent, "EDITPOLICY#LAYOUTPOLICY", "org.eclipse.ve.internal.cde.core.XYLayout");
    }

    public boolean isValidTarget(EditPart target) {
        IActionFilter af;
        Class<?> clazz;
        if (target instanceof TreeEditPart) {
            EditPart ep;
            EditPartViewer viewer;
            EditDomain ed = EditDomain.getEditDomain(target);
            IEditorPart iEditorPart = ed.getEditorPart();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.gef.EditPartViewer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((viewer = (EditPartViewer)iEditorPart.getAdapter((Class)clazz2)) != null && (ep = (EditPart)viewer.getEditPartRegistry().get(target.getModel())) != null) {
                target = ep;
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.IActionFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (af = (IActionFilter)target.getAdapter((Class)clazz)) != null && af.testAttribute((Object)target, "EDITPOLICY#LAYOUTPOLICY", "org.eclipse.ve.internal.cde.core.XYLayout");
    }

    protected boolean isInputValid() {
        this.fGridHeightText.setBackground(null);
        this.fGridWidthText.setBackground(null);
        this.fGridMarginText.setBackground(null);
        this.fMessageLine.setText("");
        try {
            this.fGridHeight = Integer.parseInt(this.fGridHeightText.getText());
            if (this.fGridHeight <= 1) {
                this.fGridHeightText.setBackground(ColorConstants.red);
                this.fMessageLine.setText(CDEMessages.AlignmentXYGridPropertiesPage_Height_Must_Be_Larger_Than_One);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.fGridHeightText.setBackground(ColorConstants.red);
            this.fMessageLine.setText(CDEMessages.AlignmentXYGridPropertiesPage_Height_Must_Be_Integer);
        }
        try {
            this.fGridWidth = Integer.parseInt(this.fGridWidthText.getText());
            if (this.fGridWidth <= 1) {
                this.fGridWidthText.setBackground(ColorConstants.red);
                this.fMessageLine.setText(CDEMessages.AlignmentXYGridPropertiesPage_Width_Must_Be_Larger_Than_One);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.fGridWidthText.setBackground(ColorConstants.red);
            this.fMessageLine.setText(CDEMessages.AlignmentXYGridPropertiesPage_Width_Must_Be_Integer);
        }
        try {
            this.fGridMargin = Integer.parseInt(this.fGridMarginText.getText());
            if (this.fGridMargin < 0) {
                this.fGridMarginText.setBackground(ColorConstants.red);
                this.fMessageLine.setText(CDEMessages.AlignmentXYGridPropertiesPage_Margin_Must_Be_Positive);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.fGridMarginText.setBackground(ColorConstants.red);
            this.fMessageLine.setText(CDEMessages.AlignmentXYGridPropertiesPage_Margin_Must_Be_Integer);
        }
        return this.fMessageLine.getText().length() <= 0;
    }

    protected boolean selectionIsContainer(ISelection oldSelection) {
        EditPart firstParent;
        List editparts;
        ISelection newSelection = this.getSelection();
        return newSelection != null && newSelection instanceof IStructuredSelection && !((IStructuredSelection)newSelection).isEmpty() && (editparts = ((IStructuredSelection)newSelection).toList()).size() == 1 && editparts.get(0) instanceof EditPart && this.isValidTarget(firstParent = (EditPart)editparts.get(0));
    }
}

