/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.cde.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ve.internal.cde.core.AlignmentCommandRequest;
import org.eclipse.ve.internal.cde.core.CDEMessages;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public class AlignmentAction
extends SelectionAction {
    private static final String[] resPrefixLabels = new String[]{CDEMessages.AlignmentAction_left_label, CDEMessages.AlignmentAction_center_label, CDEMessages.AlignmentAction_right_label, CDEMessages.AlignmentAction_top_label, CDEMessages.AlignmentAction_middle_label, CDEMessages.AlignmentAction_bottom_label, CDEMessages.AlignmentAction_width_label, CDEMessages.AlignmentAction_height_label};
    private static final String[] resPrefixTooltips = new String[]{CDEMessages.AlignmentAction_left_tooltip, CDEMessages.AlignmentAction_center_tooltip, CDEMessages.AlignmentAction_right_tooltip, CDEMessages.AlignmentAction_top_tooltip, CDEMessages.AlignmentAction_middle_tooltip, CDEMessages.AlignmentAction_bottom_tooltip, CDEMessages.AlignmentAction_width_tooltip, CDEMessages.AlignmentAction_height_tooltip};
    private static final String[] resPrefixImages = new String[]{"alignleft_obj.gif", "aligncenter_obj.gif", "alignright_obj.gif", "aligntop_obj.gif", "alignmiddle_obj.gif", "alignbottom_obj.gif", "alignwidth_obj.gif", "alignheight_obj.gif"};
    private static final String[] resPrefixIDs = new String[]{"AlignmentAction.left", "AlignmentAction.center.tooltip", "AlignmentAction.right.tooltip", "AlignmentAction.top.tooltip", "AlignmentAction.middle.tooltip", "AlignmentAction.bottom.tooltip", "AlignmentAction.width.tooltip", "AlignmentAction.height.tooltip"};
    protected int fAlignType;

    public AlignmentAction(int alignType) {
        super(null);
        this.fAlignType = alignType < 0 || alignType >= resPrefixLabels.length ? 0 : alignType;
        this.setText(resPrefixLabels[this.fAlignType]);
        this.setToolTipText(resPrefixTooltips[this.fAlignType]);
        String graphicName = resPrefixImages[this.fAlignType];
        this.setImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/elcl16/" + graphicName));
        this.setHoverImageDescriptor(this.getImageDescriptor());
        this.setDisabledImageDescriptor(CDEPlugin.getImageDescriptorFromPlugin((Plugin)CDEPlugin.getPlugin(), "icons/full/dlcl16/" + graphicName));
        this.setEnabled(false);
        this.setId(AlignmentAction.getActionId(this.fAlignType));
    }

    public static String getActionId(int alignType) {
        return alignType >= 0 && alignType < resPrefixLabels.length ? resPrefixIDs[alignType] : resPrefixIDs[0];
    }

    protected Command createAlignmentCommand(List objects) {
        if (objects.size() < 2) {
            return UnexecutableCommand.INSTANCE;
        }
        Iterator itr = objects.iterator();
        while (itr.hasNext()) {
            if (itr.next() instanceof EditPart) continue;
            return UnexecutableCommand.INSTANCE;
        }
        AlignmentCommandRequest alignReq = new AlignmentCommandRequest(this.fAlignType);
        ArrayList<EditPart> selectedParts = new ArrayList<EditPart>(objects.size() - 1);
        int i = 0;
        while (i < objects.size()) {
            EditPart editpart = (EditPart)objects.get(i);
            if (editpart.getSelected() == 2) {
                alignReq.setAnchorObject(editpart);
            } else {
                selectedParts.add(editpart);
            }
            ++i;
        }
        CompoundCommand compoundCmd = new CompoundCommand();
        int i2 = 0;
        while (i2 < selectedParts.size()) {
            EditPart editpart = (EditPart)selectedParts.get(i2);
            Command cmd = editpart.getCommand((Request)alignReq);
            if (cmd == null) {
                return UnexecutableCommand.INSTANCE;
            }
            compoundCmd.append(cmd);
            ++i2;
        }
        return compoundCmd;
    }

    public void run() {
        this.execute(this.createAlignmentCommand(this.getSelectedObjects()));
    }

    protected boolean calculateEnabled() {
        Command cmd = this.createAlignmentCommand(this.getSelectedObjects());
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    public void setWorkbenchPart(IWorkbenchPart part) {
        super.setWorkbenchPart(part);
    }
}

